import * as lambda from "../../aws-lambda";
import * as s3 from "../../aws-s3";
/**
 * @experimental
 */
export interface S3EventSourceProps {
    /**
     * (experimental) The s3 event types that will trigger the notification.
     *
     * @experimental
     */
    readonly events: s3.EventType[];
    /**
     * (experimental) S3 object key filter rules to determine which objects trigger this event.
     *
     * Each filter must include a `prefix` and/or `suffix` that will be matched
     * against the s3 object key. Refer to the S3 Developer Guide for details
     * about allowed filter rules.
     *
     * @experimental
     */
    readonly filters?: s3.NotificationKeyFilter[];
}
/**
 * (experimental) Use S3 bucket notifications as an event source for AWS Lambda.
 *
 * @experimental
 */
export declare class S3EventSource implements lambda.IEventSource {
    readonly bucket: s3.Bucket;
    private readonly props;
    /**
     * @experimental
     */
    constructor(bucket: s3.Bucket, props: S3EventSourceProps);
    /**
     * (experimental) Called by `lambda.addEventSource` to allow the event source to bind to this function.
     *
     * @experimental
     */
    bind(target: lambda.IFunction): void;
}
