import * as lambda from "../../aws-lambda";
import { Construct } from "../../core";
/**
 * (experimental) Options for a Lambda destination.
 *
 * @experimental
 */
export interface LambdaDestinationOptions {
    /**
     * (experimental) Whether the destination function receives only the `responsePayload` of the source function.
     *
     * When set to `true` and used as `onSuccess` destination, the destination
     * function will be invoked with the payload returned by the source function.
     *
     * When set to `true` and used as `onFailure` destination, the destination
     * function will be invoked with the error object returned by source function.
     *
     * See the README of this module to see a full explanation of this option.
     *
     * @default false The destination function receives the full invocation record.
     * @experimental
     */
    readonly responseOnly?: boolean;
}
/**
 * (experimental) Use a Lambda function as a Lambda destination.
 *
 * @experimental
 */
export declare class LambdaDestination implements lambda.IDestination {
    private readonly fn;
    private readonly options;
    /**
     * @experimental
     */
    constructor(fn: lambda.IFunction, options?: LambdaDestinationOptions);
    /**
     * (experimental) Returns a destination configuration.
     *
     * @experimental
     */
    bind(scope: Construct, fn: lambda.IFunction, options?: lambda.DestinationOptions): lambda.DestinationConfig;
}
