import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::LakeFormation::DataLakeSettings`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html
 * @external
 */
export interface CfnDataLakeSettingsProps {
    /**
     * `AWS::LakeFormation::DataLakeSettings.Admins`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-admins
     * @external
     */
    readonly admins?: Array<CfnDataLakeSettings.DataLakePrincipalProperty | cdk.IResolvable> | cdk.IResolvable | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::LakeFormation::DataLakeSettings`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html
 * @external
 * @cloudformationResource AWS::LakeFormation::DataLakeSettings
 */
export declare class CfnDataLakeSettings extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::LakeFormation::DataLakeSettings";
    /**
     * `AWS::LakeFormation::DataLakeSettings.Admins`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html#cfn-lakeformation-datalakesettings-admins
     * @external
     */
    admins: Array<CfnDataLakeSettings.DataLakePrincipalProperty | cdk.IResolvable> | cdk.IResolvable | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::LakeFormation::DataLakeSettings`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnDataLakeSettingsProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::LakeFormation::DataLakeSettings`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html
 * @external
 * @cloudformationResource AWS::LakeFormation::DataLakeSettings
 */
export declare namespace CfnDataLakeSettings {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-datalakesettings-datalakeprincipal.html
     * @external
     */
    interface DataLakePrincipalProperty {
        /**
         * `CfnDataLakeSettings.DataLakePrincipalProperty.DataLakePrincipalIdentifier`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-datalakesettings-datalakeprincipal.html#cfn-lakeformation-datalakesettings-datalakeprincipal-datalakeprincipalidentifier
         * @external
         */
        readonly dataLakePrincipalIdentifier?: string;
    }
}
/**
 * Properties for defining a `AWS::LakeFormation::Permissions`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html
 * @external
 */
export interface CfnPermissionsProps {
    /**
     * `AWS::LakeFormation::Permissions.DataLakePrincipal`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html#cfn-lakeformation-permissions-datalakeprincipal
     * @external
     */
    readonly dataLakePrincipal: CfnPermissions.DataLakePrincipalProperty | cdk.IResolvable;
    /**
     * `AWS::LakeFormation::Permissions.Resource`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html#cfn-lakeformation-permissions-resource
     * @external
     */
    readonly resource: CfnPermissions.ResourceProperty | cdk.IResolvable;
    /**
     * `AWS::LakeFormation::Permissions.Permissions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html#cfn-lakeformation-permissions-permissions
     * @external
     */
    readonly permissions?: string[];
    /**
     * `AWS::LakeFormation::Permissions.PermissionsWithGrantOption`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html#cfn-lakeformation-permissions-permissionswithgrantoption
     * @external
     */
    readonly permissionsWithGrantOption?: string[];
}
/**
 * A CloudFormation `AWS::LakeFormation::Permissions`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html
 * @external
 * @cloudformationResource AWS::LakeFormation::Permissions
 */
export declare class CfnPermissions extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::LakeFormation::Permissions";
    /**
     * `AWS::LakeFormation::Permissions.DataLakePrincipal`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html#cfn-lakeformation-permissions-datalakeprincipal
     * @external
     */
    dataLakePrincipal: CfnPermissions.DataLakePrincipalProperty | cdk.IResolvable;
    /**
     * `AWS::LakeFormation::Permissions.Resource`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html#cfn-lakeformation-permissions-resource
     * @external
     */
    resource: CfnPermissions.ResourceProperty | cdk.IResolvable;
    /**
     * `AWS::LakeFormation::Permissions.Permissions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html#cfn-lakeformation-permissions-permissions
     * @external
     */
    permissions: string[] | undefined;
    /**
     * `AWS::LakeFormation::Permissions.PermissionsWithGrantOption`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html#cfn-lakeformation-permissions-permissionswithgrantoption
     * @external
     */
    permissionsWithGrantOption: string[] | undefined;
    /**
     * Create a new `AWS::LakeFormation::Permissions`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPermissionsProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::LakeFormation::Permissions`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html
 * @external
 * @cloudformationResource AWS::LakeFormation::Permissions
 */
export declare namespace CfnPermissions {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-columnwildcard.html
     * @external
     */
    interface ColumnWildcardProperty {
        /**
         * `CfnPermissions.ColumnWildcardProperty.ExcludedColumnNames`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-columnwildcard.html#cfn-lakeformation-permissions-columnwildcard-excludedcolumnnames
         * @external
         */
        readonly excludedColumnNames?: string[];
    }
}
/**
 * A CloudFormation `AWS::LakeFormation::Permissions`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html
 * @external
 * @cloudformationResource AWS::LakeFormation::Permissions
 */
export declare namespace CfnPermissions {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-datalakeprincipal.html
     * @external
     */
    interface DataLakePrincipalProperty {
        /**
         * `CfnPermissions.DataLakePrincipalProperty.DataLakePrincipalIdentifier`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-datalakeprincipal.html#cfn-lakeformation-permissions-datalakeprincipal-datalakeprincipalidentifier
         * @external
         */
        readonly dataLakePrincipalIdentifier?: string;
    }
}
/**
 * A CloudFormation `AWS::LakeFormation::Permissions`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html
 * @external
 * @cloudformationResource AWS::LakeFormation::Permissions
 */
export declare namespace CfnPermissions {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-datalocationresource.html
     * @external
     */
    interface DataLocationResourceProperty {
        /**
         * `CfnPermissions.DataLocationResourceProperty.CatalogId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-datalocationresource.html#cfn-lakeformation-permissions-datalocationresource-catalogid
         * @external
         */
        readonly catalogId?: string;
        /**
         * `CfnPermissions.DataLocationResourceProperty.S3Resource`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-datalocationresource.html#cfn-lakeformation-permissions-datalocationresource-s3resource
         * @external
         */
        readonly s3Resource?: string;
    }
}
/**
 * A CloudFormation `AWS::LakeFormation::Permissions`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html
 * @external
 * @cloudformationResource AWS::LakeFormation::Permissions
 */
export declare namespace CfnPermissions {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-databaseresource.html
     * @external
     */
    interface DatabaseResourceProperty {
        /**
         * `CfnPermissions.DatabaseResourceProperty.CatalogId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-databaseresource.html#cfn-lakeformation-permissions-databaseresource-catalogid
         * @external
         */
        readonly catalogId?: string;
        /**
         * `CfnPermissions.DatabaseResourceProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-databaseresource.html#cfn-lakeformation-permissions-databaseresource-name
         * @external
         */
        readonly name?: string;
    }
}
/**
 * A CloudFormation `AWS::LakeFormation::Permissions`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html
 * @external
 * @cloudformationResource AWS::LakeFormation::Permissions
 */
export declare namespace CfnPermissions {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-resource.html
     * @external
     */
    interface ResourceProperty {
        /**
         * `CfnPermissions.ResourceProperty.DataLocationResource`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-resource.html#cfn-lakeformation-permissions-resource-datalocationresource
         * @external
         */
        readonly dataLocationResource?: CfnPermissions.DataLocationResourceProperty | cdk.IResolvable;
        /**
         * `CfnPermissions.ResourceProperty.DatabaseResource`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-resource.html#cfn-lakeformation-permissions-resource-databaseresource
         * @external
         */
        readonly databaseResource?: CfnPermissions.DatabaseResourceProperty | cdk.IResolvable;
        /**
         * `CfnPermissions.ResourceProperty.TableResource`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-resource.html#cfn-lakeformation-permissions-resource-tableresource
         * @external
         */
        readonly tableResource?: CfnPermissions.TableResourceProperty | cdk.IResolvable;
        /**
         * `CfnPermissions.ResourceProperty.TableWithColumnsResource`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-resource.html#cfn-lakeformation-permissions-resource-tablewithcolumnsresource
         * @external
         */
        readonly tableWithColumnsResource?: CfnPermissions.TableWithColumnsResourceProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::LakeFormation::Permissions`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html
 * @external
 * @cloudformationResource AWS::LakeFormation::Permissions
 */
export declare namespace CfnPermissions {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-tableresource.html
     * @external
     */
    interface TableResourceProperty {
        /**
         * `CfnPermissions.TableResourceProperty.CatalogId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-tableresource.html#cfn-lakeformation-permissions-tableresource-catalogid
         * @external
         */
        readonly catalogId?: string;
        /**
         * `CfnPermissions.TableResourceProperty.DatabaseName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-tableresource.html#cfn-lakeformation-permissions-tableresource-databasename
         * @external
         */
        readonly databaseName?: string;
        /**
         * `CfnPermissions.TableResourceProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-tableresource.html#cfn-lakeformation-permissions-tableresource-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnPermissions.TableResourceProperty.TableWildcard`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-tableresource.html#cfn-lakeformation-permissions-tableresource-tablewildcard
         * @external
         */
        readonly tableWildcard?: CfnPermissions.TableWildcardProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::LakeFormation::Permissions`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html
 * @external
 * @cloudformationResource AWS::LakeFormation::Permissions
 */
export declare namespace CfnPermissions {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-tablewildcard.html
     * @external
     */
    interface TableWildcardProperty {
    }
}
/**
 * A CloudFormation `AWS::LakeFormation::Permissions`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html
 * @external
 * @cloudformationResource AWS::LakeFormation::Permissions
 */
export declare namespace CfnPermissions {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-tablewithcolumnsresource.html
     * @external
     */
    interface TableWithColumnsResourceProperty {
        /**
         * `CfnPermissions.TableWithColumnsResourceProperty.CatalogId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-tablewithcolumnsresource.html#cfn-lakeformation-permissions-tablewithcolumnsresource-catalogid
         * @external
         */
        readonly catalogId?: string;
        /**
         * `CfnPermissions.TableWithColumnsResourceProperty.ColumnNames`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-tablewithcolumnsresource.html#cfn-lakeformation-permissions-tablewithcolumnsresource-columnnames
         * @external
         */
        readonly columnNames?: string[];
        /**
         * `CfnPermissions.TableWithColumnsResourceProperty.ColumnWildcard`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-tablewithcolumnsresource.html#cfn-lakeformation-permissions-tablewithcolumnsresource-columnwildcard
         * @external
         */
        readonly columnWildcard?: CfnPermissions.ColumnWildcardProperty | cdk.IResolvable;
        /**
         * `CfnPermissions.TableWithColumnsResourceProperty.DatabaseName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-tablewithcolumnsresource.html#cfn-lakeformation-permissions-tablewithcolumnsresource-databasename
         * @external
         */
        readonly databaseName?: string;
        /**
         * `CfnPermissions.TableWithColumnsResourceProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-tablewithcolumnsresource.html#cfn-lakeformation-permissions-tablewithcolumnsresource-name
         * @external
         */
        readonly name?: string;
    }
}
/**
 * Properties for defining a `AWS::LakeFormation::Resource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-resource.html
 * @external
 */
export interface CfnResourceProps {
    /**
     * `AWS::LakeFormation::Resource.ResourceArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-resource.html#cfn-lakeformation-resource-resourcearn
     * @external
     */
    readonly resourceArn: string;
    /**
     * `AWS::LakeFormation::Resource.UseServiceLinkedRole`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-resource.html#cfn-lakeformation-resource-useservicelinkedrole
     * @external
     */
    readonly useServiceLinkedRole: boolean | cdk.IResolvable;
    /**
     * `AWS::LakeFormation::Resource.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-resource.html#cfn-lakeformation-resource-rolearn
     * @external
     */
    readonly roleArn?: string;
}
/**
 * A CloudFormation `AWS::LakeFormation::Resource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-resource.html
 * @external
 * @cloudformationResource AWS::LakeFormation::Resource
 */
export declare class CfnResource extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::LakeFormation::Resource";
    /**
     * `AWS::LakeFormation::Resource.ResourceArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-resource.html#cfn-lakeformation-resource-resourcearn
     * @external
     */
    resourceArn: string;
    /**
     * `AWS::LakeFormation::Resource.UseServiceLinkedRole`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-resource.html#cfn-lakeformation-resource-useservicelinkedrole
     * @external
     */
    useServiceLinkedRole: boolean | cdk.IResolvable;
    /**
     * `AWS::LakeFormation::Resource.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-resource.html#cfn-lakeformation-resource-rolearn
     * @external
     */
    roleArn: string | undefined;
    /**
     * Create a new `AWS::LakeFormation::Resource`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnResourceProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
