"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ViaServicePrincipal = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
/**
 * (experimental) A principal to allow access to a key if it's being used through another AWS service.
 *
 * @experimental
 */
class ViaServicePrincipal extends iam.PrincipalBase {
    /**
     * @experimental
     */
    constructor(serviceName, basePrincipal) {
        super();
        this.serviceName = serviceName;
        this.basePrincipal = basePrincipal ? basePrincipal : new iam.AnyPrincipal();
    }
    /**
     * (experimental) Return the policy fragment that identifies this principal in a Policy.
     *
     * @experimental
     */
    get policyFragment() {
        // Make a copy of the base policyFragment to add a condition to it
        const base = this.basePrincipal.policyFragment;
        const conditions = Object.assign({}, base.conditions);
        if (conditions.StringEquals) {
            conditions.StringEquals = Object.assign({ 'kms:ViaService': this.serviceName }, conditions.StringEquals);
        }
        else {
            conditions.StringEquals = { 'kms:ViaService': this.serviceName };
        }
        return { principalJson: base.principalJson, conditions };
    }
}
exports.ViaServicePrincipal = ViaServicePrincipal;
//# sourceMappingURL=data:application/json;base64,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