import * as iam from "../../aws-iam";
import { IResource, RemovalPolicy, Resource } from "../../core";
import { Construct } from 'constructs';
import { Alias } from './alias';
/**
 * (experimental) A KMS Key, either managed by this CDK app, or imported.
 *
 * @experimental
 */
export interface IKey extends IResource {
    /**
     * (experimental) The ARN of the key.
     *
     * @experimental
     * @attribute true
     */
    readonly keyArn: string;
    /**
     * (experimental) The ID of the key (the part that looks something like: 1234abcd-12ab-34cd-56ef-1234567890ab).
     *
     * @experimental
     * @attribute true
     */
    readonly keyId: string;
    /**
     * (experimental) Defines a new alias for the key.
     *
     * @experimental
     */
    addAlias(alias: string): Alias;
    /**
     * (experimental) Adds a statement to the KMS key resource policy.
     *
     * @param statement The policy statement to add.
     * @param allowNoOp If this is set to `false` and there is no policy defined (i.e. external key), the operation will fail. Otherwise, it will no-op.
     * @experimental
     */
    addToResourcePolicy(statement: iam.PolicyStatement, allowNoOp?: boolean): iam.AddToResourcePolicyResult;
    /**
     * (experimental) Grant the indicated permissions on this key to the given principal.
     *
     * @experimental
     */
    grant(grantee: iam.IGrantable, ...actions: string[]): iam.Grant;
    /**
     * (experimental) Grant decryption permisisons using this key to the given principal.
     *
     * @experimental
     */
    grantDecrypt(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant encryption permisisons using this key to the given principal.
     *
     * @experimental
     */
    grantEncrypt(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant encryption and decryption permisisons using this key to the given principal.
     *
     * @experimental
     */
    grantEncryptDecrypt(grantee: iam.IGrantable): iam.Grant;
}
declare abstract class KeyBase extends Resource implements IKey {
    /**
     * The ARN of the key.
     */
    abstract readonly keyArn: string;
    abstract readonly keyId: string;
    /**
     * Optional policy document that represents the resource policy of this key.
     *
     * If specified, addToResourcePolicy can be used to edit this policy.
     * Otherwise this method will no-op.
     */
    protected abstract readonly policy?: iam.PolicyDocument;
    /**
     * Optional property to control trusting account identities.
     *
     * If specified grants will default identity policies instead of to both
     * resource and identity policies.
     */
    protected abstract readonly trustAccountIdentities: boolean;
    /**
     * Collection of aliases added to the key
     *
     * Tracked to determine whether or not the aliasName should be added to the end of its ID
     */
    private readonly aliases;
    /**
     * (experimental) Defines a new alias for the key.
     *
     * @experimental
     */
    addAlias(aliasName: string): Alias;
    /**
     * (experimental) Adds a statement to the KMS key resource policy.
     *
     * @param statement The policy statement to add.
     * @param allowNoOp If this is set to `false` and there is no policy defined (i.e. external key), the operation will fail. Otherwise, it will no-op.
     * @experimental
     */
    addToResourcePolicy(statement: iam.PolicyStatement, allowNoOp?: boolean): iam.AddToResourcePolicyResult;
    /**
     * (experimental) Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     *
     * @experimental
     */
    protected validate(): string[];
    /**
     * (experimental) Grant the indicated permissions on this key to the given principal.
     *
     * This modifies both the principal's policy as well as the resource policy,
     * since the default CloudFormation setup for KMS keys is that the policy
     * must not be empty and so default grants won't work.
     *
     * @experimental
     */
    grant(grantee: iam.IGrantable, ...actions: string[]): iam.Grant;
    /**
     * (experimental) Grant decryption permisisons using this key to the given principal.
     *
     * @experimental
     */
    grantDecrypt(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant encryption permisisons using this key to the given principal.
     *
     * @experimental
     */
    grantEncrypt(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant encryption and decryption permisisons using this key to the given principal.
     *
     * @experimental
     */
    grantEncryptDecrypt(grantee: iam.IGrantable): iam.Grant;
    /**
     * Checks whether the grantee belongs to a stack that will be deployed
     * after the stack containing this key.
     *
     * @param grantee the grantee to give permissions to
     * @returns the account ID of the grantee stack if its stack does depend on this stack,
     *   undefined otherwise
     */
    private granteeStackDependsOnKeyStack;
    private principalIsANewlyCreatedResource;
    private isGranteeFromAnotherRegion;
    private isGranteeFromAnotherAccount;
}
/**
 * (experimental) Construction properties for a KMS Key object.
 *
 * @experimental
 */
export interface KeyProps {
    /**
     * (experimental) A description of the key.
     *
     * Use a description that helps your users decide
     * whether the key is appropriate for a particular task.
     *
     * @default - No description.
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) Initial alias to add to the key.
     *
     * More aliases can be added later by calling `addAlias`.
     *
     * @default - No alias is added for the key.
     * @experimental
     */
    readonly alias?: string;
    /**
     * (experimental) Indicates whether AWS KMS rotates the key.
     *
     * @default false
     * @experimental
     */
    readonly enableKeyRotation?: boolean;
    /**
     * (experimental) Indicates whether the key is available for use.
     *
     * @default - Key is enabled.
     * @experimental
     */
    readonly enabled?: boolean;
    /**
     * (experimental) Custom policy document to attach to the KMS key.
     *
     * @default - A policy document with permissions for the account root to
     * administer the key will be created.
     * @experimental
     */
    readonly policy?: iam.PolicyDocument;
    /**
     * (experimental) Whether the encryption key should be retained when it is removed from the Stack.
     *
     * This is useful when one wants to
     * retain access to data that was encrypted with a key that is being retired.
     *
     * @default RemovalPolicy.Retain
     * @experimental
     */
    readonly removalPolicy?: RemovalPolicy;
    /**
     * (experimental) Whether the key usage can be granted by IAM policies.
     *
     * Setting this to true adds a default statement which delegates key
     * access control completely to the identity's IAM policy (similar
     * to how it works for other AWS resources).
     *
     * @default false
     * @see https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam
     * @experimental
     */
    readonly trustAccountIdentities?: boolean;
}
/**
 * (experimental) Defines a KMS key.
 *
 * @experimental
 * @resource AWS::KMS::Key
 */
export declare class Key extends KeyBase {
    /**
     * (experimental) Import an externally defined KMS Key using its ARN.
     *
     * @param scope the construct that will "own" the imported key.
     * @param id the id of the imported key in the construct tree.
     * @param keyArn the ARN of an existing KMS key.
     * @experimental
     */
    static fromKeyArn(scope: Construct, id: string, keyArn: string): IKey;
    /**
     * (experimental) The ARN of the key.
     *
     * @experimental
     */
    readonly keyArn: string;
    /**
     * (experimental) The ID of the key (the part that looks something like: 1234abcd-12ab-34cd-56ef-1234567890ab).
     *
     * @experimental
     */
    readonly keyId: string;
    /**
     * (experimental) Optional policy document that represents the resource policy of this key.
     *
     * If specified, addToResourcePolicy can be used to edit this policy.
     * Otherwise this method will no-op.
     *
     * @experimental
     */
    protected readonly policy?: iam.PolicyDocument;
    /**
     * (experimental) Optional property to control trusting account identities.
     *
     * If specified grants will default identity policies instead of to both
     * resource and identity policies.
     *
     * @experimental
     */
    protected readonly trustAccountIdentities: boolean;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KeyProps);
    private allowAccountIdentitiesToControl;
    /**
     * Let users or IAM policies from this account admin this key.
     * @link https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default
     * @link https://aws.amazon.com/premiumsupport/knowledge-center/update-key-policy-future/
     */
    private allowAccountToAdmin;
}
export {};
