import * as iam from "../../aws-iam";
import { RemovalPolicy, Resource } from "../../core";
import { Construct } from 'constructs';
import { IKey } from './key';
/**
 * (experimental) A KMS Key alias.
 *
 * An alias can be used in all places that expect a key.
 *
 * @experimental
 */
export interface IAlias extends IKey {
    /**
     * (experimental) The name of the alias.
     *
     * @experimental
     * @attribute true
     */
    readonly aliasName: string;
    /**
     * (experimental) The Key to which the Alias refers.
     *
     * @experimental
     * @attribute true
     */
    readonly aliasTargetKey: IKey;
}
/**
 * (experimental) Construction properties for a KMS Key Alias object.
 *
 * @experimental
 */
export interface AliasProps {
    /**
     * (experimental) The name of the alias.
     *
     * The name must start with alias followed by a
     * forward slash, such as alias/. You can't specify aliases that begin with
     * alias/AWS. These aliases are reserved.
     *
     * @experimental
     */
    readonly aliasName: string;
    /**
     * (experimental) The ID of the key for which you are creating the alias.
     *
     * Specify the key's
     * globally unique identifier or Amazon Resource Name (ARN). You can't
     * specify another alias.
     *
     * @experimental
     */
    readonly targetKey: IKey;
    /**
     * (experimental) Policy to apply when the alias is removed from this stack.
     *
     * @default - The alias will be deleted
     * @experimental
     */
    readonly removalPolicy?: RemovalPolicy;
}
declare abstract class AliasBase extends Resource implements IAlias {
    abstract readonly aliasName: string;
    abstract readonly aliasTargetKey: IKey;
    /**
     * (experimental) The ARN of the key.
     *
     * @experimental
     */
    get keyArn(): string;
    /**
     * (experimental) The ID of the key (the part that looks something like: 1234abcd-12ab-34cd-56ef-1234567890ab).
     *
     * @experimental
     */
    get keyId(): string;
    /**
     * (experimental) Defines a new alias for the key.
     *
     * @experimental
     */
    addAlias(alias: string): Alias;
    /**
     * (experimental) Adds a statement to the KMS key resource policy.
     *
     * @experimental
     */
    addToResourcePolicy(statement: iam.PolicyStatement, allowNoOp?: boolean): iam.AddToResourcePolicyResult;
    /**
     * (experimental) Grant the indicated permissions on this key to the given principal.
     *
     * @experimental
     */
    grant(grantee: iam.IGrantable, ...actions: string[]): iam.Grant;
    /**
     * (experimental) Grant decryption permisisons using this key to the given principal.
     *
     * @experimental
     */
    grantDecrypt(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant encryption permisisons using this key to the given principal.
     *
     * @experimental
     */
    grantEncrypt(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant encryption and decryption permisisons using this key to the given principal.
     *
     * @experimental
     */
    grantEncryptDecrypt(grantee: iam.IGrantable): iam.Grant;
}
/**
 * (experimental) Properties of a reference to an existing KMS Alias.
 *
 * @experimental
 */
export interface AliasAttributes {
    /**
     * (experimental) Specifies the alias name.
     *
     * This value must begin with alias/ followed by a name (i.e. alias/ExampleAlias)
     *
     * @experimental
     */
    readonly aliasName: string;
    /**
     * (experimental) The customer master key (CMK) to which the Alias refers.
     *
     * @experimental
     */
    readonly aliasTargetKey: IKey;
}
/**
 * (experimental) Defines a display name for a customer master key (CMK) in AWS Key Management Service (AWS KMS).
 *
 * Using an alias to refer to a key can help you simplify key
 * management. For example, when rotating keys, you can just update the alias
 * mapping instead of tracking and changing key IDs. For more information, see
 * Working with Aliases in the AWS Key Management Service Developer Guide.
 *
 * You can also add an alias for a key by calling `key.addAlias(alias)`.
 *
 * @experimental
 * @resource AWS::KMS::Alias
 */
export declare class Alias extends AliasBase {
    /**
     * (experimental) Import an existing KMS Alias defined outside the CDK app.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param attrs the properties of the referenced KMS Alias.
     * @experimental
     */
    static fromAliasAttributes(scope: Construct, id: string, attrs: AliasAttributes): IAlias;
    /**
     * (experimental) Import an existing KMS Alias defined outside the CDK app, by the alias name.
     *
     * This method should be used
     * instead of 'fromAliasAttributes' when the underlying KMS Key ARN is not available.
     * This Alias will not have a direct reference to the KMS Key, so addAlias and grant* methods are not supported.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param aliasName The full name of the KMS Alias (e.g., 'alias/aws/s3', 'alias/myKeyAlias').
     * @experimental
     */
    static fromAliasName(scope: Construct, id: string, aliasName: string): IAlias;
    /**
     * (experimental) The name of the alias.
     *
     * @experimental
     */
    readonly aliasName: string;
    /**
     * (experimental) The Key to which the Alias refers.
     *
     * @experimental
     */
    readonly aliasTargetKey: IKey;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: AliasProps);
    /**
     * @experimental
     */
    protected generatePhysicalName(): string;
}
export {};
