import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::KinesisAnalyticsV2::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 * @external
 */
export interface CfnApplicationV2Props {
    /**
     * `AWS::KinesisAnalyticsV2::Application.RuntimeEnvironment`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-runtimeenvironment
     * @external
     */
    readonly runtimeEnvironment: string;
    /**
     * `AWS::KinesisAnalyticsV2::Application.ServiceExecutionRole`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-serviceexecutionrole
     * @external
     */
    readonly serviceExecutionRole: string;
    /**
     * `AWS::KinesisAnalyticsV2::Application.ApplicationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationconfiguration
     * @external
     */
    readonly applicationConfiguration?: CfnApplicationV2.ApplicationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::KinesisAnalyticsV2::Application.ApplicationDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationdescription
     * @external
     */
    readonly applicationDescription?: string;
    /**
     * `AWS::KinesisAnalyticsV2::Application.ApplicationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationname
     * @external
     */
    readonly applicationName?: string;
    /**
     * `AWS::KinesisAnalyticsV2::Application.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::Application
 */
export declare class CfnApplicationV2 extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::KinesisAnalyticsV2::Application";
    /**
     * `AWS::KinesisAnalyticsV2::Application.RuntimeEnvironment`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-runtimeenvironment
     * @external
     */
    runtimeEnvironment: string;
    /**
     * `AWS::KinesisAnalyticsV2::Application.ServiceExecutionRole`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-serviceexecutionrole
     * @external
     */
    serviceExecutionRole: string;
    /**
     * `AWS::KinesisAnalyticsV2::Application.ApplicationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationconfiguration
     * @external
     */
    applicationConfiguration: CfnApplicationV2.ApplicationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::KinesisAnalyticsV2::Application.ApplicationDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationdescription
     * @external
     */
    applicationDescription: string | undefined;
    /**
     * `AWS::KinesisAnalyticsV2::Application.ApplicationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationname
     * @external
     */
    applicationName: string | undefined;
    /**
     * `AWS::KinesisAnalyticsV2::Application.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::KinesisAnalyticsV2::Application`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApplicationV2Props);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::Application
 */
export declare namespace CfnApplicationV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationcodeconfiguration.html
     * @external
     */
    interface ApplicationCodeConfigurationProperty {
        /**
         * `CfnApplicationV2.ApplicationCodeConfigurationProperty.CodeContent`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationcodeconfiguration.html#cfn-kinesisanalyticsv2-application-applicationcodeconfiguration-codecontent
         * @external
         */
        readonly codeContent: CfnApplicationV2.CodeContentProperty | cdk.IResolvable;
        /**
         * `CfnApplicationV2.ApplicationCodeConfigurationProperty.CodeContentType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationcodeconfiguration.html#cfn-kinesisanalyticsv2-application-applicationcodeconfiguration-codecontenttype
         * @external
         */
        readonly codeContentType: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::Application
 */
export declare namespace CfnApplicationV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationconfiguration.html
     * @external
     */
    interface ApplicationConfigurationProperty {
        /**
         * `CfnApplicationV2.ApplicationConfigurationProperty.ApplicationCodeConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationconfiguration.html#cfn-kinesisanalyticsv2-application-applicationconfiguration-applicationcodeconfiguration
         * @external
         */
        readonly applicationCodeConfiguration?: CfnApplicationV2.ApplicationCodeConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnApplicationV2.ApplicationConfigurationProperty.ApplicationSnapshotConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationconfiguration.html#cfn-kinesisanalyticsv2-application-applicationconfiguration-applicationsnapshotconfiguration
         * @external
         */
        readonly applicationSnapshotConfiguration?: CfnApplicationV2.ApplicationSnapshotConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnApplicationV2.ApplicationConfigurationProperty.EnvironmentProperties`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationconfiguration.html#cfn-kinesisanalyticsv2-application-applicationconfiguration-environmentproperties
         * @external
         */
        readonly environmentProperties?: CfnApplicationV2.EnvironmentPropertiesProperty | cdk.IResolvable;
        /**
         * `CfnApplicationV2.ApplicationConfigurationProperty.FlinkApplicationConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationconfiguration.html#cfn-kinesisanalyticsv2-application-applicationconfiguration-flinkapplicationconfiguration
         * @external
         */
        readonly flinkApplicationConfiguration?: CfnApplicationV2.FlinkApplicationConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnApplicationV2.ApplicationConfigurationProperty.SqlApplicationConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationconfiguration.html#cfn-kinesisanalyticsv2-application-applicationconfiguration-sqlapplicationconfiguration
         * @external
         */
        readonly sqlApplicationConfiguration?: CfnApplicationV2.SqlApplicationConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::Application
 */
export declare namespace CfnApplicationV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationsnapshotconfiguration.html
     * @external
     */
    interface ApplicationSnapshotConfigurationProperty {
        /**
         * `CfnApplicationV2.ApplicationSnapshotConfigurationProperty.SnapshotsEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationsnapshotconfiguration.html#cfn-kinesisanalyticsv2-application-applicationsnapshotconfiguration-snapshotsenabled
         * @external
         */
        readonly snapshotsEnabled: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::Application
 */
export declare namespace CfnApplicationV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-csvmappingparameters.html
     * @external
     */
    interface CSVMappingParametersProperty {
        /**
         * `CfnApplicationV2.CSVMappingParametersProperty.RecordColumnDelimiter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-csvmappingparameters.html#cfn-kinesisanalyticsv2-application-csvmappingparameters-recordcolumndelimiter
         * @external
         */
        readonly recordColumnDelimiter: string;
        /**
         * `CfnApplicationV2.CSVMappingParametersProperty.RecordRowDelimiter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-csvmappingparameters.html#cfn-kinesisanalyticsv2-application-csvmappingparameters-recordrowdelimiter
         * @external
         */
        readonly recordRowDelimiter: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::Application
 */
export declare namespace CfnApplicationV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-checkpointconfiguration.html
     * @external
     */
    interface CheckpointConfigurationProperty {
        /**
         * `CfnApplicationV2.CheckpointConfigurationProperty.CheckpointInterval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-checkpointconfiguration.html#cfn-kinesisanalyticsv2-application-checkpointconfiguration-checkpointinterval
         * @external
         */
        readonly checkpointInterval?: number;
        /**
         * `CfnApplicationV2.CheckpointConfigurationProperty.CheckpointingEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-checkpointconfiguration.html#cfn-kinesisanalyticsv2-application-checkpointconfiguration-checkpointingenabled
         * @external
         */
        readonly checkpointingEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnApplicationV2.CheckpointConfigurationProperty.ConfigurationType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-checkpointconfiguration.html#cfn-kinesisanalyticsv2-application-checkpointconfiguration-configurationtype
         * @external
         */
        readonly configurationType: string;
        /**
         * `CfnApplicationV2.CheckpointConfigurationProperty.MinPauseBetweenCheckpoints`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-checkpointconfiguration.html#cfn-kinesisanalyticsv2-application-checkpointconfiguration-minpausebetweencheckpoints
         * @external
         */
        readonly minPauseBetweenCheckpoints?: number;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::Application
 */
export declare namespace CfnApplicationV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-codecontent.html
     * @external
     */
    interface CodeContentProperty {
        /**
         * `CfnApplicationV2.CodeContentProperty.S3ContentLocation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-codecontent.html#cfn-kinesisanalyticsv2-application-codecontent-s3contentlocation
         * @external
         */
        readonly s3ContentLocation?: CfnApplicationV2.S3ContentLocationProperty | cdk.IResolvable;
        /**
         * `CfnApplicationV2.CodeContentProperty.TextContent`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-codecontent.html#cfn-kinesisanalyticsv2-application-codecontent-textcontent
         * @external
         */
        readonly textContent?: string;
        /**
         * `CfnApplicationV2.CodeContentProperty.ZipFileContent`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-codecontent.html#cfn-kinesisanalyticsv2-application-codecontent-zipfilecontent
         * @external
         */
        readonly zipFileContent?: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::Application
 */
export declare namespace CfnApplicationV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-environmentproperties.html
     * @external
     */
    interface EnvironmentPropertiesProperty {
        /**
         * `CfnApplicationV2.EnvironmentPropertiesProperty.PropertyGroups`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-environmentproperties.html#cfn-kinesisanalyticsv2-application-environmentproperties-propertygroups
         * @external
         */
        readonly propertyGroups?: Array<CfnApplicationV2.PropertyGroupProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::Application
 */
export declare namespace CfnApplicationV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-flinkapplicationconfiguration.html
     * @external
     */
    interface FlinkApplicationConfigurationProperty {
        /**
         * `CfnApplicationV2.FlinkApplicationConfigurationProperty.CheckpointConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-flinkapplicationconfiguration.html#cfn-kinesisanalyticsv2-application-flinkapplicationconfiguration-checkpointconfiguration
         * @external
         */
        readonly checkpointConfiguration?: CfnApplicationV2.CheckpointConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnApplicationV2.FlinkApplicationConfigurationProperty.MonitoringConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-flinkapplicationconfiguration.html#cfn-kinesisanalyticsv2-application-flinkapplicationconfiguration-monitoringconfiguration
         * @external
         */
        readonly monitoringConfiguration?: CfnApplicationV2.MonitoringConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnApplicationV2.FlinkApplicationConfigurationProperty.ParallelismConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-flinkapplicationconfiguration.html#cfn-kinesisanalyticsv2-application-flinkapplicationconfiguration-parallelismconfiguration
         * @external
         */
        readonly parallelismConfiguration?: CfnApplicationV2.ParallelismConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::Application
 */
export declare namespace CfnApplicationV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-input.html
     * @external
     */
    interface InputProperty {
        /**
         * `CfnApplicationV2.InputProperty.InputParallelism`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-input.html#cfn-kinesisanalyticsv2-application-input-inputparallelism
         * @external
         */
        readonly inputParallelism?: CfnApplicationV2.InputParallelismProperty | cdk.IResolvable;
        /**
         * `CfnApplicationV2.InputProperty.InputProcessingConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-input.html#cfn-kinesisanalyticsv2-application-input-inputprocessingconfiguration
         * @external
         */
        readonly inputProcessingConfiguration?: CfnApplicationV2.InputProcessingConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnApplicationV2.InputProperty.InputSchema`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-input.html#cfn-kinesisanalyticsv2-application-input-inputschema
         * @external
         */
        readonly inputSchema: CfnApplicationV2.InputSchemaProperty | cdk.IResolvable;
        /**
         * `CfnApplicationV2.InputProperty.KinesisFirehoseInput`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-input.html#cfn-kinesisanalyticsv2-application-input-kinesisfirehoseinput
         * @external
         */
        readonly kinesisFirehoseInput?: CfnApplicationV2.KinesisFirehoseInputProperty | cdk.IResolvable;
        /**
         * `CfnApplicationV2.InputProperty.KinesisStreamsInput`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-input.html#cfn-kinesisanalyticsv2-application-input-kinesisstreamsinput
         * @external
         */
        readonly kinesisStreamsInput?: CfnApplicationV2.KinesisStreamsInputProperty | cdk.IResolvable;
        /**
         * `CfnApplicationV2.InputProperty.NamePrefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-input.html#cfn-kinesisanalyticsv2-application-input-nameprefix
         * @external
         */
        readonly namePrefix: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::Application
 */
export declare namespace CfnApplicationV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputlambdaprocessor.html
     * @external
     */
    interface InputLambdaProcessorProperty {
        /**
         * `CfnApplicationV2.InputLambdaProcessorProperty.ResourceARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputlambdaprocessor.html#cfn-kinesisanalyticsv2-application-inputlambdaprocessor-resourcearn
         * @external
         */
        readonly resourceArn: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::Application
 */
export declare namespace CfnApplicationV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputparallelism.html
     * @external
     */
    interface InputParallelismProperty {
        /**
         * `CfnApplicationV2.InputParallelismProperty.Count`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputparallelism.html#cfn-kinesisanalyticsv2-application-inputparallelism-count
         * @external
         */
        readonly count?: number;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::Application
 */
export declare namespace CfnApplicationV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputprocessingconfiguration.html
     * @external
     */
    interface InputProcessingConfigurationProperty {
        /**
         * `CfnApplicationV2.InputProcessingConfigurationProperty.InputLambdaProcessor`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputprocessingconfiguration.html#cfn-kinesisanalyticsv2-application-inputprocessingconfiguration-inputlambdaprocessor
         * @external
         */
        readonly inputLambdaProcessor?: CfnApplicationV2.InputLambdaProcessorProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::Application
 */
export declare namespace CfnApplicationV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputschema.html
     * @external
     */
    interface InputSchemaProperty {
        /**
         * `CfnApplicationV2.InputSchemaProperty.RecordColumns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputschema.html#cfn-kinesisanalyticsv2-application-inputschema-recordcolumns
         * @external
         */
        readonly recordColumns: Array<CfnApplicationV2.RecordColumnProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnApplicationV2.InputSchemaProperty.RecordEncoding`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputschema.html#cfn-kinesisanalyticsv2-application-inputschema-recordencoding
         * @external
         */
        readonly recordEncoding?: string;
        /**
         * `CfnApplicationV2.InputSchemaProperty.RecordFormat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputschema.html#cfn-kinesisanalyticsv2-application-inputschema-recordformat
         * @external
         */
        readonly recordFormat: CfnApplicationV2.RecordFormatProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::Application
 */
export declare namespace CfnApplicationV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-jsonmappingparameters.html
     * @external
     */
    interface JSONMappingParametersProperty {
        /**
         * `CfnApplicationV2.JSONMappingParametersProperty.RecordRowPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-jsonmappingparameters.html#cfn-kinesisanalyticsv2-application-jsonmappingparameters-recordrowpath
         * @external
         */
        readonly recordRowPath: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::Application
 */
export declare namespace CfnApplicationV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-kinesisfirehoseinput.html
     * @external
     */
    interface KinesisFirehoseInputProperty {
        /**
         * `CfnApplicationV2.KinesisFirehoseInputProperty.ResourceARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-kinesisfirehoseinput.html#cfn-kinesisanalyticsv2-application-kinesisfirehoseinput-resourcearn
         * @external
         */
        readonly resourceArn: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::Application
 */
export declare namespace CfnApplicationV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-kinesisstreamsinput.html
     * @external
     */
    interface KinesisStreamsInputProperty {
        /**
         * `CfnApplicationV2.KinesisStreamsInputProperty.ResourceARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-kinesisstreamsinput.html#cfn-kinesisanalyticsv2-application-kinesisstreamsinput-resourcearn
         * @external
         */
        readonly resourceArn: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::Application
 */
export declare namespace CfnApplicationV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-mappingparameters.html
     * @external
     */
    interface MappingParametersProperty {
        /**
         * `CfnApplicationV2.MappingParametersProperty.CSVMappingParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-mappingparameters.html#cfn-kinesisanalyticsv2-application-mappingparameters-csvmappingparameters
         * @external
         */
        readonly csvMappingParameters?: CfnApplicationV2.CSVMappingParametersProperty | cdk.IResolvable;
        /**
         * `CfnApplicationV2.MappingParametersProperty.JSONMappingParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-mappingparameters.html#cfn-kinesisanalyticsv2-application-mappingparameters-jsonmappingparameters
         * @external
         */
        readonly jsonMappingParameters?: CfnApplicationV2.JSONMappingParametersProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::Application
 */
export declare namespace CfnApplicationV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-monitoringconfiguration.html
     * @external
     */
    interface MonitoringConfigurationProperty {
        /**
         * `CfnApplicationV2.MonitoringConfigurationProperty.ConfigurationType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-monitoringconfiguration.html#cfn-kinesisanalyticsv2-application-monitoringconfiguration-configurationtype
         * @external
         */
        readonly configurationType: string;
        /**
         * `CfnApplicationV2.MonitoringConfigurationProperty.LogLevel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-monitoringconfiguration.html#cfn-kinesisanalyticsv2-application-monitoringconfiguration-loglevel
         * @external
         */
        readonly logLevel?: string;
        /**
         * `CfnApplicationV2.MonitoringConfigurationProperty.MetricsLevel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-monitoringconfiguration.html#cfn-kinesisanalyticsv2-application-monitoringconfiguration-metricslevel
         * @external
         */
        readonly metricsLevel?: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::Application
 */
export declare namespace CfnApplicationV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-parallelismconfiguration.html
     * @external
     */
    interface ParallelismConfigurationProperty {
        /**
         * `CfnApplicationV2.ParallelismConfigurationProperty.AutoScalingEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-parallelismconfiguration.html#cfn-kinesisanalyticsv2-application-parallelismconfiguration-autoscalingenabled
         * @external
         */
        readonly autoScalingEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnApplicationV2.ParallelismConfigurationProperty.ConfigurationType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-parallelismconfiguration.html#cfn-kinesisanalyticsv2-application-parallelismconfiguration-configurationtype
         * @external
         */
        readonly configurationType: string;
        /**
         * `CfnApplicationV2.ParallelismConfigurationProperty.Parallelism`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-parallelismconfiguration.html#cfn-kinesisanalyticsv2-application-parallelismconfiguration-parallelism
         * @external
         */
        readonly parallelism?: number;
        /**
         * `CfnApplicationV2.ParallelismConfigurationProperty.ParallelismPerKPU`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-parallelismconfiguration.html#cfn-kinesisanalyticsv2-application-parallelismconfiguration-parallelismperkpu
         * @external
         */
        readonly parallelismPerKpu?: number;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::Application
 */
export declare namespace CfnApplicationV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-propertygroup.html
     * @external
     */
    interface PropertyGroupProperty {
        /**
         * `CfnApplicationV2.PropertyGroupProperty.PropertyGroupId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-propertygroup.html#cfn-kinesisanalyticsv2-application-propertygroup-propertygroupid
         * @external
         */
        readonly propertyGroupId?: string;
        /**
         * `CfnApplicationV2.PropertyGroupProperty.PropertyMap`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-propertygroup.html#cfn-kinesisanalyticsv2-application-propertygroup-propertymap
         * @external
         */
        readonly propertyMap?: any | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::Application
 */
export declare namespace CfnApplicationV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-recordcolumn.html
     * @external
     */
    interface RecordColumnProperty {
        /**
         * `CfnApplicationV2.RecordColumnProperty.Mapping`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-recordcolumn.html#cfn-kinesisanalyticsv2-application-recordcolumn-mapping
         * @external
         */
        readonly mapping?: string;
        /**
         * `CfnApplicationV2.RecordColumnProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-recordcolumn.html#cfn-kinesisanalyticsv2-application-recordcolumn-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnApplicationV2.RecordColumnProperty.SqlType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-recordcolumn.html#cfn-kinesisanalyticsv2-application-recordcolumn-sqltype
         * @external
         */
        readonly sqlType: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::Application
 */
export declare namespace CfnApplicationV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-recordformat.html
     * @external
     */
    interface RecordFormatProperty {
        /**
         * `CfnApplicationV2.RecordFormatProperty.MappingParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-recordformat.html#cfn-kinesisanalyticsv2-application-recordformat-mappingparameters
         * @external
         */
        readonly mappingParameters?: CfnApplicationV2.MappingParametersProperty | cdk.IResolvable;
        /**
         * `CfnApplicationV2.RecordFormatProperty.RecordFormatType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-recordformat.html#cfn-kinesisanalyticsv2-application-recordformat-recordformattype
         * @external
         */
        readonly recordFormatType: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::Application
 */
export declare namespace CfnApplicationV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-s3contentlocation.html
     * @external
     */
    interface S3ContentLocationProperty {
        /**
         * `CfnApplicationV2.S3ContentLocationProperty.BucketARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-s3contentlocation.html#cfn-kinesisanalyticsv2-application-s3contentlocation-bucketarn
         * @external
         */
        readonly bucketArn?: string;
        /**
         * `CfnApplicationV2.S3ContentLocationProperty.FileKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-s3contentlocation.html#cfn-kinesisanalyticsv2-application-s3contentlocation-filekey
         * @external
         */
        readonly fileKey?: string;
        /**
         * `CfnApplicationV2.S3ContentLocationProperty.ObjectVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-s3contentlocation.html#cfn-kinesisanalyticsv2-application-s3contentlocation-objectversion
         * @external
         */
        readonly objectVersion?: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::Application
 */
export declare namespace CfnApplicationV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-sqlapplicationconfiguration.html
     * @external
     */
    interface SqlApplicationConfigurationProperty {
        /**
         * `CfnApplicationV2.SqlApplicationConfigurationProperty.Inputs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-sqlapplicationconfiguration.html#cfn-kinesisanalyticsv2-application-sqlapplicationconfiguration-inputs
         * @external
         */
        readonly inputs?: Array<CfnApplicationV2.InputProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::KinesisAnalyticsV2::ApplicationCloudWatchLoggingOption`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationcloudwatchloggingoption.html
 * @external
 */
export interface CfnApplicationCloudWatchLoggingOptionV2Props {
    /**
     * `AWS::KinesisAnalyticsV2::ApplicationCloudWatchLoggingOption.ApplicationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationcloudwatchloggingoption.html#cfn-kinesisanalyticsv2-applicationcloudwatchloggingoption-applicationname
     * @external
     */
    readonly applicationName: string;
    /**
     * `AWS::KinesisAnalyticsV2::ApplicationCloudWatchLoggingOption.CloudWatchLoggingOption`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationcloudwatchloggingoption.html#cfn-kinesisanalyticsv2-applicationcloudwatchloggingoption-cloudwatchloggingoption
     * @external
     */
    readonly cloudWatchLoggingOption: CfnApplicationCloudWatchLoggingOptionV2.CloudWatchLoggingOptionProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::ApplicationCloudWatchLoggingOption`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationcloudwatchloggingoption.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::ApplicationCloudWatchLoggingOption
 */
export declare class CfnApplicationCloudWatchLoggingOptionV2 extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::KinesisAnalyticsV2::ApplicationCloudWatchLoggingOption";
    /**
     * `AWS::KinesisAnalyticsV2::ApplicationCloudWatchLoggingOption.ApplicationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationcloudwatchloggingoption.html#cfn-kinesisanalyticsv2-applicationcloudwatchloggingoption-applicationname
     * @external
     */
    applicationName: string;
    /**
     * `AWS::KinesisAnalyticsV2::ApplicationCloudWatchLoggingOption.CloudWatchLoggingOption`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationcloudwatchloggingoption.html#cfn-kinesisanalyticsv2-applicationcloudwatchloggingoption-cloudwatchloggingoption
     * @external
     */
    cloudWatchLoggingOption: CfnApplicationCloudWatchLoggingOptionV2.CloudWatchLoggingOptionProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::KinesisAnalyticsV2::ApplicationCloudWatchLoggingOption`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApplicationCloudWatchLoggingOptionV2Props);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::ApplicationCloudWatchLoggingOption`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationcloudwatchloggingoption.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::ApplicationCloudWatchLoggingOption
 */
export declare namespace CfnApplicationCloudWatchLoggingOptionV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationcloudwatchloggingoption-cloudwatchloggingoption.html
     * @external
     */
    interface CloudWatchLoggingOptionProperty {
        /**
         * `CfnApplicationCloudWatchLoggingOptionV2.CloudWatchLoggingOptionProperty.LogStreamARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationcloudwatchloggingoption-cloudwatchloggingoption.html#cfn-kinesisanalyticsv2-applicationcloudwatchloggingoption-cloudwatchloggingoption-logstreamarn
         * @external
         */
        readonly logStreamArn: string;
    }
}
/**
 * Properties for defining a `AWS::KinesisAnalyticsV2::ApplicationOutput`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationoutput.html
 * @external
 */
export interface CfnApplicationOutputV2Props {
    /**
     * `AWS::KinesisAnalyticsV2::ApplicationOutput.ApplicationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationoutput.html#cfn-kinesisanalyticsv2-applicationoutput-applicationname
     * @external
     */
    readonly applicationName: string;
    /**
     * `AWS::KinesisAnalyticsV2::ApplicationOutput.Output`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationoutput.html#cfn-kinesisanalyticsv2-applicationoutput-output
     * @external
     */
    readonly output: CfnApplicationOutputV2.OutputProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::ApplicationOutput`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationoutput.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::ApplicationOutput
 */
export declare class CfnApplicationOutputV2 extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::KinesisAnalyticsV2::ApplicationOutput";
    /**
     * `AWS::KinesisAnalyticsV2::ApplicationOutput.ApplicationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationoutput.html#cfn-kinesisanalyticsv2-applicationoutput-applicationname
     * @external
     */
    applicationName: string;
    /**
     * `AWS::KinesisAnalyticsV2::ApplicationOutput.Output`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationoutput.html#cfn-kinesisanalyticsv2-applicationoutput-output
     * @external
     */
    output: CfnApplicationOutputV2.OutputProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::KinesisAnalyticsV2::ApplicationOutput`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApplicationOutputV2Props);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::ApplicationOutput`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationoutput.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::ApplicationOutput
 */
export declare namespace CfnApplicationOutputV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-destinationschema.html
     * @external
     */
    interface DestinationSchemaProperty {
        /**
         * `CfnApplicationOutputV2.DestinationSchemaProperty.RecordFormatType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-destinationschema.html#cfn-kinesisanalyticsv2-applicationoutput-destinationschema-recordformattype
         * @external
         */
        readonly recordFormatType?: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::ApplicationOutput`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationoutput.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::ApplicationOutput
 */
export declare namespace CfnApplicationOutputV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-kinesisfirehoseoutput.html
     * @external
     */
    interface KinesisFirehoseOutputProperty {
        /**
         * `CfnApplicationOutputV2.KinesisFirehoseOutputProperty.ResourceARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-kinesisfirehoseoutput.html#cfn-kinesisanalyticsv2-applicationoutput-kinesisfirehoseoutput-resourcearn
         * @external
         */
        readonly resourceArn: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::ApplicationOutput`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationoutput.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::ApplicationOutput
 */
export declare namespace CfnApplicationOutputV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-kinesisstreamsoutput.html
     * @external
     */
    interface KinesisStreamsOutputProperty {
        /**
         * `CfnApplicationOutputV2.KinesisStreamsOutputProperty.ResourceARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-kinesisstreamsoutput.html#cfn-kinesisanalyticsv2-applicationoutput-kinesisstreamsoutput-resourcearn
         * @external
         */
        readonly resourceArn: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::ApplicationOutput`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationoutput.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::ApplicationOutput
 */
export declare namespace CfnApplicationOutputV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-lambdaoutput.html
     * @external
     */
    interface LambdaOutputProperty {
        /**
         * `CfnApplicationOutputV2.LambdaOutputProperty.ResourceARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-lambdaoutput.html#cfn-kinesisanalyticsv2-applicationoutput-lambdaoutput-resourcearn
         * @external
         */
        readonly resourceArn: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::ApplicationOutput`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationoutput.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::ApplicationOutput
 */
export declare namespace CfnApplicationOutputV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-output.html
     * @external
     */
    interface OutputProperty {
        /**
         * `CfnApplicationOutputV2.OutputProperty.DestinationSchema`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-output.html#cfn-kinesisanalyticsv2-applicationoutput-output-destinationschema
         * @external
         */
        readonly destinationSchema: CfnApplicationOutputV2.DestinationSchemaProperty | cdk.IResolvable;
        /**
         * `CfnApplicationOutputV2.OutputProperty.KinesisFirehoseOutput`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-output.html#cfn-kinesisanalyticsv2-applicationoutput-output-kinesisfirehoseoutput
         * @external
         */
        readonly kinesisFirehoseOutput?: CfnApplicationOutputV2.KinesisFirehoseOutputProperty | cdk.IResolvable;
        /**
         * `CfnApplicationOutputV2.OutputProperty.KinesisStreamsOutput`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-output.html#cfn-kinesisanalyticsv2-applicationoutput-output-kinesisstreamsoutput
         * @external
         */
        readonly kinesisStreamsOutput?: CfnApplicationOutputV2.KinesisStreamsOutputProperty | cdk.IResolvable;
        /**
         * `CfnApplicationOutputV2.OutputProperty.LambdaOutput`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-output.html#cfn-kinesisanalyticsv2-applicationoutput-output-lambdaoutput
         * @external
         */
        readonly lambdaOutput?: CfnApplicationOutputV2.LambdaOutputProperty | cdk.IResolvable;
        /**
         * `CfnApplicationOutputV2.OutputProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-output.html#cfn-kinesisanalyticsv2-applicationoutput-output-name
         * @external
         */
        readonly name?: string;
    }
}
/**
 * Properties for defining a `AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationreferencedatasource.html
 * @external
 */
export interface CfnApplicationReferenceDataSourceV2Props {
    /**
     * `AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource.ApplicationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationreferencedatasource.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-applicationname
     * @external
     */
    readonly applicationName: string;
    /**
     * `AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource.ReferenceDataSource`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationreferencedatasource.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-referencedatasource
     * @external
     */
    readonly referenceDataSource: CfnApplicationReferenceDataSourceV2.ReferenceDataSourceProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationreferencedatasource.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource
 */
export declare class CfnApplicationReferenceDataSourceV2 extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource";
    /**
     * `AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource.ApplicationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationreferencedatasource.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-applicationname
     * @external
     */
    applicationName: string;
    /**
     * `AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource.ReferenceDataSource`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationreferencedatasource.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-referencedatasource
     * @external
     */
    referenceDataSource: CfnApplicationReferenceDataSourceV2.ReferenceDataSourceProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApplicationReferenceDataSourceV2Props);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationreferencedatasource.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource
 */
export declare namespace CfnApplicationReferenceDataSourceV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-csvmappingparameters.html
     * @external
     */
    interface CSVMappingParametersProperty {
        /**
         * `CfnApplicationReferenceDataSourceV2.CSVMappingParametersProperty.RecordColumnDelimiter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-csvmappingparameters.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-csvmappingparameters-recordcolumndelimiter
         * @external
         */
        readonly recordColumnDelimiter: string;
        /**
         * `CfnApplicationReferenceDataSourceV2.CSVMappingParametersProperty.RecordRowDelimiter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-csvmappingparameters.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-csvmappingparameters-recordrowdelimiter
         * @external
         */
        readonly recordRowDelimiter: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationreferencedatasource.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource
 */
export declare namespace CfnApplicationReferenceDataSourceV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-jsonmappingparameters.html
     * @external
     */
    interface JSONMappingParametersProperty {
        /**
         * `CfnApplicationReferenceDataSourceV2.JSONMappingParametersProperty.RecordRowPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-jsonmappingparameters.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-jsonmappingparameters-recordrowpath
         * @external
         */
        readonly recordRowPath: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationreferencedatasource.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource
 */
export declare namespace CfnApplicationReferenceDataSourceV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-mappingparameters.html
     * @external
     */
    interface MappingParametersProperty {
        /**
         * `CfnApplicationReferenceDataSourceV2.MappingParametersProperty.CSVMappingParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-mappingparameters.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-mappingparameters-csvmappingparameters
         * @external
         */
        readonly csvMappingParameters?: CfnApplicationReferenceDataSourceV2.CSVMappingParametersProperty | cdk.IResolvable;
        /**
         * `CfnApplicationReferenceDataSourceV2.MappingParametersProperty.JSONMappingParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-mappingparameters.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-mappingparameters-jsonmappingparameters
         * @external
         */
        readonly jsonMappingParameters?: CfnApplicationReferenceDataSourceV2.JSONMappingParametersProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationreferencedatasource.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource
 */
export declare namespace CfnApplicationReferenceDataSourceV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-recordcolumn.html
     * @external
     */
    interface RecordColumnProperty {
        /**
         * `CfnApplicationReferenceDataSourceV2.RecordColumnProperty.Mapping`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-recordcolumn.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-recordcolumn-mapping
         * @external
         */
        readonly mapping?: string;
        /**
         * `CfnApplicationReferenceDataSourceV2.RecordColumnProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-recordcolumn.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-recordcolumn-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnApplicationReferenceDataSourceV2.RecordColumnProperty.SqlType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-recordcolumn.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-recordcolumn-sqltype
         * @external
         */
        readonly sqlType: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationreferencedatasource.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource
 */
export declare namespace CfnApplicationReferenceDataSourceV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-recordformat.html
     * @external
     */
    interface RecordFormatProperty {
        /**
         * `CfnApplicationReferenceDataSourceV2.RecordFormatProperty.MappingParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-recordformat.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-recordformat-mappingparameters
         * @external
         */
        readonly mappingParameters?: CfnApplicationReferenceDataSourceV2.MappingParametersProperty | cdk.IResolvable;
        /**
         * `CfnApplicationReferenceDataSourceV2.RecordFormatProperty.RecordFormatType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-recordformat.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-recordformat-recordformattype
         * @external
         */
        readonly recordFormatType: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationreferencedatasource.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource
 */
export declare namespace CfnApplicationReferenceDataSourceV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-referencedatasource.html
     * @external
     */
    interface ReferenceDataSourceProperty {
        /**
         * `CfnApplicationReferenceDataSourceV2.ReferenceDataSourceProperty.ReferenceSchema`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-referencedatasource.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-referencedatasource-referenceschema
         * @external
         */
        readonly referenceSchema: CfnApplicationReferenceDataSourceV2.ReferenceSchemaProperty | cdk.IResolvable;
        /**
         * `CfnApplicationReferenceDataSourceV2.ReferenceDataSourceProperty.S3ReferenceDataSource`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-referencedatasource.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-referencedatasource-s3referencedatasource
         * @external
         */
        readonly s3ReferenceDataSource?: CfnApplicationReferenceDataSourceV2.S3ReferenceDataSourceProperty | cdk.IResolvable;
        /**
         * `CfnApplicationReferenceDataSourceV2.ReferenceDataSourceProperty.TableName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-referencedatasource.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-referencedatasource-tablename
         * @external
         */
        readonly tableName?: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationreferencedatasource.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource
 */
export declare namespace CfnApplicationReferenceDataSourceV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-referenceschema.html
     * @external
     */
    interface ReferenceSchemaProperty {
        /**
         * `CfnApplicationReferenceDataSourceV2.ReferenceSchemaProperty.RecordColumns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-referenceschema.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-referenceschema-recordcolumns
         * @external
         */
        readonly recordColumns: Array<CfnApplicationReferenceDataSourceV2.RecordColumnProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnApplicationReferenceDataSourceV2.ReferenceSchemaProperty.RecordEncoding`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-referenceschema.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-referenceschema-recordencoding
         * @external
         */
        readonly recordEncoding?: string;
        /**
         * `CfnApplicationReferenceDataSourceV2.ReferenceSchemaProperty.RecordFormat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-referenceschema.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-referenceschema-recordformat
         * @external
         */
        readonly recordFormat: CfnApplicationReferenceDataSourceV2.RecordFormatProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationreferencedatasource.html
 * @external
 * @cloudformationResource AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource
 */
export declare namespace CfnApplicationReferenceDataSourceV2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-s3referencedatasource.html
     * @external
     */
    interface S3ReferenceDataSourceProperty {
        /**
         * `CfnApplicationReferenceDataSourceV2.S3ReferenceDataSourceProperty.BucketARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-s3referencedatasource.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-s3referencedatasource-bucketarn
         * @external
         */
        readonly bucketArn: string;
        /**
         * `CfnApplicationReferenceDataSourceV2.S3ReferenceDataSourceProperty.FileKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-s3referencedatasource.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-s3referencedatasource-filekey
         * @external
         */
        readonly fileKey: string;
    }
}
