import * as iam from "../../aws-iam";
import * as kms from "../../aws-kms";
import { Duration, IResource, Resource } from "../../core";
import { Construct } from 'constructs';
/**
 * (experimental) A Kinesis Stream.
 *
 * @experimental
 */
export interface IStream extends IResource {
    /**
     * (experimental) The ARN of the stream.
     *
     * @experimental
     * @attribute true
     */
    readonly streamArn: string;
    /**
     * (experimental) The name of the stream.
     *
     * @experimental
     * @attribute true
     */
    readonly streamName: string;
    /**
     * (experimental) Optional KMS encryption key associated with this stream.
     *
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) Grant read permissions for this stream and its contents to an IAM principal (Role/Group/User).
     *
     * If an encryption key is used, permission to ues the key to decrypt the
     * contents of the stream will also be granted.
     *
     * @experimental
     */
    grantRead(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant write permissions for this stream and its contents to an IAM principal (Role/Group/User).
     *
     * If an encryption key is used, permission to ues the key to encrypt the
     * contents of the stream will also be granted.
     *
     * @experimental
     */
    grantWrite(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grants read/write permissions for this stream and its contents to an IAM principal (Role/Group/User).
     *
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     *
     * @experimental
     */
    grantReadWrite(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant the indicated permissions on this stream to the provided IAM principal.
     *
     * @experimental
     */
    grant(grantee: iam.IGrantable, ...actions: string[]): iam.Grant;
}
/**
 * (experimental) A reference to a stream.
 *
 * The easiest way to instantiate is to call
 * `stream.export()`. Then, the consumer can use `Stream.import(this, ref)` and
 * get a `Stream`.
 *
 * @experimental
 */
export interface StreamAttributes {
    /**
     * (experimental) The ARN of the stream.
     *
     * @experimental
     */
    readonly streamArn: string;
    /**
     * (experimental) The KMS key securing the contents of the stream if encryption is enabled.
     *
     * @default - No encryption
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
}
/**
 * Represents a Kinesis Stream.
 */
declare abstract class StreamBase extends Resource implements IStream {
    /**
     * The ARN of the stream.
     */
    abstract readonly streamArn: string;
    /**
     * The name of the stream
     */
    abstract readonly streamName: string;
    /**
     * Optional KMS encryption key associated with this stream.
     */
    abstract readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) Grant write permissions for this stream and its contents to an IAM principal (Role/Group/User).
     *
     * If an encryption key is used, permission to ues the key to decrypt the
     * contents of the stream will also be granted.
     *
     * @experimental
     */
    grantRead(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant read permissions for this stream and its contents to an IAM principal (Role/Group/User).
     *
     * If an encryption key is used, permission to ues the key to decrypt the
     * contents of the stream will also be granted.
     *
     * @experimental
     */
    grantWrite(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grants read/write permissions for this stream and its contents to an IAM principal (Role/Group/User).
     *
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     *
     * @experimental
     */
    grantReadWrite(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant the indicated permissions on this stream to the given IAM principal (Role/Group/User).
     *
     * @experimental
     */
    grant(grantee: iam.IGrantable, ...actions: string[]): iam.Grant;
}
/**
 * (experimental) Properties for a Kinesis Stream.
 *
 * @experimental
 */
export interface StreamProps {
    /**
     * (experimental) Enforces a particular physical stream name.
     *
     * @default <generated>
     * @experimental
     */
    readonly streamName?: string;
    /**
     * (experimental) The number of hours for the data records that are stored in shards to remain accessible.
     *
     * @default Duration.hours(24)
     * @experimental
     */
    readonly retentionPeriod?: Duration;
    /**
     * (experimental) The number of shards for the stream.
     *
     * @default 1
     * @experimental
     */
    readonly shardCount?: number;
    /**
     * (experimental) The kind of server-side encryption to apply to this stream.
     *
     * If you choose KMS, you can specify a KMS key via `encryptionKey`. If
     * encryption key is not specified, a key will automatically be created.
     *
     * @default - StreamEncryption.KMS if encrypted Streams are supported in the region
     * or StreamEncryption.UNENCRYPTED otherwise.
     * StreamEncryption.KMS if an encryption key is supplied through the encryptionKey property
     * @experimental
     */
    readonly encryption?: StreamEncryption;
    /**
     * (experimental) External KMS key to use for stream encryption.
     *
     * The 'encryption' property must be set to "Kms".
     *
     * @default - Kinesis Data Streams master key ('/alias/aws/kinesis').
     * If encryption is set to StreamEncryption.KMS and this property is undefined, a new KMS key
     * will be created and associated with this stream.
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
}
/**
 * (experimental) A Kinesis stream.
 *
 * Can be encrypted with a KMS key.
 *
 * @experimental
 */
export declare class Stream extends StreamBase {
    /**
     * (experimental) Import an existing Kinesis Stream provided an ARN.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param streamArn Stream ARN (i.e. arn:aws:kinesis:<region>:<account-id>:stream/Foo).
     * @experimental
     */
    static fromStreamArn(scope: Construct, id: string, streamArn: string): IStream;
    /**
     * (experimental) Creates a Stream construct that represents an external stream.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param attrs Stream import properties.
     * @experimental
     */
    static fromStreamAttributes(scope: Construct, id: string, attrs: StreamAttributes): IStream;
    /**
     * (experimental) The ARN of the stream.
     *
     * @experimental
     */
    readonly streamArn: string;
    /**
     * (experimental) The name of the stream.
     *
     * @experimental
     */
    readonly streamName: string;
    /**
     * (experimental) Optional KMS encryption key associated with this stream.
     *
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    private readonly stream;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: StreamProps);
    /**
     * Set up key properties and return the Stream encryption property from the
     * user's configuration.
     */
    private parseEncryption;
}
/**
 * (experimental) What kind of server-side encryption to apply to this stream.
 *
 * @experimental
 */
export declare enum StreamEncryption {
    /**
     * (experimental) Records in the stream are not encrypted.
     *
     * @experimental
     */
    UNENCRYPTED = "NONE",
    /**
     * (experimental) Server-side encryption with a KMS key managed by the user.
     *
     * If `encryptionKey` is specified, this key will be used, otherwise, one will be defined.
     *
     * @experimental
     */
    KMS = "KMS",
    /**
     * (experimental) Server-side encryption with a master key managed by Amazon Kinesis.
     *
     * @experimental
     */
    MANAGED = "MANAGED"
}
export {};
