import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::IoT1Click::Device`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-device.html
 * @external
 */
export interface CfnDeviceProps {
    /**
     * `AWS::IoT1Click::Device.DeviceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-device.html#cfn-iot1click-device-deviceid
     * @external
     */
    readonly deviceId: string;
    /**
     * `AWS::IoT1Click::Device.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-device.html#cfn-iot1click-device-enabled
     * @external
     */
    readonly enabled: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::IoT1Click::Device`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-device.html
 * @external
 * @cloudformationResource AWS::IoT1Click::Device
 */
export declare class CfnDevice extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT1Click::Device";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute DeviceId
     */
    readonly attrDeviceId: string;
    /**
     * @external
     * @cloudformationAttribute Enabled
     */
    readonly attrEnabled: cdk.IResolvable;
    /**
     * `AWS::IoT1Click::Device.DeviceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-device.html#cfn-iot1click-device-deviceid
     * @external
     */
    deviceId: string;
    /**
     * `AWS::IoT1Click::Device.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-device.html#cfn-iot1click-device-enabled
     * @external
     */
    enabled: boolean | cdk.IResolvable;
    /**
     * Create a new `AWS::IoT1Click::Device`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDeviceProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::IoT1Click::Placement`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-placement.html
 * @external
 */
export interface CfnPlacementProps {
    /**
     * `AWS::IoT1Click::Placement.ProjectName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-placement.html#cfn-iot1click-placement-projectname
     * @external
     */
    readonly projectName: string;
    /**
     * `AWS::IoT1Click::Placement.AssociatedDevices`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-placement.html#cfn-iot1click-placement-associateddevices
     * @external
     */
    readonly associatedDevices?: any | cdk.IResolvable;
    /**
     * `AWS::IoT1Click::Placement.Attributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-placement.html#cfn-iot1click-placement-attributes
     * @external
     */
    readonly attributes?: any | cdk.IResolvable;
    /**
     * `AWS::IoT1Click::Placement.PlacementName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-placement.html#cfn-iot1click-placement-placementname
     * @external
     */
    readonly placementName?: string;
}
/**
 * A CloudFormation `AWS::IoT1Click::Placement`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-placement.html
 * @external
 * @cloudformationResource AWS::IoT1Click::Placement
 */
export declare class CfnPlacement extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT1Click::Placement";
    /**
     * @external
     * @cloudformationAttribute PlacementName
     */
    readonly attrPlacementName: string;
    /**
     * @external
     * @cloudformationAttribute ProjectName
     */
    readonly attrProjectName: string;
    /**
     * `AWS::IoT1Click::Placement.ProjectName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-placement.html#cfn-iot1click-placement-projectname
     * @external
     */
    projectName: string;
    /**
     * `AWS::IoT1Click::Placement.AssociatedDevices`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-placement.html#cfn-iot1click-placement-associateddevices
     * @external
     */
    associatedDevices: any | cdk.IResolvable | undefined;
    /**
     * `AWS::IoT1Click::Placement.Attributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-placement.html#cfn-iot1click-placement-attributes
     * @external
     */
    attributes: any | cdk.IResolvable | undefined;
    /**
     * `AWS::IoT1Click::Placement.PlacementName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-placement.html#cfn-iot1click-placement-placementname
     * @external
     */
    placementName: string | undefined;
    /**
     * Create a new `AWS::IoT1Click::Placement`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPlacementProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::IoT1Click::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-project.html
 * @external
 */
export interface CfnProjectProps {
    /**
     * `AWS::IoT1Click::Project.PlacementTemplate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-project.html#cfn-iot1click-project-placementtemplate
     * @external
     */
    readonly placementTemplate: CfnProject.PlacementTemplateProperty | cdk.IResolvable;
    /**
     * `AWS::IoT1Click::Project.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-project.html#cfn-iot1click-project-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::IoT1Click::Project.ProjectName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-project.html#cfn-iot1click-project-projectname
     * @external
     */
    readonly projectName?: string;
}
/**
 * A CloudFormation `AWS::IoT1Click::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-project.html
 * @external
 * @cloudformationResource AWS::IoT1Click::Project
 */
export declare class CfnProject extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT1Click::Project";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute ProjectName
     */
    readonly attrProjectName: string;
    /**
     * `AWS::IoT1Click::Project.PlacementTemplate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-project.html#cfn-iot1click-project-placementtemplate
     * @external
     */
    placementTemplate: CfnProject.PlacementTemplateProperty | cdk.IResolvable;
    /**
     * `AWS::IoT1Click::Project.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-project.html#cfn-iot1click-project-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::IoT1Click::Project.ProjectName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-project.html#cfn-iot1click-project-projectname
     * @external
     */
    projectName: string | undefined;
    /**
     * Create a new `AWS::IoT1Click::Project`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnProjectProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::IoT1Click::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-project.html
 * @external
 * @cloudformationResource AWS::IoT1Click::Project
 */
export declare namespace CfnProject {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot1click-project-devicetemplate.html
     * @external
     */
    interface DeviceTemplateProperty {
        /**
         * `CfnProject.DeviceTemplateProperty.CallbackOverrides`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot1click-project-devicetemplate.html#cfn-iot1click-project-devicetemplate-callbackoverrides
         * @external
         */
        readonly callbackOverrides?: any | cdk.IResolvable;
        /**
         * `CfnProject.DeviceTemplateProperty.DeviceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot1click-project-devicetemplate.html#cfn-iot1click-project-devicetemplate-devicetype
         * @external
         */
        readonly deviceType?: string;
    }
}
/**
 * A CloudFormation `AWS::IoT1Click::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-project.html
 * @external
 * @cloudformationResource AWS::IoT1Click::Project
 */
export declare namespace CfnProject {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot1click-project-placementtemplate.html
     * @external
     */
    interface PlacementTemplateProperty {
        /**
         * `CfnProject.PlacementTemplateProperty.DefaultAttributes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot1click-project-placementtemplate.html#cfn-iot1click-project-placementtemplate-defaultattributes
         * @external
         */
        readonly defaultAttributes?: any | cdk.IResolvable;
        /**
         * `CfnProject.PlacementTemplateProperty.DeviceTemplates`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot1click-project-placementtemplate.html#cfn-iot1click-project-placementtemplate-devicetemplates
         * @external
         */
        readonly deviceTemplates?: {
            [key: string]: (CfnProject.DeviceTemplateProperty | cdk.IResolvable);
        } | cdk.IResolvable;
    }
}
