import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::IoT::Authorizer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html
 * @external
 */
export interface CfnAuthorizerProps {
    /**
     * `AWS::IoT::Authorizer.AuthorizerFunctionArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-authorizerfunctionarn
     * @external
     */
    readonly authorizerFunctionArn: string;
    /**
     * `AWS::IoT::Authorizer.AuthorizerName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-authorizername
     * @external
     */
    readonly authorizerName?: string;
    /**
     * `AWS::IoT::Authorizer.SigningDisabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-signingdisabled
     * @external
     */
    readonly signingDisabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::IoT::Authorizer.Status`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-status
     * @external
     */
    readonly status?: string;
    /**
     * `AWS::IoT::Authorizer.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-tags
     * @external
     */
    readonly tags?: CfnAuthorizer.TagsProperty;
    /**
     * `AWS::IoT::Authorizer.TokenKeyName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-tokenkeyname
     * @external
     */
    readonly tokenKeyName?: string;
    /**
     * `AWS::IoT::Authorizer.TokenSigningPublicKeys`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-tokensigningpublickeys
     * @external
     */
    readonly tokenSigningPublicKeys?: CfnAuthorizer.TokenSigningPublicKeysProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::IoT::Authorizer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html
 * @external
 * @cloudformationResource AWS::IoT::Authorizer
 */
export declare class CfnAuthorizer extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::Authorizer";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::IoT::Authorizer.AuthorizerFunctionArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-authorizerfunctionarn
     * @external
     */
    authorizerFunctionArn: string;
    /**
     * `AWS::IoT::Authorizer.AuthorizerName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-authorizername
     * @external
     */
    authorizerName: string | undefined;
    /**
     * `AWS::IoT::Authorizer.SigningDisabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-signingdisabled
     * @external
     */
    signingDisabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::IoT::Authorizer.Status`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-status
     * @external
     */
    status: string | undefined;
    /**
     * `AWS::IoT::Authorizer.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::IoT::Authorizer.TokenKeyName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-tokenkeyname
     * @external
     */
    tokenKeyName: string | undefined;
    /**
     * `AWS::IoT::Authorizer.TokenSigningPublicKeys`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-tokensigningpublickeys
     * @external
     */
    tokenSigningPublicKeys: CfnAuthorizer.TokenSigningPublicKeysProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::IoT::Authorizer`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAuthorizerProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::IoT::Authorizer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html
 * @external
 * @cloudformationResource AWS::IoT::Authorizer
 */
export declare namespace CfnAuthorizer {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-authorizer-tags.html
     * @external
     */
    interface TagsProperty {
        /**
         * `CfnAuthorizer.TagsProperty.Tags`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-authorizer-tags.html#cfn-iot-authorizer-tags-tags
         * @external
         */
        readonly tags?: cdk.CfnTag[];
    }
}
/**
 * A CloudFormation `AWS::IoT::Authorizer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html
 * @external
 * @cloudformationResource AWS::IoT::Authorizer
 */
export declare namespace CfnAuthorizer {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-authorizer-tokensigningpublickeys.html
     * @external
     */
    interface TokenSigningPublicKeysProperty {
    }
}
/**
 * Properties for defining a `AWS::IoT::Certificate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html
 * @external
 */
export interface CfnCertificateProps {
    /**
     * `AWS::IoT::Certificate.Status`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-status
     * @external
     */
    readonly status: string;
    /**
     * `AWS::IoT::Certificate.CACertificatePem`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-cacertificatepem
     * @external
     */
    readonly caCertificatePem?: string;
    /**
     * `AWS::IoT::Certificate.CertificateMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-certificatemode
     * @external
     */
    readonly certificateMode?: string;
    /**
     * `AWS::IoT::Certificate.CertificatePem`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-certificatepem
     * @external
     */
    readonly certificatePem?: string;
    /**
     * `AWS::IoT::Certificate.CertificateSigningRequest`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-certificatesigningrequest
     * @external
     */
    readonly certificateSigningRequest?: string;
}
/**
 * A CloudFormation `AWS::IoT::Certificate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html
 * @external
 * @cloudformationResource AWS::IoT::Certificate
 */
export declare class CfnCertificate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::Certificate";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::IoT::Certificate.Status`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-status
     * @external
     */
    status: string;
    /**
     * `AWS::IoT::Certificate.CACertificatePem`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-cacertificatepem
     * @external
     */
    caCertificatePem: string | undefined;
    /**
     * `AWS::IoT::Certificate.CertificateMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-certificatemode
     * @external
     */
    certificateMode: string | undefined;
    /**
     * `AWS::IoT::Certificate.CertificatePem`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-certificatepem
     * @external
     */
    certificatePem: string | undefined;
    /**
     * `AWS::IoT::Certificate.CertificateSigningRequest`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-certificatesigningrequest
     * @external
     */
    certificateSigningRequest: string | undefined;
    /**
     * Create a new `AWS::IoT::Certificate`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCertificateProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::IoT::Policy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policy.html
 * @external
 */
export interface CfnPolicyProps {
    /**
     * `AWS::IoT::Policy.PolicyDocument`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policy.html#cfn-iot-policy-policydocument
     * @external
     */
    readonly policyDocument: any | cdk.IResolvable;
    /**
     * `AWS::IoT::Policy.PolicyName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policy.html#cfn-iot-policy-policyname
     * @external
     */
    readonly policyName?: string;
}
/**
 * A CloudFormation `AWS::IoT::Policy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policy.html
 * @external
 * @cloudformationResource AWS::IoT::Policy
 */
export declare class CfnPolicy extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::Policy";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::IoT::Policy.PolicyDocument`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policy.html#cfn-iot-policy-policydocument
     * @external
     */
    policyDocument: any | cdk.IResolvable;
    /**
     * `AWS::IoT::Policy.PolicyName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policy.html#cfn-iot-policy-policyname
     * @external
     */
    policyName: string | undefined;
    /**
     * Create a new `AWS::IoT::Policy`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPolicyProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::IoT::PolicyPrincipalAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policyprincipalattachment.html
 * @external
 */
export interface CfnPolicyPrincipalAttachmentProps {
    /**
     * `AWS::IoT::PolicyPrincipalAttachment.PolicyName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policyprincipalattachment.html#cfn-iot-policyprincipalattachment-policyname
     * @external
     */
    readonly policyName: string;
    /**
     * `AWS::IoT::PolicyPrincipalAttachment.Principal`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policyprincipalattachment.html#cfn-iot-policyprincipalattachment-principal
     * @external
     */
    readonly principal: string;
}
/**
 * A CloudFormation `AWS::IoT::PolicyPrincipalAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policyprincipalattachment.html
 * @external
 * @cloudformationResource AWS::IoT::PolicyPrincipalAttachment
 */
export declare class CfnPolicyPrincipalAttachment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::PolicyPrincipalAttachment";
    /**
     * `AWS::IoT::PolicyPrincipalAttachment.PolicyName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policyprincipalattachment.html#cfn-iot-policyprincipalattachment-policyname
     * @external
     */
    policyName: string;
    /**
     * `AWS::IoT::PolicyPrincipalAttachment.Principal`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policyprincipalattachment.html#cfn-iot-policyprincipalattachment-principal
     * @external
     */
    principal: string;
    /**
     * Create a new `AWS::IoT::PolicyPrincipalAttachment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPolicyPrincipalAttachmentProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::IoT::ProvisioningTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html
 * @external
 */
export interface CfnProvisioningTemplateProps {
    /**
     * `AWS::IoT::ProvisioningTemplate.ProvisioningRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-provisioningrolearn
     * @external
     */
    readonly provisioningRoleArn: string;
    /**
     * `AWS::IoT::ProvisioningTemplate.TemplateBody`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-templatebody
     * @external
     */
    readonly templateBody: string;
    /**
     * `AWS::IoT::ProvisioningTemplate.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::IoT::ProvisioningTemplate.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-enabled
     * @external
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::IoT::ProvisioningTemplate.PreProvisioningHook`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-preprovisioninghook
     * @external
     */
    readonly preProvisioningHook?: CfnProvisioningTemplate.ProvisioningHookProperty | cdk.IResolvable;
    /**
     * `AWS::IoT::ProvisioningTemplate.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-tags
     * @external
     */
    readonly tags?: CfnProvisioningTemplate.TagsProperty;
    /**
     * `AWS::IoT::ProvisioningTemplate.TemplateName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-templatename
     * @external
     */
    readonly templateName?: string;
}
/**
 * A CloudFormation `AWS::IoT::ProvisioningTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html
 * @external
 * @cloudformationResource AWS::IoT::ProvisioningTemplate
 */
export declare class CfnProvisioningTemplate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::ProvisioningTemplate";
    /**
     * @external
     * @cloudformationAttribute TemplateArn
     */
    readonly attrTemplateArn: string;
    /**
     * `AWS::IoT::ProvisioningTemplate.ProvisioningRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-provisioningrolearn
     * @external
     */
    provisioningRoleArn: string;
    /**
     * `AWS::IoT::ProvisioningTemplate.TemplateBody`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-templatebody
     * @external
     */
    templateBody: string;
    /**
     * `AWS::IoT::ProvisioningTemplate.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::IoT::ProvisioningTemplate.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-enabled
     * @external
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::IoT::ProvisioningTemplate.PreProvisioningHook`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-preprovisioninghook
     * @external
     */
    preProvisioningHook: CfnProvisioningTemplate.ProvisioningHookProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::IoT::ProvisioningTemplate.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::IoT::ProvisioningTemplate.TemplateName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-templatename
     * @external
     */
    templateName: string | undefined;
    /**
     * Create a new `AWS::IoT::ProvisioningTemplate`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnProvisioningTemplateProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::IoT::ProvisioningTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html
 * @external
 * @cloudformationResource AWS::IoT::ProvisioningTemplate
 */
export declare namespace CfnProvisioningTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-provisioningtemplate-provisioninghook.html
     * @external
     */
    interface ProvisioningHookProperty {
        /**
         * `CfnProvisioningTemplate.ProvisioningHookProperty.PayloadVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-provisioningtemplate-provisioninghook.html#cfn-iot-provisioningtemplate-provisioninghook-payloadversion
         * @external
         */
        readonly payloadVersion?: string;
        /**
         * `CfnProvisioningTemplate.ProvisioningHookProperty.TargetArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-provisioningtemplate-provisioninghook.html#cfn-iot-provisioningtemplate-provisioninghook-targetarn
         * @external
         */
        readonly targetArn?: string;
    }
}
/**
 * A CloudFormation `AWS::IoT::ProvisioningTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html
 * @external
 * @cloudformationResource AWS::IoT::ProvisioningTemplate
 */
export declare namespace CfnProvisioningTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-provisioningtemplate-tags.html
     * @external
     */
    interface TagsProperty {
        /**
         * `CfnProvisioningTemplate.TagsProperty.Tags`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-provisioningtemplate-tags.html#cfn-iot-provisioningtemplate-tags-tags
         * @external
         */
        readonly tags?: any[];
    }
}
/**
 * Properties for defining a `AWS::IoT::Thing`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html
 * @external
 */
export interface CfnThingProps {
    /**
     * `AWS::IoT::Thing.AttributePayload`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html#cfn-iot-thing-attributepayload
     * @external
     */
    readonly attributePayload?: CfnThing.AttributePayloadProperty | cdk.IResolvable;
    /**
     * `AWS::IoT::Thing.ThingName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html#cfn-iot-thing-thingname
     * @external
     */
    readonly thingName?: string;
}
/**
 * A CloudFormation `AWS::IoT::Thing`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html
 * @external
 * @cloudformationResource AWS::IoT::Thing
 */
export declare class CfnThing extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::Thing";
    /**
     * `AWS::IoT::Thing.AttributePayload`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html#cfn-iot-thing-attributepayload
     * @external
     */
    attributePayload: CfnThing.AttributePayloadProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::IoT::Thing.ThingName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html#cfn-iot-thing-thingname
     * @external
     */
    thingName: string | undefined;
    /**
     * Create a new `AWS::IoT::Thing`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnThingProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::IoT::Thing`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html
 * @external
 * @cloudformationResource AWS::IoT::Thing
 */
export declare namespace CfnThing {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thing-attributepayload.html
     * @external
     */
    interface AttributePayloadProperty {
        /**
         * `CfnThing.AttributePayloadProperty.Attributes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thing-attributepayload.html#cfn-iot-thing-attributepayload-attributes
         * @external
         */
        readonly attributes?: {
            [key: string]: (string);
        } | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::IoT::ThingPrincipalAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingprincipalattachment.html
 * @external
 */
export interface CfnThingPrincipalAttachmentProps {
    /**
     * `AWS::IoT::ThingPrincipalAttachment.Principal`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingprincipalattachment.html#cfn-iot-thingprincipalattachment-principal
     * @external
     */
    readonly principal: string;
    /**
     * `AWS::IoT::ThingPrincipalAttachment.ThingName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingprincipalattachment.html#cfn-iot-thingprincipalattachment-thingname
     * @external
     */
    readonly thingName: string;
}
/**
 * A CloudFormation `AWS::IoT::ThingPrincipalAttachment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingprincipalattachment.html
 * @external
 * @cloudformationResource AWS::IoT::ThingPrincipalAttachment
 */
export declare class CfnThingPrincipalAttachment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::ThingPrincipalAttachment";
    /**
     * `AWS::IoT::ThingPrincipalAttachment.Principal`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingprincipalattachment.html#cfn-iot-thingprincipalattachment-principal
     * @external
     */
    principal: string;
    /**
     * `AWS::IoT::ThingPrincipalAttachment.ThingName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingprincipalattachment.html#cfn-iot-thingprincipalattachment-thingname
     * @external
     */
    thingName: string;
    /**
     * Create a new `AWS::IoT::ThingPrincipalAttachment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnThingPrincipalAttachmentProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 */
export interface CfnTopicRuleProps {
    /**
     * `AWS::IoT::TopicRule.TopicRulePayload`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html#cfn-iot-topicrule-topicrulepayload
     * @external
     */
    readonly topicRulePayload: CfnTopicRule.TopicRulePayloadProperty | cdk.IResolvable;
    /**
     * `AWS::IoT::TopicRule.RuleName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html#cfn-iot-topicrule-rulename
     * @external
     */
    readonly ruleName?: string;
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare class CfnTopicRule extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::TopicRule";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::IoT::TopicRule.TopicRulePayload`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html#cfn-iot-topicrule-topicrulepayload
     * @external
     */
    topicRulePayload: CfnTopicRule.TopicRulePayloadProperty | cdk.IResolvable;
    /**
     * `AWS::IoT::TopicRule.RuleName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html#cfn-iot-topicrule-rulename
     * @external
     */
    ruleName: string | undefined;
    /**
     * Create a new `AWS::IoT::TopicRule`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTopicRuleProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html
     * @external
     */
    interface ActionProperty {
        /**
         * `CfnTopicRule.ActionProperty.CloudwatchAlarm`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-cloudwatchalarm
         * @external
         */
        readonly cloudwatchAlarm?: CfnTopicRule.CloudwatchAlarmActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.CloudwatchMetric`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-cloudwatchmetric
         * @external
         */
        readonly cloudwatchMetric?: CfnTopicRule.CloudwatchMetricActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.DynamoDB`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-dynamodb
         * @external
         */
        readonly dynamoDb?: CfnTopicRule.DynamoDBActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.DynamoDBv2`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-dynamodbv2
         * @external
         */
        readonly dynamoDBv2?: CfnTopicRule.DynamoDBv2ActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.Elasticsearch`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-elasticsearch
         * @external
         */
        readonly elasticsearch?: CfnTopicRule.ElasticsearchActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.Firehose`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-firehose
         * @external
         */
        readonly firehose?: CfnTopicRule.FirehoseActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.Http`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-http
         * @external
         */
        readonly http?: CfnTopicRule.HttpActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.IotAnalytics`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-iotanalytics
         * @external
         */
        readonly iotAnalytics?: CfnTopicRule.IotAnalyticsActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.IotEvents`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-iotevents
         * @external
         */
        readonly iotEvents?: CfnTopicRule.IotEventsActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.IotSiteWise`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-iotsitewise
         * @external
         */
        readonly iotSiteWise?: CfnTopicRule.IotSiteWiseActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.Kinesis`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-kinesis
         * @external
         */
        readonly kinesis?: CfnTopicRule.KinesisActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.Lambda`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-lambda
         * @external
         */
        readonly lambda?: CfnTopicRule.LambdaActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.Republish`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-republish
         * @external
         */
        readonly republish?: CfnTopicRule.RepublishActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.S3`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-s3
         * @external
         */
        readonly s3?: CfnTopicRule.S3ActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.Sns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-sns
         * @external
         */
        readonly sns?: CfnTopicRule.SnsActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.Sqs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-sqs
         * @external
         */
        readonly sqs?: CfnTopicRule.SqsActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.StepFunctions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-stepfunctions
         * @external
         */
        readonly stepFunctions?: CfnTopicRule.StepFunctionsActionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertytimestamp.html
     * @external
     */
    interface AssetPropertyTimestampProperty {
        /**
         * `CfnTopicRule.AssetPropertyTimestampProperty.OffsetInNanos`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertytimestamp.html#cfn-iot-topicrule-assetpropertytimestamp-offsetinnanos
         * @external
         */
        readonly offsetInNanos?: string;
        /**
         * `CfnTopicRule.AssetPropertyTimestampProperty.TimeInSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertytimestamp.html#cfn-iot-topicrule-assetpropertytimestamp-timeinseconds
         * @external
         */
        readonly timeInSeconds: string;
    }
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvalue.html
     * @external
     */
    interface AssetPropertyValueProperty {
        /**
         * `CfnTopicRule.AssetPropertyValueProperty.Quality`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvalue.html#cfn-iot-topicrule-assetpropertyvalue-quality
         * @external
         */
        readonly quality?: string;
        /**
         * `CfnTopicRule.AssetPropertyValueProperty.Timestamp`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvalue.html#cfn-iot-topicrule-assetpropertyvalue-timestamp
         * @external
         */
        readonly timestamp: CfnTopicRule.AssetPropertyTimestampProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.AssetPropertyValueProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvalue.html#cfn-iot-topicrule-assetpropertyvalue-value
         * @external
         */
        readonly value: CfnTopicRule.AssetPropertyVariantProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvariant.html
     * @external
     */
    interface AssetPropertyVariantProperty {
        /**
         * `CfnTopicRule.AssetPropertyVariantProperty.BooleanValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvariant.html#cfn-iot-topicrule-assetpropertyvariant-booleanvalue
         * @external
         */
        readonly booleanValue?: string;
        /**
         * `CfnTopicRule.AssetPropertyVariantProperty.DoubleValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvariant.html#cfn-iot-topicrule-assetpropertyvariant-doublevalue
         * @external
         */
        readonly doubleValue?: string;
        /**
         * `CfnTopicRule.AssetPropertyVariantProperty.IntegerValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvariant.html#cfn-iot-topicrule-assetpropertyvariant-integervalue
         * @external
         */
        readonly integerValue?: string;
        /**
         * `CfnTopicRule.AssetPropertyVariantProperty.StringValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvariant.html#cfn-iot-topicrule-assetpropertyvariant-stringvalue
         * @external
         */
        readonly stringValue?: string;
    }
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchalarmaction.html
     * @external
     */
    interface CloudwatchAlarmActionProperty {
        /**
         * `CfnTopicRule.CloudwatchAlarmActionProperty.AlarmName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchalarmaction.html#cfn-iot-topicrule-cloudwatchalarmaction-alarmname
         * @external
         */
        readonly alarmName: string;
        /**
         * `CfnTopicRule.CloudwatchAlarmActionProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchalarmaction.html#cfn-iot-topicrule-cloudwatchalarmaction-rolearn
         * @external
         */
        readonly roleArn: string;
        /**
         * `CfnTopicRule.CloudwatchAlarmActionProperty.StateReason`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchalarmaction.html#cfn-iot-topicrule-cloudwatchalarmaction-statereason
         * @external
         */
        readonly stateReason: string;
        /**
         * `CfnTopicRule.CloudwatchAlarmActionProperty.StateValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchalarmaction.html#cfn-iot-topicrule-cloudwatchalarmaction-statevalue
         * @external
         */
        readonly stateValue: string;
    }
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html
     * @external
     */
    interface CloudwatchMetricActionProperty {
        /**
         * `CfnTopicRule.CloudwatchMetricActionProperty.MetricName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-metricname
         * @external
         */
        readonly metricName: string;
        /**
         * `CfnTopicRule.CloudwatchMetricActionProperty.MetricNamespace`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-metricnamespace
         * @external
         */
        readonly metricNamespace: string;
        /**
         * `CfnTopicRule.CloudwatchMetricActionProperty.MetricTimestamp`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-metrictimestamp
         * @external
         */
        readonly metricTimestamp?: string;
        /**
         * `CfnTopicRule.CloudwatchMetricActionProperty.MetricUnit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-metricunit
         * @external
         */
        readonly metricUnit: string;
        /**
         * `CfnTopicRule.CloudwatchMetricActionProperty.MetricValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-metricvalue
         * @external
         */
        readonly metricValue: string;
        /**
         * `CfnTopicRule.CloudwatchMetricActionProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-rolearn
         * @external
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html
     * @external
     */
    interface DynamoDBActionProperty {
        /**
         * `CfnTopicRule.DynamoDBActionProperty.HashKeyField`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-hashkeyfield
         * @external
         */
        readonly hashKeyField: string;
        /**
         * `CfnTopicRule.DynamoDBActionProperty.HashKeyType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-hashkeytype
         * @external
         */
        readonly hashKeyType?: string;
        /**
         * `CfnTopicRule.DynamoDBActionProperty.HashKeyValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-hashkeyvalue
         * @external
         */
        readonly hashKeyValue: string;
        /**
         * `CfnTopicRule.DynamoDBActionProperty.PayloadField`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-payloadfield
         * @external
         */
        readonly payloadField?: string;
        /**
         * `CfnTopicRule.DynamoDBActionProperty.RangeKeyField`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-rangekeyfield
         * @external
         */
        readonly rangeKeyField?: string;
        /**
         * `CfnTopicRule.DynamoDBActionProperty.RangeKeyType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-rangekeytype
         * @external
         */
        readonly rangeKeyType?: string;
        /**
         * `CfnTopicRule.DynamoDBActionProperty.RangeKeyValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-rangekeyvalue
         * @external
         */
        readonly rangeKeyValue?: string;
        /**
         * `CfnTopicRule.DynamoDBActionProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-rolearn
         * @external
         */
        readonly roleArn: string;
        /**
         * `CfnTopicRule.DynamoDBActionProperty.TableName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-tablename
         * @external
         */
        readonly tableName: string;
    }
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbv2action.html
     * @external
     */
    interface DynamoDBv2ActionProperty {
        /**
         * `CfnTopicRule.DynamoDBv2ActionProperty.PutItem`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbv2action.html#cfn-iot-topicrule-dynamodbv2action-putitem
         * @external
         */
        readonly putItem?: CfnTopicRule.PutItemInputProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.DynamoDBv2ActionProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbv2action.html#cfn-iot-topicrule-dynamodbv2action-rolearn
         * @external
         */
        readonly roleArn?: string;
    }
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html
     * @external
     */
    interface ElasticsearchActionProperty {
        /**
         * `CfnTopicRule.ElasticsearchActionProperty.Endpoint`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html#cfn-iot-topicrule-elasticsearchaction-endpoint
         * @external
         */
        readonly endpoint: string;
        /**
         * `CfnTopicRule.ElasticsearchActionProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html#cfn-iot-topicrule-elasticsearchaction-id
         * @external
         */
        readonly id: string;
        /**
         * `CfnTopicRule.ElasticsearchActionProperty.Index`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html#cfn-iot-topicrule-elasticsearchaction-index
         * @external
         */
        readonly index: string;
        /**
         * `CfnTopicRule.ElasticsearchActionProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html#cfn-iot-topicrule-elasticsearchaction-rolearn
         * @external
         */
        readonly roleArn: string;
        /**
         * `CfnTopicRule.ElasticsearchActionProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html#cfn-iot-topicrule-elasticsearchaction-type
         * @external
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-firehoseaction.html
     * @external
     */
    interface FirehoseActionProperty {
        /**
         * `CfnTopicRule.FirehoseActionProperty.DeliveryStreamName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-firehoseaction.html#cfn-iot-topicrule-firehoseaction-deliverystreamname
         * @external
         */
        readonly deliveryStreamName: string;
        /**
         * `CfnTopicRule.FirehoseActionProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-firehoseaction.html#cfn-iot-topicrule-firehoseaction-rolearn
         * @external
         */
        readonly roleArn: string;
        /**
         * `CfnTopicRule.FirehoseActionProperty.Separator`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-firehoseaction.html#cfn-iot-topicrule-firehoseaction-separator
         * @external
         */
        readonly separator?: string;
    }
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpaction.html
     * @external
     */
    interface HttpActionProperty {
        /**
         * `CfnTopicRule.HttpActionProperty.Auth`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpaction.html#cfn-iot-topicrule-httpaction-auth
         * @external
         */
        readonly auth?: CfnTopicRule.HttpAuthorizationProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.HttpActionProperty.ConfirmationUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpaction.html#cfn-iot-topicrule-httpaction-confirmationurl
         * @external
         */
        readonly confirmationUrl?: string;
        /**
         * `CfnTopicRule.HttpActionProperty.Headers`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpaction.html#cfn-iot-topicrule-httpaction-headers
         * @external
         */
        readonly headers?: Array<CfnTopicRule.HttpActionHeaderProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTopicRule.HttpActionProperty.Url`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpaction.html#cfn-iot-topicrule-httpaction-url
         * @external
         */
        readonly url: string;
    }
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpactionheader.html
     * @external
     */
    interface HttpActionHeaderProperty {
        /**
         * `CfnTopicRule.HttpActionHeaderProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpactionheader.html#cfn-iot-topicrule-httpactionheader-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnTopicRule.HttpActionHeaderProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpactionheader.html#cfn-iot-topicrule-httpactionheader-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpauthorization.html
     * @external
     */
    interface HttpAuthorizationProperty {
        /**
         * `CfnTopicRule.HttpAuthorizationProperty.Sigv4`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpauthorization.html#cfn-iot-topicrule-httpauthorization-sigv4
         * @external
         */
        readonly sigv4?: CfnTopicRule.SigV4AuthorizationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotanalyticsaction.html
     * @external
     */
    interface IotAnalyticsActionProperty {
        /**
         * `CfnTopicRule.IotAnalyticsActionProperty.ChannelName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotanalyticsaction.html#cfn-iot-topicrule-iotanalyticsaction-channelname
         * @external
         */
        readonly channelName: string;
        /**
         * `CfnTopicRule.IotAnalyticsActionProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotanalyticsaction.html#cfn-iot-topicrule-iotanalyticsaction-rolearn
         * @external
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-ioteventsaction.html
     * @external
     */
    interface IotEventsActionProperty {
        /**
         * `CfnTopicRule.IotEventsActionProperty.InputName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-ioteventsaction.html#cfn-iot-topicrule-ioteventsaction-inputname
         * @external
         */
        readonly inputName: string;
        /**
         * `CfnTopicRule.IotEventsActionProperty.MessageId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-ioteventsaction.html#cfn-iot-topicrule-ioteventsaction-messageid
         * @external
         */
        readonly messageId?: string;
        /**
         * `CfnTopicRule.IotEventsActionProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-ioteventsaction.html#cfn-iot-topicrule-ioteventsaction-rolearn
         * @external
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotsitewiseaction.html
     * @external
     */
    interface IotSiteWiseActionProperty {
        /**
         * `CfnTopicRule.IotSiteWiseActionProperty.PutAssetPropertyValueEntries`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotsitewiseaction.html#cfn-iot-topicrule-iotsitewiseaction-putassetpropertyvalueentries
         * @external
         */
        readonly putAssetPropertyValueEntries: Array<CfnTopicRule.PutAssetPropertyValueEntryProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTopicRule.IotSiteWiseActionProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotsitewiseaction.html#cfn-iot-topicrule-iotsitewiseaction-rolearn
         * @external
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kinesisaction.html
     * @external
     */
    interface KinesisActionProperty {
        /**
         * `CfnTopicRule.KinesisActionProperty.PartitionKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kinesisaction.html#cfn-iot-topicrule-kinesisaction-partitionkey
         * @external
         */
        readonly partitionKey?: string;
        /**
         * `CfnTopicRule.KinesisActionProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kinesisaction.html#cfn-iot-topicrule-kinesisaction-rolearn
         * @external
         */
        readonly roleArn: string;
        /**
         * `CfnTopicRule.KinesisActionProperty.StreamName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kinesisaction.html#cfn-iot-topicrule-kinesisaction-streamname
         * @external
         */
        readonly streamName: string;
    }
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-lambdaaction.html
     * @external
     */
    interface LambdaActionProperty {
        /**
         * `CfnTopicRule.LambdaActionProperty.FunctionArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-lambdaaction.html#cfn-iot-topicrule-lambdaaction-functionarn
         * @external
         */
        readonly functionArn?: string;
    }
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putassetpropertyvalueentry.html
     * @external
     */
    interface PutAssetPropertyValueEntryProperty {
        /**
         * `CfnTopicRule.PutAssetPropertyValueEntryProperty.AssetId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putassetpropertyvalueentry.html#cfn-iot-topicrule-putassetpropertyvalueentry-assetid
         * @external
         */
        readonly assetId?: string;
        /**
         * `CfnTopicRule.PutAssetPropertyValueEntryProperty.EntryId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putassetpropertyvalueentry.html#cfn-iot-topicrule-putassetpropertyvalueentry-entryid
         * @external
         */
        readonly entryId?: string;
        /**
         * `CfnTopicRule.PutAssetPropertyValueEntryProperty.PropertyAlias`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putassetpropertyvalueentry.html#cfn-iot-topicrule-putassetpropertyvalueentry-propertyalias
         * @external
         */
        readonly propertyAlias?: string;
        /**
         * `CfnTopicRule.PutAssetPropertyValueEntryProperty.PropertyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putassetpropertyvalueentry.html#cfn-iot-topicrule-putassetpropertyvalueentry-propertyid
         * @external
         */
        readonly propertyId?: string;
        /**
         * `CfnTopicRule.PutAssetPropertyValueEntryProperty.PropertyValues`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putassetpropertyvalueentry.html#cfn-iot-topicrule-putassetpropertyvalueentry-propertyvalues
         * @external
         */
        readonly propertyValues: Array<CfnTopicRule.AssetPropertyValueProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putiteminput.html
     * @external
     */
    interface PutItemInputProperty {
        /**
         * `CfnTopicRule.PutItemInputProperty.TableName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putiteminput.html#cfn-iot-topicrule-putiteminput-tablename
         * @external
         */
        readonly tableName: string;
    }
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishaction.html
     * @external
     */
    interface RepublishActionProperty {
        /**
         * `CfnTopicRule.RepublishActionProperty.Qos`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishaction.html#cfn-iot-topicrule-republishaction-qos
         * @external
         */
        readonly qos?: number;
        /**
         * `CfnTopicRule.RepublishActionProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishaction.html#cfn-iot-topicrule-republishaction-rolearn
         * @external
         */
        readonly roleArn: string;
        /**
         * `CfnTopicRule.RepublishActionProperty.Topic`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishaction.html#cfn-iot-topicrule-republishaction-topic
         * @external
         */
        readonly topic: string;
    }
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-s3action.html
     * @external
     */
    interface S3ActionProperty {
        /**
         * `CfnTopicRule.S3ActionProperty.BucketName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-s3action.html#cfn-iot-topicrule-s3action-bucketname
         * @external
         */
        readonly bucketName: string;
        /**
         * `CfnTopicRule.S3ActionProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-s3action.html#cfn-iot-topicrule-s3action-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnTopicRule.S3ActionProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-s3action.html#cfn-iot-topicrule-s3action-rolearn
         * @external
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sigv4authorization.html
     * @external
     */
    interface SigV4AuthorizationProperty {
        /**
         * `CfnTopicRule.SigV4AuthorizationProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sigv4authorization.html#cfn-iot-topicrule-sigv4authorization-rolearn
         * @external
         */
        readonly roleArn: string;
        /**
         * `CfnTopicRule.SigV4AuthorizationProperty.ServiceName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sigv4authorization.html#cfn-iot-topicrule-sigv4authorization-servicename
         * @external
         */
        readonly serviceName: string;
        /**
         * `CfnTopicRule.SigV4AuthorizationProperty.SigningRegion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sigv4authorization.html#cfn-iot-topicrule-sigv4authorization-signingregion
         * @external
         */
        readonly signingRegion: string;
    }
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-snsaction.html
     * @external
     */
    interface SnsActionProperty {
        /**
         * `CfnTopicRule.SnsActionProperty.MessageFormat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-snsaction.html#cfn-iot-topicrule-snsaction-messageformat
         * @external
         */
        readonly messageFormat?: string;
        /**
         * `CfnTopicRule.SnsActionProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-snsaction.html#cfn-iot-topicrule-snsaction-rolearn
         * @external
         */
        readonly roleArn: string;
        /**
         * `CfnTopicRule.SnsActionProperty.TargetArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-snsaction.html#cfn-iot-topicrule-snsaction-targetarn
         * @external
         */
        readonly targetArn: string;
    }
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sqsaction.html
     * @external
     */
    interface SqsActionProperty {
        /**
         * `CfnTopicRule.SqsActionProperty.QueueUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sqsaction.html#cfn-iot-topicrule-sqsaction-queueurl
         * @external
         */
        readonly queueUrl: string;
        /**
         * `CfnTopicRule.SqsActionProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sqsaction.html#cfn-iot-topicrule-sqsaction-rolearn
         * @external
         */
        readonly roleArn: string;
        /**
         * `CfnTopicRule.SqsActionProperty.UseBase64`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sqsaction.html#cfn-iot-topicrule-sqsaction-usebase64
         * @external
         */
        readonly useBase64?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-stepfunctionsaction.html
     * @external
     */
    interface StepFunctionsActionProperty {
        /**
         * `CfnTopicRule.StepFunctionsActionProperty.ExecutionNamePrefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-stepfunctionsaction.html#cfn-iot-topicrule-stepfunctionsaction-executionnameprefix
         * @external
         */
        readonly executionNamePrefix?: string;
        /**
         * `CfnTopicRule.StepFunctionsActionProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-stepfunctionsaction.html#cfn-iot-topicrule-stepfunctionsaction-rolearn
         * @external
         */
        readonly roleArn: string;
        /**
         * `CfnTopicRule.StepFunctionsActionProperty.StateMachineName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-stepfunctionsaction.html#cfn-iot-topicrule-stepfunctionsaction-statemachinename
         * @external
         */
        readonly stateMachineName: string;
    }
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 * @external
 * @cloudformationResource AWS::IoT::TopicRule
 */
export declare namespace CfnTopicRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html
     * @external
     */
    interface TopicRulePayloadProperty {
        /**
         * `CfnTopicRule.TopicRulePayloadProperty.Actions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-actions
         * @external
         */
        readonly actions: Array<CfnTopicRule.ActionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTopicRule.TopicRulePayloadProperty.AwsIotSqlVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-awsiotsqlversion
         * @external
         */
        readonly awsIotSqlVersion?: string;
        /**
         * `CfnTopicRule.TopicRulePayloadProperty.Description`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-description
         * @external
         */
        readonly description?: string;
        /**
         * `CfnTopicRule.TopicRulePayloadProperty.ErrorAction`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-erroraction
         * @external
         */
        readonly errorAction?: CfnTopicRule.ActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.TopicRulePayloadProperty.RuleDisabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-ruledisabled
         * @external
         */
        readonly ruleDisabled: boolean | cdk.IResolvable;
        /**
         * `CfnTopicRule.TopicRulePayloadProperty.Sql`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-sql
         * @external
         */
        readonly sql: string;
    }
}
