"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImmutableRole = void 0;
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * An immutable wrapper around an IRole
 *
 * This wrapper ignores all mutating operations, like attaching policies or
 * adding policy statements.
 *
 * Useful in cases where you want to turn off CDK's automatic permissions
 * management, and instead have full control over all permissions.
 *
 * Note: if you want to ignore all mutations for an externally defined role
 * which was imported into the CDK with {@link Role.fromRoleArn}, you don't have to use this class -
 * simply pass the property mutable = false when calling {@link Role.fromRoleArn}.
 */
class ImmutableRole extends core_1.Resource {
    constructor(scope, id, role) {
        super(scope, id, {
            account: role.env.account,
            region: role.env.region,
        });
        this.role = role;
        this.assumeRoleAction = this.role.assumeRoleAction;
        this.policyFragment = this.role.policyFragment;
        this.grantPrincipal = this;
        this.principalAccount = this.role.principalAccount;
        this.roleArn = this.role.roleArn;
        this.roleName = this.role.roleName;
        this.stack = this.role.stack;
        // implement IDependable privately
        core_1.DependableTrait.implement(this, {
            dependencyRoots: [role],
        });
    }
    attachInlinePolicy(_policy) {
        // do nothing
    }
    addManagedPolicy(_policy) {
        // do nothing
    }
    addToPolicy(statement) {
        return this.addToPrincipalPolicy(statement).statementAdded;
    }
    addToPrincipalPolicy(_statement) {
        // Not really added, but for the purposes of consumer code pretend that it was.
        return { statementAdded: true, policyDependable: new core_1.ConcreteDependable() };
    }
    grant(grantee, ...actions) {
        return this.role.grant(grantee, ...actions);
    }
    grantPassRole(grantee) {
        return this.role.grantPassRole(grantee);
    }
}
exports.ImmutableRole = ImmutableRole;
//# sourceMappingURL=data:application/json;base64,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