import * as cdk from "../../core";
import { PolicyStatement } from './policy-statement';
/**
 * (experimental) Properties for a new PolicyDocument.
 *
 * @experimental
 */
export interface PolicyDocumentProps {
    /**
     * (experimental) Automatically assign Statement Ids to all statements.
     *
     * @default false
     * @experimental
     */
    readonly assignSids?: boolean;
    /**
     * (experimental) Initial statements to add to the policy document.
     *
     * @default - No statements
     * @experimental
     */
    readonly statements?: PolicyStatement[];
}
/**
 * (experimental) A PolicyDocument is a collection of statements.
 *
 * @experimental
 */
export declare class PolicyDocument implements cdk.IResolvable {
    /**
     * (experimental) Creates a new PolicyDocument based on the object provided.
     *
     * This will accept an object created from the `.toJSON()` call
     *
     * @param obj the PolicyDocument in object form.
     * @experimental
     */
    static fromJson(obj: any): PolicyDocument;
    /**
     * (experimental) The creation stack of this resolvable which will be appended to errors thrown during resolution.
     *
     * If this returns an empty array the stack will not be attached.
     *
     * @experimental
     */
    readonly creationStack: string[];
    private readonly statements;
    private readonly autoAssignSids;
    /**
     * @experimental
     */
    constructor(props?: PolicyDocumentProps);
    /**
     * (experimental) Produce the Token's value at resolution time.
     *
     * @experimental
     */
    resolve(context: cdk.IResolveContext): any;
    /**
     * (experimental) Whether the policy document contains any statements.
     *
     * @experimental
     */
    get isEmpty(): boolean;
    /**
     * (experimental) The number of statements already added to this policy.
     *
     * Can be used, for example, to generate unique "sid"s within the policy.
     *
     * @experimental
     */
    get statementCount(): number;
    /**
     * (experimental) Adds a statement to the policy document.
     *
     * @param statement the statement to add.
     * @experimental
     */
    addStatements(...statement: PolicyStatement[]): void;
    /**
     * (experimental) Encode the policy document as a string.
     *
     * @experimental
     */
    toString(): string;
    /**
     * (experimental) JSON-ify the document.
     *
     * Used when JSON.stringify() is called
     *
     * @experimental
     */
    toJSON(): any;
    /**
     * (experimental) Validate that all policy statements in the policy document satisfies the requirements for any policy.
     *
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json
     * @experimental
     */
    validateForAnyPolicy(): string[];
    /**
     * (experimental) Validate that all policy statements in the policy document satisfies the requirements for a resource-based policy.
     *
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json
     * @experimental
     */
    validateForResourcePolicy(): string[];
    /**
     * (experimental) Validate that all policy statements in the policy document satisfies the requirements for an identity-based policy.
     *
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json
     * @experimental
     */
    validateForIdentityPolicy(): string[];
    private render;
}
