import { IResource } from "../../core";
import { IManagedPolicy } from './managed-policy';
import { Policy } from './policy';
import { IPrincipal } from './principals';
/**
 * (experimental) A construct that represents an IAM principal, such as a user, group or role.
 *
 * @experimental
 */
export interface IIdentity extends IPrincipal, IResource {
    /**
     * (experimental) Attaches an inline policy to this principal.
     *
     * This is the same as calling `policy.addToXxx(principal)`.
     *
     * @param policy The policy resource to attach to this principal [disable-awslint:ref-via-interface].
     * @experimental
     */
    attachInlinePolicy(policy: Policy): void;
    /**
     * (experimental) Attaches a managed policy to this principal.
     *
     * @param policy The managed policy.
     * @experimental
     */
    addManagedPolicy(policy: IManagedPolicy): void;
}
