import { Resource } from "../../core";
import { Construct } from 'constructs';
import { IIdentity } from './identity-base';
import { IManagedPolicy } from './managed-policy';
import { Policy } from './policy';
import { PolicyStatement } from './policy-statement';
import { AddToPrincipalPolicyResult, IPrincipal, PrincipalPolicyFragment } from './principals';
import { IUser } from './user';
/**
 * (experimental) Represents an IAM Group.
 *
 * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/id_groups.html
 * @experimental
 */
export interface IGroup extends IIdentity {
    /**
     * (experimental) Returns the IAM Group Name.
     *
     * @experimental
     * @attribute true
     */
    readonly groupName: string;
    /**
     * (experimental) Returns the IAM Group ARN.
     *
     * @experimental
     * @attribute true
     */
    readonly groupArn: string;
}
/**
 * (experimental) Properties for defining an IAM group.
 *
 * @experimental
 */
export interface GroupProps {
    /**
     * (experimental) A name for the IAM group.
     *
     * For valid values, see the GroupName parameter
     * for the CreateGroup action in the IAM API Reference. If you don't specify
     * a name, AWS CloudFormation generates a unique physical ID and uses that
     * ID for the group name.
     *
     * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
     * acknowledge your template's capabilities. For more information, see
     * Acknowledging IAM Resources in AWS CloudFormation Templates.
     *
     * @default Generated by CloudFormation (recommended)
     * @experimental
     */
    readonly groupName?: string;
    /**
     * (experimental) A list of managed policies associated with this role.
     *
     * You can add managed policies later using
     * `addManagedPolicy(ManagedPolicy.fromAwsManagedPolicyName(policyName))`.
     *
     * @default - No managed policies.
     * @experimental
     */
    readonly managedPolicies?: IManagedPolicy[];
    /**
     * (experimental) The path to the group.
     *
     * For more information about paths, see [IAM
     * Identifiers](http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html)
     * in the IAM User Guide.
     *
     * @default /
     * @experimental
     */
    readonly path?: string;
}
declare abstract class GroupBase extends Resource implements IGroup {
    abstract readonly groupName: string;
    abstract readonly groupArn: string;
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    readonly grantPrincipal: IPrincipal;
    /**
     * (experimental) The AWS account ID of this principal.
     *
     * Can be undefined when the account is not known
     * (for example, for service principals).
     * Can be a Token - in that case,
     * it's assumed to be AWS::AccountId.
     *
     * @experimental
     */
    readonly principalAccount: string | undefined;
    /**
     * (experimental) When this Principal is used in an AssumeRole policy, the action to use.
     *
     * @experimental
     */
    readonly assumeRoleAction: string;
    private readonly attachedPolicies;
    private defaultPolicy?;
    /**
     * (experimental) Return the policy fragment that identifies this principal in a Policy.
     *
     * @experimental
     */
    get policyFragment(): PrincipalPolicyFragment;
    /**
     * (experimental) Attaches a policy to this group.
     *
     * @param policy The policy to attach.
     * @experimental
     */
    attachInlinePolicy(policy: Policy): void;
    addManagedPolicy(_policy: IManagedPolicy): void;
    /**
     * (experimental) Adds a user to this group.
     *
     * @experimental
     */
    addUser(user: IUser): void;
    /**
     * (experimental) Adds an IAM statement to the default policy.
     *
     * @experimental
     */
    addToPrincipalPolicy(statement: PolicyStatement): AddToPrincipalPolicyResult;
    /**
     * (experimental) Add to the policy of this principal.
     *
     * @experimental
     */
    addToPolicy(statement: PolicyStatement): boolean;
}
/**
 * (experimental) An IAM Group (collection of IAM users) lets you specify permissions for multiple users, which can make it easier to manage permissions for those users.
 *
 * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/id_groups.html
 * @experimental
 */
export declare class Group extends GroupBase {
    /**
     * (experimental) Import an external group by ARN.
     *
     * If the imported Group ARN is a Token (such as a
     * `CfnParameter.valueAsString` or a `Fn.importValue()`) *and* the referenced
     * group has a `path` (like `arn:...:group/AdminGroup/NetworkAdmin`), the
     * `groupName` property will not resolve to the correct value. Instead it
     * will resolve to the first path component. We unfortunately cannot express
     * the correct calculation of the full path name as a CloudFormation
     * expression. In this scenario the Group ARN should be supplied without the
     * `path` in order to resolve the correct group resource.
     *
     * @param scope construct scope.
     * @param id construct id.
     * @param groupArn the ARN of the group to import (e.g. `arn:aws:iam::account-id:group/group-name`).
     * @experimental
     */
    static fromGroupArn(scope: Construct, id: string, groupArn: string): IGroup;
    /**
     * (experimental) Returns the IAM Group Name.
     *
     * @experimental
     */
    readonly groupName: string;
    /**
     * (experimental) Returns the IAM Group ARN.
     *
     * @experimental
     */
    readonly groupArn: string;
    private readonly managedPolicies;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: GroupProps);
    /**
     * (experimental) Attaches a managed policy to this group.
     *
     * @param policy The managed policy to attach.
     * @experimental
     */
    addManagedPolicy(policy: IManagedPolicy): void;
}
export {};
