import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::Greengrass::ConnectorDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinition.html
 * @external
 */
export interface CfnConnectorDefinitionProps {
    /**
     * `AWS::Greengrass::ConnectorDefinition.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinition.html#cfn-greengrass-connectordefinition-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::Greengrass::ConnectorDefinition.InitialVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinition.html#cfn-greengrass-connectordefinition-initialversion
     * @external
     */
    readonly initialVersion?: CfnConnectorDefinition.ConnectorDefinitionVersionProperty | cdk.IResolvable;
    /**
     * `AWS::Greengrass::ConnectorDefinition.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinition.html#cfn-greengrass-connectordefinition-tags
     * @external
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Greengrass::ConnectorDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::ConnectorDefinition
 */
export declare class CfnConnectorDefinition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::ConnectorDefinition";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @external
     * @cloudformationAttribute LatestVersionArn
     */
    readonly attrLatestVersionArn: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::Greengrass::ConnectorDefinition.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinition.html#cfn-greengrass-connectordefinition-name
     * @external
     */
    name: string;
    /**
     * `AWS::Greengrass::ConnectorDefinition.InitialVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinition.html#cfn-greengrass-connectordefinition-initialversion
     * @external
     */
    initialVersion: CfnConnectorDefinition.ConnectorDefinitionVersionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Greengrass::ConnectorDefinition.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinition.html#cfn-greengrass-connectordefinition-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Greengrass::ConnectorDefinition`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConnectorDefinitionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Greengrass::ConnectorDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::ConnectorDefinition
 */
export declare namespace CfnConnectorDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-connectordefinition-connector.html
     * @external
     */
    interface ConnectorProperty {
        /**
         * `CfnConnectorDefinition.ConnectorProperty.ConnectorArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-connectordefinition-connector.html#cfn-greengrass-connectordefinition-connector-connectorarn
         * @external
         */
        readonly connectorArn: string;
        /**
         * `CfnConnectorDefinition.ConnectorProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-connectordefinition-connector.html#cfn-greengrass-connectordefinition-connector-id
         * @external
         */
        readonly id: string;
        /**
         * `CfnConnectorDefinition.ConnectorProperty.Parameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-connectordefinition-connector.html#cfn-greengrass-connectordefinition-connector-parameters
         * @external
         */
        readonly parameters?: any | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::ConnectorDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::ConnectorDefinition
 */
export declare namespace CfnConnectorDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-connectordefinition-connectordefinitionversion.html
     * @external
     */
    interface ConnectorDefinitionVersionProperty {
        /**
         * `CfnConnectorDefinition.ConnectorDefinitionVersionProperty.Connectors`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-connectordefinition-connectordefinitionversion.html#cfn-greengrass-connectordefinition-connectordefinitionversion-connectors
         * @external
         */
        readonly connectors: Array<CfnConnectorDefinition.ConnectorProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::Greengrass::ConnectorDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinitionversion.html
 * @external
 */
export interface CfnConnectorDefinitionVersionProps {
    /**
     * `AWS::Greengrass::ConnectorDefinitionVersion.ConnectorDefinitionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinitionversion.html#cfn-greengrass-connectordefinitionversion-connectordefinitionid
     * @external
     */
    readonly connectorDefinitionId: string;
    /**
     * `AWS::Greengrass::ConnectorDefinitionVersion.Connectors`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinitionversion.html#cfn-greengrass-connectordefinitionversion-connectors
     * @external
     */
    readonly connectors: Array<CfnConnectorDefinitionVersion.ConnectorProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Greengrass::ConnectorDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::ConnectorDefinitionVersion
 */
export declare class CfnConnectorDefinitionVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::ConnectorDefinitionVersion";
    /**
     * `AWS::Greengrass::ConnectorDefinitionVersion.ConnectorDefinitionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinitionversion.html#cfn-greengrass-connectordefinitionversion-connectordefinitionid
     * @external
     */
    connectorDefinitionId: string;
    /**
     * `AWS::Greengrass::ConnectorDefinitionVersion.Connectors`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinitionversion.html#cfn-greengrass-connectordefinitionversion-connectors
     * @external
     */
    connectors: Array<CfnConnectorDefinitionVersion.ConnectorProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * Create a new `AWS::Greengrass::ConnectorDefinitionVersion`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConnectorDefinitionVersionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Greengrass::ConnectorDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::ConnectorDefinitionVersion
 */
export declare namespace CfnConnectorDefinitionVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-connectordefinitionversion-connector.html
     * @external
     */
    interface ConnectorProperty {
        /**
         * `CfnConnectorDefinitionVersion.ConnectorProperty.ConnectorArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-connectordefinitionversion-connector.html#cfn-greengrass-connectordefinitionversion-connector-connectorarn
         * @external
         */
        readonly connectorArn: string;
        /**
         * `CfnConnectorDefinitionVersion.ConnectorProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-connectordefinitionversion-connector.html#cfn-greengrass-connectordefinitionversion-connector-id
         * @external
         */
        readonly id: string;
        /**
         * `CfnConnectorDefinitionVersion.ConnectorProperty.Parameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-connectordefinitionversion-connector.html#cfn-greengrass-connectordefinitionversion-connector-parameters
         * @external
         */
        readonly parameters?: any | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::Greengrass::CoreDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html
 * @external
 */
export interface CfnCoreDefinitionProps {
    /**
     * `AWS::Greengrass::CoreDefinition.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html#cfn-greengrass-coredefinition-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::Greengrass::CoreDefinition.InitialVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html#cfn-greengrass-coredefinition-initialversion
     * @external
     */
    readonly initialVersion?: CfnCoreDefinition.CoreDefinitionVersionProperty | cdk.IResolvable;
    /**
     * `AWS::Greengrass::CoreDefinition.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html#cfn-greengrass-coredefinition-tags
     * @external
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Greengrass::CoreDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::CoreDefinition
 */
export declare class CfnCoreDefinition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::CoreDefinition";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @external
     * @cloudformationAttribute LatestVersionArn
     */
    readonly attrLatestVersionArn: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::Greengrass::CoreDefinition.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html#cfn-greengrass-coredefinition-name
     * @external
     */
    name: string;
    /**
     * `AWS::Greengrass::CoreDefinition.InitialVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html#cfn-greengrass-coredefinition-initialversion
     * @external
     */
    initialVersion: CfnCoreDefinition.CoreDefinitionVersionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Greengrass::CoreDefinition.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html#cfn-greengrass-coredefinition-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Greengrass::CoreDefinition`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCoreDefinitionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Greengrass::CoreDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::CoreDefinition
 */
export declare namespace CfnCoreDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-core.html
     * @external
     */
    interface CoreProperty {
        /**
         * `CfnCoreDefinition.CoreProperty.CertificateArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-core.html#cfn-greengrass-coredefinition-core-certificatearn
         * @external
         */
        readonly certificateArn: string;
        /**
         * `CfnCoreDefinition.CoreProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-core.html#cfn-greengrass-coredefinition-core-id
         * @external
         */
        readonly id: string;
        /**
         * `CfnCoreDefinition.CoreProperty.SyncShadow`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-core.html#cfn-greengrass-coredefinition-core-syncshadow
         * @external
         */
        readonly syncShadow?: boolean | cdk.IResolvable;
        /**
         * `CfnCoreDefinition.CoreProperty.ThingArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-core.html#cfn-greengrass-coredefinition-core-thingarn
         * @external
         */
        readonly thingArn: string;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::CoreDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::CoreDefinition
 */
export declare namespace CfnCoreDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-coredefinitionversion.html
     * @external
     */
    interface CoreDefinitionVersionProperty {
        /**
         * `CfnCoreDefinition.CoreDefinitionVersionProperty.Cores`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-coredefinitionversion.html#cfn-greengrass-coredefinition-coredefinitionversion-cores
         * @external
         */
        readonly cores: Array<CfnCoreDefinition.CoreProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::Greengrass::CoreDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinitionversion.html
 * @external
 */
export interface CfnCoreDefinitionVersionProps {
    /**
     * `AWS::Greengrass::CoreDefinitionVersion.CoreDefinitionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinitionversion.html#cfn-greengrass-coredefinitionversion-coredefinitionid
     * @external
     */
    readonly coreDefinitionId: string;
    /**
     * `AWS::Greengrass::CoreDefinitionVersion.Cores`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinitionversion.html#cfn-greengrass-coredefinitionversion-cores
     * @external
     */
    readonly cores: Array<CfnCoreDefinitionVersion.CoreProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Greengrass::CoreDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::CoreDefinitionVersion
 */
export declare class CfnCoreDefinitionVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::CoreDefinitionVersion";
    /**
     * `AWS::Greengrass::CoreDefinitionVersion.CoreDefinitionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinitionversion.html#cfn-greengrass-coredefinitionversion-coredefinitionid
     * @external
     */
    coreDefinitionId: string;
    /**
     * `AWS::Greengrass::CoreDefinitionVersion.Cores`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinitionversion.html#cfn-greengrass-coredefinitionversion-cores
     * @external
     */
    cores: Array<CfnCoreDefinitionVersion.CoreProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * Create a new `AWS::Greengrass::CoreDefinitionVersion`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCoreDefinitionVersionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Greengrass::CoreDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::CoreDefinitionVersion
 */
export declare namespace CfnCoreDefinitionVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinitionversion-core.html
     * @external
     */
    interface CoreProperty {
        /**
         * `CfnCoreDefinitionVersion.CoreProperty.CertificateArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinitionversion-core.html#cfn-greengrass-coredefinitionversion-core-certificatearn
         * @external
         */
        readonly certificateArn: string;
        /**
         * `CfnCoreDefinitionVersion.CoreProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinitionversion-core.html#cfn-greengrass-coredefinitionversion-core-id
         * @external
         */
        readonly id: string;
        /**
         * `CfnCoreDefinitionVersion.CoreProperty.SyncShadow`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinitionversion-core.html#cfn-greengrass-coredefinitionversion-core-syncshadow
         * @external
         */
        readonly syncShadow?: boolean | cdk.IResolvable;
        /**
         * `CfnCoreDefinitionVersion.CoreProperty.ThingArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinitionversion-core.html#cfn-greengrass-coredefinitionversion-core-thingarn
         * @external
         */
        readonly thingArn: string;
    }
}
/**
 * Properties for defining a `AWS::Greengrass::DeviceDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinition.html
 * @external
 */
export interface CfnDeviceDefinitionProps {
    /**
     * `AWS::Greengrass::DeviceDefinition.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinition.html#cfn-greengrass-devicedefinition-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::Greengrass::DeviceDefinition.InitialVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinition.html#cfn-greengrass-devicedefinition-initialversion
     * @external
     */
    readonly initialVersion?: CfnDeviceDefinition.DeviceDefinitionVersionProperty | cdk.IResolvable;
    /**
     * `AWS::Greengrass::DeviceDefinition.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinition.html#cfn-greengrass-devicedefinition-tags
     * @external
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Greengrass::DeviceDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::DeviceDefinition
 */
export declare class CfnDeviceDefinition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::DeviceDefinition";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @external
     * @cloudformationAttribute LatestVersionArn
     */
    readonly attrLatestVersionArn: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::Greengrass::DeviceDefinition.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinition.html#cfn-greengrass-devicedefinition-name
     * @external
     */
    name: string;
    /**
     * `AWS::Greengrass::DeviceDefinition.InitialVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinition.html#cfn-greengrass-devicedefinition-initialversion
     * @external
     */
    initialVersion: CfnDeviceDefinition.DeviceDefinitionVersionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Greengrass::DeviceDefinition.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinition.html#cfn-greengrass-devicedefinition-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Greengrass::DeviceDefinition`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDeviceDefinitionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Greengrass::DeviceDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::DeviceDefinition
 */
export declare namespace CfnDeviceDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinition-device.html
     * @external
     */
    interface DeviceProperty {
        /**
         * `CfnDeviceDefinition.DeviceProperty.CertificateArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinition-device.html#cfn-greengrass-devicedefinition-device-certificatearn
         * @external
         */
        readonly certificateArn: string;
        /**
         * `CfnDeviceDefinition.DeviceProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinition-device.html#cfn-greengrass-devicedefinition-device-id
         * @external
         */
        readonly id: string;
        /**
         * `CfnDeviceDefinition.DeviceProperty.SyncShadow`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinition-device.html#cfn-greengrass-devicedefinition-device-syncshadow
         * @external
         */
        readonly syncShadow?: boolean | cdk.IResolvable;
        /**
         * `CfnDeviceDefinition.DeviceProperty.ThingArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinition-device.html#cfn-greengrass-devicedefinition-device-thingarn
         * @external
         */
        readonly thingArn: string;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::DeviceDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::DeviceDefinition
 */
export declare namespace CfnDeviceDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinition-devicedefinitionversion.html
     * @external
     */
    interface DeviceDefinitionVersionProperty {
        /**
         * `CfnDeviceDefinition.DeviceDefinitionVersionProperty.Devices`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinition-devicedefinitionversion.html#cfn-greengrass-devicedefinition-devicedefinitionversion-devices
         * @external
         */
        readonly devices: Array<CfnDeviceDefinition.DeviceProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::Greengrass::DeviceDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html
 * @external
 */
export interface CfnDeviceDefinitionVersionProps {
    /**
     * `AWS::Greengrass::DeviceDefinitionVersion.DeviceDefinitionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html#cfn-greengrass-devicedefinitionversion-devicedefinitionid
     * @external
     */
    readonly deviceDefinitionId: string;
    /**
     * `AWS::Greengrass::DeviceDefinitionVersion.Devices`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html#cfn-greengrass-devicedefinitionversion-devices
     * @external
     */
    readonly devices: Array<CfnDeviceDefinitionVersion.DeviceProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Greengrass::DeviceDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::DeviceDefinitionVersion
 */
export declare class CfnDeviceDefinitionVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::DeviceDefinitionVersion";
    /**
     * `AWS::Greengrass::DeviceDefinitionVersion.DeviceDefinitionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html#cfn-greengrass-devicedefinitionversion-devicedefinitionid
     * @external
     */
    deviceDefinitionId: string;
    /**
     * `AWS::Greengrass::DeviceDefinitionVersion.Devices`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html#cfn-greengrass-devicedefinitionversion-devices
     * @external
     */
    devices: Array<CfnDeviceDefinitionVersion.DeviceProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * Create a new `AWS::Greengrass::DeviceDefinitionVersion`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDeviceDefinitionVersionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Greengrass::DeviceDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::DeviceDefinitionVersion
 */
export declare namespace CfnDeviceDefinitionVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinitionversion-device.html
     * @external
     */
    interface DeviceProperty {
        /**
         * `CfnDeviceDefinitionVersion.DeviceProperty.CertificateArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinitionversion-device.html#cfn-greengrass-devicedefinitionversion-device-certificatearn
         * @external
         */
        readonly certificateArn: string;
        /**
         * `CfnDeviceDefinitionVersion.DeviceProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinitionversion-device.html#cfn-greengrass-devicedefinitionversion-device-id
         * @external
         */
        readonly id: string;
        /**
         * `CfnDeviceDefinitionVersion.DeviceProperty.SyncShadow`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinitionversion-device.html#cfn-greengrass-devicedefinitionversion-device-syncshadow
         * @external
         */
        readonly syncShadow?: boolean | cdk.IResolvable;
        /**
         * `CfnDeviceDefinitionVersion.DeviceProperty.ThingArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinitionversion-device.html#cfn-greengrass-devicedefinitionversion-device-thingarn
         * @external
         */
        readonly thingArn: string;
    }
}
/**
 * Properties for defining a `AWS::Greengrass::FunctionDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinition.html
 * @external
 */
export interface CfnFunctionDefinitionProps {
    /**
     * `AWS::Greengrass::FunctionDefinition.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinition.html#cfn-greengrass-functiondefinition-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::Greengrass::FunctionDefinition.InitialVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinition.html#cfn-greengrass-functiondefinition-initialversion
     * @external
     */
    readonly initialVersion?: CfnFunctionDefinition.FunctionDefinitionVersionProperty | cdk.IResolvable;
    /**
     * `AWS::Greengrass::FunctionDefinition.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinition.html#cfn-greengrass-functiondefinition-tags
     * @external
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Greengrass::FunctionDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::FunctionDefinition
 */
export declare class CfnFunctionDefinition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::FunctionDefinition";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @external
     * @cloudformationAttribute LatestVersionArn
     */
    readonly attrLatestVersionArn: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::Greengrass::FunctionDefinition.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinition.html#cfn-greengrass-functiondefinition-name
     * @external
     */
    name: string;
    /**
     * `AWS::Greengrass::FunctionDefinition.InitialVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinition.html#cfn-greengrass-functiondefinition-initialversion
     * @external
     */
    initialVersion: CfnFunctionDefinition.FunctionDefinitionVersionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Greengrass::FunctionDefinition.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinition.html#cfn-greengrass-functiondefinition-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Greengrass::FunctionDefinition`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFunctionDefinitionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Greengrass::FunctionDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::FunctionDefinition
 */
export declare namespace CfnFunctionDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-defaultconfig.html
     * @external
     */
    interface DefaultConfigProperty {
        /**
         * `CfnFunctionDefinition.DefaultConfigProperty.Execution`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-defaultconfig.html#cfn-greengrass-functiondefinition-defaultconfig-execution
         * @external
         */
        readonly execution: CfnFunctionDefinition.ExecutionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::FunctionDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::FunctionDefinition
 */
export declare namespace CfnFunctionDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-environment.html
     * @external
     */
    interface EnvironmentProperty {
        /**
         * `CfnFunctionDefinition.EnvironmentProperty.AccessSysfs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-environment.html#cfn-greengrass-functiondefinition-environment-accesssysfs
         * @external
         */
        readonly accessSysfs?: boolean | cdk.IResolvable;
        /**
         * `CfnFunctionDefinition.EnvironmentProperty.Execution`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-environment.html#cfn-greengrass-functiondefinition-environment-execution
         * @external
         */
        readonly execution?: CfnFunctionDefinition.ExecutionProperty | cdk.IResolvable;
        /**
         * `CfnFunctionDefinition.EnvironmentProperty.ResourceAccessPolicies`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-environment.html#cfn-greengrass-functiondefinition-environment-resourceaccesspolicies
         * @external
         */
        readonly resourceAccessPolicies?: Array<CfnFunctionDefinition.ResourceAccessPolicyProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFunctionDefinition.EnvironmentProperty.Variables`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-environment.html#cfn-greengrass-functiondefinition-environment-variables
         * @external
         */
        readonly variables?: any | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::FunctionDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::FunctionDefinition
 */
export declare namespace CfnFunctionDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-execution.html
     * @external
     */
    interface ExecutionProperty {
        /**
         * `CfnFunctionDefinition.ExecutionProperty.IsolationMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-execution.html#cfn-greengrass-functiondefinition-execution-isolationmode
         * @external
         */
        readonly isolationMode?: string;
        /**
         * `CfnFunctionDefinition.ExecutionProperty.RunAs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-execution.html#cfn-greengrass-functiondefinition-execution-runas
         * @external
         */
        readonly runAs?: CfnFunctionDefinition.RunAsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::FunctionDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::FunctionDefinition
 */
export declare namespace CfnFunctionDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-function.html
     * @external
     */
    interface FunctionProperty {
        /**
         * `CfnFunctionDefinition.FunctionProperty.FunctionArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-function.html#cfn-greengrass-functiondefinition-function-functionarn
         * @external
         */
        readonly functionArn: string;
        /**
         * `CfnFunctionDefinition.FunctionProperty.FunctionConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-function.html#cfn-greengrass-functiondefinition-function-functionconfiguration
         * @external
         */
        readonly functionConfiguration: CfnFunctionDefinition.FunctionConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnFunctionDefinition.FunctionProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-function.html#cfn-greengrass-functiondefinition-function-id
         * @external
         */
        readonly id: string;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::FunctionDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::FunctionDefinition
 */
export declare namespace CfnFunctionDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-functionconfiguration.html
     * @external
     */
    interface FunctionConfigurationProperty {
        /**
         * `CfnFunctionDefinition.FunctionConfigurationProperty.EncodingType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-functionconfiguration.html#cfn-greengrass-functiondefinition-functionconfiguration-encodingtype
         * @external
         */
        readonly encodingType?: string;
        /**
         * `CfnFunctionDefinition.FunctionConfigurationProperty.Environment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-functionconfiguration.html#cfn-greengrass-functiondefinition-functionconfiguration-environment
         * @external
         */
        readonly environment?: CfnFunctionDefinition.EnvironmentProperty | cdk.IResolvable;
        /**
         * `CfnFunctionDefinition.FunctionConfigurationProperty.ExecArgs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-functionconfiguration.html#cfn-greengrass-functiondefinition-functionconfiguration-execargs
         * @external
         */
        readonly execArgs?: string;
        /**
         * `CfnFunctionDefinition.FunctionConfigurationProperty.Executable`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-functionconfiguration.html#cfn-greengrass-functiondefinition-functionconfiguration-executable
         * @external
         */
        readonly executable?: string;
        /**
         * `CfnFunctionDefinition.FunctionConfigurationProperty.MemorySize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-functionconfiguration.html#cfn-greengrass-functiondefinition-functionconfiguration-memorysize
         * @external
         */
        readonly memorySize?: number;
        /**
         * `CfnFunctionDefinition.FunctionConfigurationProperty.Pinned`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-functionconfiguration.html#cfn-greengrass-functiondefinition-functionconfiguration-pinned
         * @external
         */
        readonly pinned?: boolean | cdk.IResolvable;
        /**
         * `CfnFunctionDefinition.FunctionConfigurationProperty.Timeout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-functionconfiguration.html#cfn-greengrass-functiondefinition-functionconfiguration-timeout
         * @external
         */
        readonly timeout?: number;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::FunctionDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::FunctionDefinition
 */
export declare namespace CfnFunctionDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-functiondefinitionversion.html
     * @external
     */
    interface FunctionDefinitionVersionProperty {
        /**
         * `CfnFunctionDefinition.FunctionDefinitionVersionProperty.DefaultConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-functiondefinitionversion.html#cfn-greengrass-functiondefinition-functiondefinitionversion-defaultconfig
         * @external
         */
        readonly defaultConfig?: CfnFunctionDefinition.DefaultConfigProperty | cdk.IResolvable;
        /**
         * `CfnFunctionDefinition.FunctionDefinitionVersionProperty.Functions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-functiondefinitionversion.html#cfn-greengrass-functiondefinition-functiondefinitionversion-functions
         * @external
         */
        readonly functions: Array<CfnFunctionDefinition.FunctionProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::FunctionDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::FunctionDefinition
 */
export declare namespace CfnFunctionDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-resourceaccesspolicy.html
     * @external
     */
    interface ResourceAccessPolicyProperty {
        /**
         * `CfnFunctionDefinition.ResourceAccessPolicyProperty.Permission`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-resourceaccesspolicy.html#cfn-greengrass-functiondefinition-resourceaccesspolicy-permission
         * @external
         */
        readonly permission?: string;
        /**
         * `CfnFunctionDefinition.ResourceAccessPolicyProperty.ResourceId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-resourceaccesspolicy.html#cfn-greengrass-functiondefinition-resourceaccesspolicy-resourceid
         * @external
         */
        readonly resourceId: string;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::FunctionDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::FunctionDefinition
 */
export declare namespace CfnFunctionDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-runas.html
     * @external
     */
    interface RunAsProperty {
        /**
         * `CfnFunctionDefinition.RunAsProperty.Gid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-runas.html#cfn-greengrass-functiondefinition-runas-gid
         * @external
         */
        readonly gid?: number;
        /**
         * `CfnFunctionDefinition.RunAsProperty.Uid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-runas.html#cfn-greengrass-functiondefinition-runas-uid
         * @external
         */
        readonly uid?: number;
    }
}
/**
 * Properties for defining a `AWS::Greengrass::FunctionDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html
 * @external
 */
export interface CfnFunctionDefinitionVersionProps {
    /**
     * `AWS::Greengrass::FunctionDefinitionVersion.FunctionDefinitionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html#cfn-greengrass-functiondefinitionversion-functiondefinitionid
     * @external
     */
    readonly functionDefinitionId: string;
    /**
     * `AWS::Greengrass::FunctionDefinitionVersion.Functions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html#cfn-greengrass-functiondefinitionversion-functions
     * @external
     */
    readonly functions: Array<CfnFunctionDefinitionVersion.FunctionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Greengrass::FunctionDefinitionVersion.DefaultConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html#cfn-greengrass-functiondefinitionversion-defaultconfig
     * @external
     */
    readonly defaultConfig?: CfnFunctionDefinitionVersion.DefaultConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Greengrass::FunctionDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::FunctionDefinitionVersion
 */
export declare class CfnFunctionDefinitionVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::FunctionDefinitionVersion";
    /**
     * `AWS::Greengrass::FunctionDefinitionVersion.FunctionDefinitionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html#cfn-greengrass-functiondefinitionversion-functiondefinitionid
     * @external
     */
    functionDefinitionId: string;
    /**
     * `AWS::Greengrass::FunctionDefinitionVersion.Functions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html#cfn-greengrass-functiondefinitionversion-functions
     * @external
     */
    functions: Array<CfnFunctionDefinitionVersion.FunctionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Greengrass::FunctionDefinitionVersion.DefaultConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html#cfn-greengrass-functiondefinitionversion-defaultconfig
     * @external
     */
    defaultConfig: CfnFunctionDefinitionVersion.DefaultConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Greengrass::FunctionDefinitionVersion`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFunctionDefinitionVersionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Greengrass::FunctionDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::FunctionDefinitionVersion
 */
export declare namespace CfnFunctionDefinitionVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-defaultconfig.html
     * @external
     */
    interface DefaultConfigProperty {
        /**
         * `CfnFunctionDefinitionVersion.DefaultConfigProperty.Execution`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-defaultconfig.html#cfn-greengrass-functiondefinitionversion-defaultconfig-execution
         * @external
         */
        readonly execution: CfnFunctionDefinitionVersion.ExecutionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::FunctionDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::FunctionDefinitionVersion
 */
export declare namespace CfnFunctionDefinitionVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html
     * @external
     */
    interface EnvironmentProperty {
        /**
         * `CfnFunctionDefinitionVersion.EnvironmentProperty.AccessSysfs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html#cfn-greengrass-functiondefinitionversion-environment-accesssysfs
         * @external
         */
        readonly accessSysfs?: boolean | cdk.IResolvable;
        /**
         * `CfnFunctionDefinitionVersion.EnvironmentProperty.Execution`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html#cfn-greengrass-functiondefinitionversion-environment-execution
         * @external
         */
        readonly execution?: CfnFunctionDefinitionVersion.ExecutionProperty | cdk.IResolvable;
        /**
         * `CfnFunctionDefinitionVersion.EnvironmentProperty.ResourceAccessPolicies`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html#cfn-greengrass-functiondefinitionversion-environment-resourceaccesspolicies
         * @external
         */
        readonly resourceAccessPolicies?: Array<CfnFunctionDefinitionVersion.ResourceAccessPolicyProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFunctionDefinitionVersion.EnvironmentProperty.Variables`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html#cfn-greengrass-functiondefinitionversion-environment-variables
         * @external
         */
        readonly variables?: any | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::FunctionDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::FunctionDefinitionVersion
 */
export declare namespace CfnFunctionDefinitionVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-execution.html
     * @external
     */
    interface ExecutionProperty {
        /**
         * `CfnFunctionDefinitionVersion.ExecutionProperty.IsolationMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-execution.html#cfn-greengrass-functiondefinitionversion-execution-isolationmode
         * @external
         */
        readonly isolationMode?: string;
        /**
         * `CfnFunctionDefinitionVersion.ExecutionProperty.RunAs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-execution.html#cfn-greengrass-functiondefinitionversion-execution-runas
         * @external
         */
        readonly runAs?: CfnFunctionDefinitionVersion.RunAsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::FunctionDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::FunctionDefinitionVersion
 */
export declare namespace CfnFunctionDefinitionVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-function.html
     * @external
     */
    interface FunctionProperty {
        /**
         * `CfnFunctionDefinitionVersion.FunctionProperty.FunctionArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-function.html#cfn-greengrass-functiondefinitionversion-function-functionarn
         * @external
         */
        readonly functionArn: string;
        /**
         * `CfnFunctionDefinitionVersion.FunctionProperty.FunctionConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-function.html#cfn-greengrass-functiondefinitionversion-function-functionconfiguration
         * @external
         */
        readonly functionConfiguration: CfnFunctionDefinitionVersion.FunctionConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnFunctionDefinitionVersion.FunctionProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-function.html#cfn-greengrass-functiondefinitionversion-function-id
         * @external
         */
        readonly id: string;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::FunctionDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::FunctionDefinitionVersion
 */
export declare namespace CfnFunctionDefinitionVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html
     * @external
     */
    interface FunctionConfigurationProperty {
        /**
         * `CfnFunctionDefinitionVersion.FunctionConfigurationProperty.EncodingType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-encodingtype
         * @external
         */
        readonly encodingType?: string;
        /**
         * `CfnFunctionDefinitionVersion.FunctionConfigurationProperty.Environment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-environment
         * @external
         */
        readonly environment?: CfnFunctionDefinitionVersion.EnvironmentProperty | cdk.IResolvable;
        /**
         * `CfnFunctionDefinitionVersion.FunctionConfigurationProperty.ExecArgs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-execargs
         * @external
         */
        readonly execArgs?: string;
        /**
         * `CfnFunctionDefinitionVersion.FunctionConfigurationProperty.Executable`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-executable
         * @external
         */
        readonly executable?: string;
        /**
         * `CfnFunctionDefinitionVersion.FunctionConfigurationProperty.MemorySize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-memorysize
         * @external
         */
        readonly memorySize?: number;
        /**
         * `CfnFunctionDefinitionVersion.FunctionConfigurationProperty.Pinned`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-pinned
         * @external
         */
        readonly pinned?: boolean | cdk.IResolvable;
        /**
         * `CfnFunctionDefinitionVersion.FunctionConfigurationProperty.Timeout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-timeout
         * @external
         */
        readonly timeout?: number;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::FunctionDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::FunctionDefinitionVersion
 */
export declare namespace CfnFunctionDefinitionVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-resourceaccesspolicy.html
     * @external
     */
    interface ResourceAccessPolicyProperty {
        /**
         * `CfnFunctionDefinitionVersion.ResourceAccessPolicyProperty.Permission`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-resourceaccesspolicy.html#cfn-greengrass-functiondefinitionversion-resourceaccesspolicy-permission
         * @external
         */
        readonly permission?: string;
        /**
         * `CfnFunctionDefinitionVersion.ResourceAccessPolicyProperty.ResourceId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-resourceaccesspolicy.html#cfn-greengrass-functiondefinitionversion-resourceaccesspolicy-resourceid
         * @external
         */
        readonly resourceId: string;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::FunctionDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::FunctionDefinitionVersion
 */
export declare namespace CfnFunctionDefinitionVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-runas.html
     * @external
     */
    interface RunAsProperty {
        /**
         * `CfnFunctionDefinitionVersion.RunAsProperty.Gid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-runas.html#cfn-greengrass-functiondefinitionversion-runas-gid
         * @external
         */
        readonly gid?: number;
        /**
         * `CfnFunctionDefinitionVersion.RunAsProperty.Uid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-runas.html#cfn-greengrass-functiondefinitionversion-runas-uid
         * @external
         */
        readonly uid?: number;
    }
}
/**
 * Properties for defining a `AWS::Greengrass::Group`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html
 * @external
 */
export interface CfnGroupProps {
    /**
     * `AWS::Greengrass::Group.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html#cfn-greengrass-group-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::Greengrass::Group.InitialVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html#cfn-greengrass-group-initialversion
     * @external
     */
    readonly initialVersion?: CfnGroup.GroupVersionProperty | cdk.IResolvable;
    /**
     * `AWS::Greengrass::Group.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html#cfn-greengrass-group-rolearn
     * @external
     */
    readonly roleArn?: string;
    /**
     * `AWS::Greengrass::Group.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html#cfn-greengrass-group-tags
     * @external
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Greengrass::Group`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html
 * @external
 * @cloudformationResource AWS::Greengrass::Group
 */
export declare class CfnGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::Group";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @external
     * @cloudformationAttribute LatestVersionArn
     */
    readonly attrLatestVersionArn: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * @external
     * @cloudformationAttribute RoleArn
     */
    readonly attrRoleArn: string;
    /**
     * @external
     * @cloudformationAttribute RoleAttachedAt
     */
    readonly attrRoleAttachedAt: string;
    /**
     * `AWS::Greengrass::Group.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html#cfn-greengrass-group-name
     * @external
     */
    name: string;
    /**
     * `AWS::Greengrass::Group.InitialVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html#cfn-greengrass-group-initialversion
     * @external
     */
    initialVersion: CfnGroup.GroupVersionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Greengrass::Group.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html#cfn-greengrass-group-rolearn
     * @external
     */
    roleArn: string | undefined;
    /**
     * `AWS::Greengrass::Group.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html#cfn-greengrass-group-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Greengrass::Group`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Greengrass::Group`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html
 * @external
 * @cloudformationResource AWS::Greengrass::Group
 */
export declare namespace CfnGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html
     * @external
     */
    interface GroupVersionProperty {
        /**
         * `CfnGroup.GroupVersionProperty.ConnectorDefinitionVersionArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-connectordefinitionversionarn
         * @external
         */
        readonly connectorDefinitionVersionArn?: string;
        /**
         * `CfnGroup.GroupVersionProperty.CoreDefinitionVersionArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-coredefinitionversionarn
         * @external
         */
        readonly coreDefinitionVersionArn?: string;
        /**
         * `CfnGroup.GroupVersionProperty.DeviceDefinitionVersionArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-devicedefinitionversionarn
         * @external
         */
        readonly deviceDefinitionVersionArn?: string;
        /**
         * `CfnGroup.GroupVersionProperty.FunctionDefinitionVersionArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-functiondefinitionversionarn
         * @external
         */
        readonly functionDefinitionVersionArn?: string;
        /**
         * `CfnGroup.GroupVersionProperty.LoggerDefinitionVersionArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-loggerdefinitionversionarn
         * @external
         */
        readonly loggerDefinitionVersionArn?: string;
        /**
         * `CfnGroup.GroupVersionProperty.ResourceDefinitionVersionArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-resourcedefinitionversionarn
         * @external
         */
        readonly resourceDefinitionVersionArn?: string;
        /**
         * `CfnGroup.GroupVersionProperty.SubscriptionDefinitionVersionArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-subscriptiondefinitionversionarn
         * @external
         */
        readonly subscriptionDefinitionVersionArn?: string;
    }
}
/**
 * Properties for defining a `AWS::Greengrass::GroupVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html
 * @external
 */
export interface CfnGroupVersionProps {
    /**
     * `AWS::Greengrass::GroupVersion.GroupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-groupid
     * @external
     */
    readonly groupId: string;
    /**
     * `AWS::Greengrass::GroupVersion.ConnectorDefinitionVersionArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-connectordefinitionversionarn
     * @external
     */
    readonly connectorDefinitionVersionArn?: string;
    /**
     * `AWS::Greengrass::GroupVersion.CoreDefinitionVersionArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-coredefinitionversionarn
     * @external
     */
    readonly coreDefinitionVersionArn?: string;
    /**
     * `AWS::Greengrass::GroupVersion.DeviceDefinitionVersionArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-devicedefinitionversionarn
     * @external
     */
    readonly deviceDefinitionVersionArn?: string;
    /**
     * `AWS::Greengrass::GroupVersion.FunctionDefinitionVersionArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-functiondefinitionversionarn
     * @external
     */
    readonly functionDefinitionVersionArn?: string;
    /**
     * `AWS::Greengrass::GroupVersion.LoggerDefinitionVersionArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-loggerdefinitionversionarn
     * @external
     */
    readonly loggerDefinitionVersionArn?: string;
    /**
     * `AWS::Greengrass::GroupVersion.ResourceDefinitionVersionArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-resourcedefinitionversionarn
     * @external
     */
    readonly resourceDefinitionVersionArn?: string;
    /**
     * `AWS::Greengrass::GroupVersion.SubscriptionDefinitionVersionArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-subscriptiondefinitionversionarn
     * @external
     */
    readonly subscriptionDefinitionVersionArn?: string;
}
/**
 * A CloudFormation `AWS::Greengrass::GroupVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::GroupVersion
 */
export declare class CfnGroupVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::GroupVersion";
    /**
     * `AWS::Greengrass::GroupVersion.GroupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-groupid
     * @external
     */
    groupId: string;
    /**
     * `AWS::Greengrass::GroupVersion.ConnectorDefinitionVersionArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-connectordefinitionversionarn
     * @external
     */
    connectorDefinitionVersionArn: string | undefined;
    /**
     * `AWS::Greengrass::GroupVersion.CoreDefinitionVersionArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-coredefinitionversionarn
     * @external
     */
    coreDefinitionVersionArn: string | undefined;
    /**
     * `AWS::Greengrass::GroupVersion.DeviceDefinitionVersionArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-devicedefinitionversionarn
     * @external
     */
    deviceDefinitionVersionArn: string | undefined;
    /**
     * `AWS::Greengrass::GroupVersion.FunctionDefinitionVersionArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-functiondefinitionversionarn
     * @external
     */
    functionDefinitionVersionArn: string | undefined;
    /**
     * `AWS::Greengrass::GroupVersion.LoggerDefinitionVersionArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-loggerdefinitionversionarn
     * @external
     */
    loggerDefinitionVersionArn: string | undefined;
    /**
     * `AWS::Greengrass::GroupVersion.ResourceDefinitionVersionArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-resourcedefinitionversionarn
     * @external
     */
    resourceDefinitionVersionArn: string | undefined;
    /**
     * `AWS::Greengrass::GroupVersion.SubscriptionDefinitionVersionArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-subscriptiondefinitionversionarn
     * @external
     */
    subscriptionDefinitionVersionArn: string | undefined;
    /**
     * Create a new `AWS::Greengrass::GroupVersion`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnGroupVersionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Greengrass::LoggerDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html
 * @external
 */
export interface CfnLoggerDefinitionProps {
    /**
     * `AWS::Greengrass::LoggerDefinition.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html#cfn-greengrass-loggerdefinition-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::Greengrass::LoggerDefinition.InitialVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html#cfn-greengrass-loggerdefinition-initialversion
     * @external
     */
    readonly initialVersion?: CfnLoggerDefinition.LoggerDefinitionVersionProperty | cdk.IResolvable;
    /**
     * `AWS::Greengrass::LoggerDefinition.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html#cfn-greengrass-loggerdefinition-tags
     * @external
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Greengrass::LoggerDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::LoggerDefinition
 */
export declare class CfnLoggerDefinition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::LoggerDefinition";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @external
     * @cloudformationAttribute LatestVersionArn
     */
    readonly attrLatestVersionArn: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::Greengrass::LoggerDefinition.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html#cfn-greengrass-loggerdefinition-name
     * @external
     */
    name: string;
    /**
     * `AWS::Greengrass::LoggerDefinition.InitialVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html#cfn-greengrass-loggerdefinition-initialversion
     * @external
     */
    initialVersion: CfnLoggerDefinition.LoggerDefinitionVersionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Greengrass::LoggerDefinition.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html#cfn-greengrass-loggerdefinition-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Greengrass::LoggerDefinition`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLoggerDefinitionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Greengrass::LoggerDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::LoggerDefinition
 */
export declare namespace CfnLoggerDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html
     * @external
     */
    interface LoggerProperty {
        /**
         * `CfnLoggerDefinition.LoggerProperty.Component`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html#cfn-greengrass-loggerdefinition-logger-component
         * @external
         */
        readonly component: string;
        /**
         * `CfnLoggerDefinition.LoggerProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html#cfn-greengrass-loggerdefinition-logger-id
         * @external
         */
        readonly id: string;
        /**
         * `CfnLoggerDefinition.LoggerProperty.Level`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html#cfn-greengrass-loggerdefinition-logger-level
         * @external
         */
        readonly level: string;
        /**
         * `CfnLoggerDefinition.LoggerProperty.Space`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html#cfn-greengrass-loggerdefinition-logger-space
         * @external
         */
        readonly space?: number;
        /**
         * `CfnLoggerDefinition.LoggerProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html#cfn-greengrass-loggerdefinition-logger-type
         * @external
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::LoggerDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::LoggerDefinition
 */
export declare namespace CfnLoggerDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-loggerdefinitionversion.html
     * @external
     */
    interface LoggerDefinitionVersionProperty {
        /**
         * `CfnLoggerDefinition.LoggerDefinitionVersionProperty.Loggers`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-loggerdefinitionversion.html#cfn-greengrass-loggerdefinition-loggerdefinitionversion-loggers
         * @external
         */
        readonly loggers: Array<CfnLoggerDefinition.LoggerProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::Greengrass::LoggerDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinitionversion.html
 * @external
 */
export interface CfnLoggerDefinitionVersionProps {
    /**
     * `AWS::Greengrass::LoggerDefinitionVersion.LoggerDefinitionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinitionversion.html#cfn-greengrass-loggerdefinitionversion-loggerdefinitionid
     * @external
     */
    readonly loggerDefinitionId: string;
    /**
     * `AWS::Greengrass::LoggerDefinitionVersion.Loggers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinitionversion.html#cfn-greengrass-loggerdefinitionversion-loggers
     * @external
     */
    readonly loggers: Array<CfnLoggerDefinitionVersion.LoggerProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Greengrass::LoggerDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::LoggerDefinitionVersion
 */
export declare class CfnLoggerDefinitionVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::LoggerDefinitionVersion";
    /**
     * `AWS::Greengrass::LoggerDefinitionVersion.LoggerDefinitionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinitionversion.html#cfn-greengrass-loggerdefinitionversion-loggerdefinitionid
     * @external
     */
    loggerDefinitionId: string;
    /**
     * `AWS::Greengrass::LoggerDefinitionVersion.Loggers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinitionversion.html#cfn-greengrass-loggerdefinitionversion-loggers
     * @external
     */
    loggers: Array<CfnLoggerDefinitionVersion.LoggerProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * Create a new `AWS::Greengrass::LoggerDefinitionVersion`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLoggerDefinitionVersionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Greengrass::LoggerDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::LoggerDefinitionVersion
 */
export declare namespace CfnLoggerDefinitionVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinitionversion-logger.html
     * @external
     */
    interface LoggerProperty {
        /**
         * `CfnLoggerDefinitionVersion.LoggerProperty.Component`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinitionversion-logger.html#cfn-greengrass-loggerdefinitionversion-logger-component
         * @external
         */
        readonly component: string;
        /**
         * `CfnLoggerDefinitionVersion.LoggerProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinitionversion-logger.html#cfn-greengrass-loggerdefinitionversion-logger-id
         * @external
         */
        readonly id: string;
        /**
         * `CfnLoggerDefinitionVersion.LoggerProperty.Level`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinitionversion-logger.html#cfn-greengrass-loggerdefinitionversion-logger-level
         * @external
         */
        readonly level: string;
        /**
         * `CfnLoggerDefinitionVersion.LoggerProperty.Space`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinitionversion-logger.html#cfn-greengrass-loggerdefinitionversion-logger-space
         * @external
         */
        readonly space?: number;
        /**
         * `CfnLoggerDefinitionVersion.LoggerProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinitionversion-logger.html#cfn-greengrass-loggerdefinitionversion-logger-type
         * @external
         */
        readonly type: string;
    }
}
/**
 * Properties for defining a `AWS::Greengrass::ResourceDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinition.html
 * @external
 */
export interface CfnResourceDefinitionProps {
    /**
     * `AWS::Greengrass::ResourceDefinition.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinition.html#cfn-greengrass-resourcedefinition-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::Greengrass::ResourceDefinition.InitialVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinition.html#cfn-greengrass-resourcedefinition-initialversion
     * @external
     */
    readonly initialVersion?: CfnResourceDefinition.ResourceDefinitionVersionProperty | cdk.IResolvable;
    /**
     * `AWS::Greengrass::ResourceDefinition.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinition.html#cfn-greengrass-resourcedefinition-tags
     * @external
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Greengrass::ResourceDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::ResourceDefinition
 */
export declare class CfnResourceDefinition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::ResourceDefinition";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @external
     * @cloudformationAttribute LatestVersionArn
     */
    readonly attrLatestVersionArn: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::Greengrass::ResourceDefinition.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinition.html#cfn-greengrass-resourcedefinition-name
     * @external
     */
    name: string;
    /**
     * `AWS::Greengrass::ResourceDefinition.InitialVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinition.html#cfn-greengrass-resourcedefinition-initialversion
     * @external
     */
    initialVersion: CfnResourceDefinition.ResourceDefinitionVersionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Greengrass::ResourceDefinition.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinition.html#cfn-greengrass-resourcedefinition-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Greengrass::ResourceDefinition`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnResourceDefinitionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Greengrass::ResourceDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::ResourceDefinition
 */
export declare namespace CfnResourceDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-groupownersetting.html
     * @external
     */
    interface GroupOwnerSettingProperty {
        /**
         * `CfnResourceDefinition.GroupOwnerSettingProperty.AutoAddGroupOwner`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-groupownersetting.html#cfn-greengrass-resourcedefinition-groupownersetting-autoaddgroupowner
         * @external
         */
        readonly autoAddGroupOwner: boolean | cdk.IResolvable;
        /**
         * `CfnResourceDefinition.GroupOwnerSettingProperty.GroupOwner`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-groupownersetting.html#cfn-greengrass-resourcedefinition-groupownersetting-groupowner
         * @external
         */
        readonly groupOwner?: string;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::ResourceDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::ResourceDefinition
 */
export declare namespace CfnResourceDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-localdeviceresourcedata.html
     * @external
     */
    interface LocalDeviceResourceDataProperty {
        /**
         * `CfnResourceDefinition.LocalDeviceResourceDataProperty.GroupOwnerSetting`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-localdeviceresourcedata.html#cfn-greengrass-resourcedefinition-localdeviceresourcedata-groupownersetting
         * @external
         */
        readonly groupOwnerSetting?: CfnResourceDefinition.GroupOwnerSettingProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinition.LocalDeviceResourceDataProperty.SourcePath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-localdeviceresourcedata.html#cfn-greengrass-resourcedefinition-localdeviceresourcedata-sourcepath
         * @external
         */
        readonly sourcePath: string;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::ResourceDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::ResourceDefinition
 */
export declare namespace CfnResourceDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-localvolumeresourcedata.html
     * @external
     */
    interface LocalVolumeResourceDataProperty {
        /**
         * `CfnResourceDefinition.LocalVolumeResourceDataProperty.DestinationPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-localvolumeresourcedata.html#cfn-greengrass-resourcedefinition-localvolumeresourcedata-destinationpath
         * @external
         */
        readonly destinationPath: string;
        /**
         * `CfnResourceDefinition.LocalVolumeResourceDataProperty.GroupOwnerSetting`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-localvolumeresourcedata.html#cfn-greengrass-resourcedefinition-localvolumeresourcedata-groupownersetting
         * @external
         */
        readonly groupOwnerSetting?: CfnResourceDefinition.GroupOwnerSettingProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinition.LocalVolumeResourceDataProperty.SourcePath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-localvolumeresourcedata.html#cfn-greengrass-resourcedefinition-localvolumeresourcedata-sourcepath
         * @external
         */
        readonly sourcePath: string;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::ResourceDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::ResourceDefinition
 */
export declare namespace CfnResourceDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourcedatacontainer.html
     * @external
     */
    interface ResourceDataContainerProperty {
        /**
         * `CfnResourceDefinition.ResourceDataContainerProperty.LocalDeviceResourceData`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourcedatacontainer.html#cfn-greengrass-resourcedefinition-resourcedatacontainer-localdeviceresourcedata
         * @external
         */
        readonly localDeviceResourceData?: CfnResourceDefinition.LocalDeviceResourceDataProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinition.ResourceDataContainerProperty.LocalVolumeResourceData`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourcedatacontainer.html#cfn-greengrass-resourcedefinition-resourcedatacontainer-localvolumeresourcedata
         * @external
         */
        readonly localVolumeResourceData?: CfnResourceDefinition.LocalVolumeResourceDataProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinition.ResourceDataContainerProperty.S3MachineLearningModelResourceData`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourcedatacontainer.html#cfn-greengrass-resourcedefinition-resourcedatacontainer-s3machinelearningmodelresourcedata
         * @external
         */
        readonly s3MachineLearningModelResourceData?: CfnResourceDefinition.S3MachineLearningModelResourceDataProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinition.ResourceDataContainerProperty.SageMakerMachineLearningModelResourceData`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourcedatacontainer.html#cfn-greengrass-resourcedefinition-resourcedatacontainer-sagemakermachinelearningmodelresourcedata
         * @external
         */
        readonly sageMakerMachineLearningModelResourceData?: CfnResourceDefinition.SageMakerMachineLearningModelResourceDataProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinition.ResourceDataContainerProperty.SecretsManagerSecretResourceData`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourcedatacontainer.html#cfn-greengrass-resourcedefinition-resourcedatacontainer-secretsmanagersecretresourcedata
         * @external
         */
        readonly secretsManagerSecretResourceData?: CfnResourceDefinition.SecretsManagerSecretResourceDataProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::ResourceDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::ResourceDefinition
 */
export declare namespace CfnResourceDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourcedefinitionversion.html
     * @external
     */
    interface ResourceDefinitionVersionProperty {
        /**
         * `CfnResourceDefinition.ResourceDefinitionVersionProperty.Resources`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourcedefinitionversion.html#cfn-greengrass-resourcedefinition-resourcedefinitionversion-resources
         * @external
         */
        readonly resources: Array<CfnResourceDefinition.ResourceInstanceProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::ResourceDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::ResourceDefinition
 */
export declare namespace CfnResourceDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourcedownloadownersetting.html
     * @external
     */
    interface ResourceDownloadOwnerSettingProperty {
        /**
         * `CfnResourceDefinition.ResourceDownloadOwnerSettingProperty.GroupOwner`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourcedownloadownersetting.html#cfn-greengrass-resourcedefinition-resourcedownloadownersetting-groupowner
         * @external
         */
        readonly groupOwner: string;
        /**
         * `CfnResourceDefinition.ResourceDownloadOwnerSettingProperty.GroupPermission`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourcedownloadownersetting.html#cfn-greengrass-resourcedefinition-resourcedownloadownersetting-grouppermission
         * @external
         */
        readonly groupPermission: string;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::ResourceDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::ResourceDefinition
 */
export declare namespace CfnResourceDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourceinstance.html
     * @external
     */
    interface ResourceInstanceProperty {
        /**
         * `CfnResourceDefinition.ResourceInstanceProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourceinstance.html#cfn-greengrass-resourcedefinition-resourceinstance-id
         * @external
         */
        readonly id: string;
        /**
         * `CfnResourceDefinition.ResourceInstanceProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourceinstance.html#cfn-greengrass-resourcedefinition-resourceinstance-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnResourceDefinition.ResourceInstanceProperty.ResourceDataContainer`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourceinstance.html#cfn-greengrass-resourcedefinition-resourceinstance-resourcedatacontainer
         * @external
         */
        readonly resourceDataContainer: CfnResourceDefinition.ResourceDataContainerProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::ResourceDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::ResourceDefinition
 */
export declare namespace CfnResourceDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-s3machinelearningmodelresourcedata.html
     * @external
     */
    interface S3MachineLearningModelResourceDataProperty {
        /**
         * `CfnResourceDefinition.S3MachineLearningModelResourceDataProperty.DestinationPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-s3machinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinition-s3machinelearningmodelresourcedata-destinationpath
         * @external
         */
        readonly destinationPath: string;
        /**
         * `CfnResourceDefinition.S3MachineLearningModelResourceDataProperty.OwnerSetting`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-s3machinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinition-s3machinelearningmodelresourcedata-ownersetting
         * @external
         */
        readonly ownerSetting?: CfnResourceDefinition.ResourceDownloadOwnerSettingProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinition.S3MachineLearningModelResourceDataProperty.S3Uri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-s3machinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinition-s3machinelearningmodelresourcedata-s3uri
         * @external
         */
        readonly s3Uri: string;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::ResourceDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::ResourceDefinition
 */
export declare namespace CfnResourceDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-sagemakermachinelearningmodelresourcedata.html
     * @external
     */
    interface SageMakerMachineLearningModelResourceDataProperty {
        /**
         * `CfnResourceDefinition.SageMakerMachineLearningModelResourceDataProperty.DestinationPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-sagemakermachinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinition-sagemakermachinelearningmodelresourcedata-destinationpath
         * @external
         */
        readonly destinationPath: string;
        /**
         * `CfnResourceDefinition.SageMakerMachineLearningModelResourceDataProperty.OwnerSetting`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-sagemakermachinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinition-sagemakermachinelearningmodelresourcedata-ownersetting
         * @external
         */
        readonly ownerSetting?: CfnResourceDefinition.ResourceDownloadOwnerSettingProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinition.SageMakerMachineLearningModelResourceDataProperty.SageMakerJobArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-sagemakermachinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinition-sagemakermachinelearningmodelresourcedata-sagemakerjobarn
         * @external
         */
        readonly sageMakerJobArn: string;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::ResourceDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::ResourceDefinition
 */
export declare namespace CfnResourceDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-secretsmanagersecretresourcedata.html
     * @external
     */
    interface SecretsManagerSecretResourceDataProperty {
        /**
         * `CfnResourceDefinition.SecretsManagerSecretResourceDataProperty.ARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-secretsmanagersecretresourcedata.html#cfn-greengrass-resourcedefinition-secretsmanagersecretresourcedata-arn
         * @external
         */
        readonly arn: string;
        /**
         * `CfnResourceDefinition.SecretsManagerSecretResourceDataProperty.AdditionalStagingLabelsToDownload`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-secretsmanagersecretresourcedata.html#cfn-greengrass-resourcedefinition-secretsmanagersecretresourcedata-additionalstaginglabelstodownload
         * @external
         */
        readonly additionalStagingLabelsToDownload?: string[];
    }
}
/**
 * Properties for defining a `AWS::Greengrass::ResourceDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html
 * @external
 */
export interface CfnResourceDefinitionVersionProps {
    /**
     * `AWS::Greengrass::ResourceDefinitionVersion.ResourceDefinitionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html#cfn-greengrass-resourcedefinitionversion-resourcedefinitionid
     * @external
     */
    readonly resourceDefinitionId: string;
    /**
     * `AWS::Greengrass::ResourceDefinitionVersion.Resources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html#cfn-greengrass-resourcedefinitionversion-resources
     * @external
     */
    readonly resources: Array<CfnResourceDefinitionVersion.ResourceInstanceProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Greengrass::ResourceDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::ResourceDefinitionVersion
 */
export declare class CfnResourceDefinitionVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::ResourceDefinitionVersion";
    /**
     * `AWS::Greengrass::ResourceDefinitionVersion.ResourceDefinitionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html#cfn-greengrass-resourcedefinitionversion-resourcedefinitionid
     * @external
     */
    resourceDefinitionId: string;
    /**
     * `AWS::Greengrass::ResourceDefinitionVersion.Resources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html#cfn-greengrass-resourcedefinitionversion-resources
     * @external
     */
    resources: Array<CfnResourceDefinitionVersion.ResourceInstanceProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * Create a new `AWS::Greengrass::ResourceDefinitionVersion`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnResourceDefinitionVersionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Greengrass::ResourceDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::ResourceDefinitionVersion
 */
export declare namespace CfnResourceDefinitionVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-groupownersetting.html
     * @external
     */
    interface GroupOwnerSettingProperty {
        /**
         * `CfnResourceDefinitionVersion.GroupOwnerSettingProperty.AutoAddGroupOwner`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-groupownersetting.html#cfn-greengrass-resourcedefinitionversion-groupownersetting-autoaddgroupowner
         * @external
         */
        readonly autoAddGroupOwner: boolean | cdk.IResolvable;
        /**
         * `CfnResourceDefinitionVersion.GroupOwnerSettingProperty.GroupOwner`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-groupownersetting.html#cfn-greengrass-resourcedefinitionversion-groupownersetting-groupowner
         * @external
         */
        readonly groupOwner?: string;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::ResourceDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::ResourceDefinitionVersion
 */
export declare namespace CfnResourceDefinitionVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localdeviceresourcedata.html
     * @external
     */
    interface LocalDeviceResourceDataProperty {
        /**
         * `CfnResourceDefinitionVersion.LocalDeviceResourceDataProperty.GroupOwnerSetting`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localdeviceresourcedata.html#cfn-greengrass-resourcedefinitionversion-localdeviceresourcedata-groupownersetting
         * @external
         */
        readonly groupOwnerSetting?: CfnResourceDefinitionVersion.GroupOwnerSettingProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinitionVersion.LocalDeviceResourceDataProperty.SourcePath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localdeviceresourcedata.html#cfn-greengrass-resourcedefinitionversion-localdeviceresourcedata-sourcepath
         * @external
         */
        readonly sourcePath: string;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::ResourceDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::ResourceDefinitionVersion
 */
export declare namespace CfnResourceDefinitionVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localvolumeresourcedata.html
     * @external
     */
    interface LocalVolumeResourceDataProperty {
        /**
         * `CfnResourceDefinitionVersion.LocalVolumeResourceDataProperty.DestinationPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localvolumeresourcedata.html#cfn-greengrass-resourcedefinitionversion-localvolumeresourcedata-destinationpath
         * @external
         */
        readonly destinationPath: string;
        /**
         * `CfnResourceDefinitionVersion.LocalVolumeResourceDataProperty.GroupOwnerSetting`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localvolumeresourcedata.html#cfn-greengrass-resourcedefinitionversion-localvolumeresourcedata-groupownersetting
         * @external
         */
        readonly groupOwnerSetting?: CfnResourceDefinitionVersion.GroupOwnerSettingProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinitionVersion.LocalVolumeResourceDataProperty.SourcePath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localvolumeresourcedata.html#cfn-greengrass-resourcedefinitionversion-localvolumeresourcedata-sourcepath
         * @external
         */
        readonly sourcePath: string;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::ResourceDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::ResourceDefinitionVersion
 */
export declare namespace CfnResourceDefinitionVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html
     * @external
     */
    interface ResourceDataContainerProperty {
        /**
         * `CfnResourceDefinitionVersion.ResourceDataContainerProperty.LocalDeviceResourceData`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html#cfn-greengrass-resourcedefinitionversion-resourcedatacontainer-localdeviceresourcedata
         * @external
         */
        readonly localDeviceResourceData?: CfnResourceDefinitionVersion.LocalDeviceResourceDataProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinitionVersion.ResourceDataContainerProperty.LocalVolumeResourceData`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html#cfn-greengrass-resourcedefinitionversion-resourcedatacontainer-localvolumeresourcedata
         * @external
         */
        readonly localVolumeResourceData?: CfnResourceDefinitionVersion.LocalVolumeResourceDataProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinitionVersion.ResourceDataContainerProperty.S3MachineLearningModelResourceData`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html#cfn-greengrass-resourcedefinitionversion-resourcedatacontainer-s3machinelearningmodelresourcedata
         * @external
         */
        readonly s3MachineLearningModelResourceData?: CfnResourceDefinitionVersion.S3MachineLearningModelResourceDataProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinitionVersion.ResourceDataContainerProperty.SageMakerMachineLearningModelResourceData`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html#cfn-greengrass-resourcedefinitionversion-resourcedatacontainer-sagemakermachinelearningmodelresourcedata
         * @external
         */
        readonly sageMakerMachineLearningModelResourceData?: CfnResourceDefinitionVersion.SageMakerMachineLearningModelResourceDataProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinitionVersion.ResourceDataContainerProperty.SecretsManagerSecretResourceData`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html#cfn-greengrass-resourcedefinitionversion-resourcedatacontainer-secretsmanagersecretresourcedata
         * @external
         */
        readonly secretsManagerSecretResourceData?: CfnResourceDefinitionVersion.SecretsManagerSecretResourceDataProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::ResourceDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::ResourceDefinitionVersion
 */
export declare namespace CfnResourceDefinitionVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedownloadownersetting.html
     * @external
     */
    interface ResourceDownloadOwnerSettingProperty {
        /**
         * `CfnResourceDefinitionVersion.ResourceDownloadOwnerSettingProperty.GroupOwner`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedownloadownersetting.html#cfn-greengrass-resourcedefinitionversion-resourcedownloadownersetting-groupowner
         * @external
         */
        readonly groupOwner: string;
        /**
         * `CfnResourceDefinitionVersion.ResourceDownloadOwnerSettingProperty.GroupPermission`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedownloadownersetting.html#cfn-greengrass-resourcedefinitionversion-resourcedownloadownersetting-grouppermission
         * @external
         */
        readonly groupPermission: string;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::ResourceDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::ResourceDefinitionVersion
 */
export declare namespace CfnResourceDefinitionVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourceinstance.html
     * @external
     */
    interface ResourceInstanceProperty {
        /**
         * `CfnResourceDefinitionVersion.ResourceInstanceProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourceinstance.html#cfn-greengrass-resourcedefinitionversion-resourceinstance-id
         * @external
         */
        readonly id: string;
        /**
         * `CfnResourceDefinitionVersion.ResourceInstanceProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourceinstance.html#cfn-greengrass-resourcedefinitionversion-resourceinstance-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnResourceDefinitionVersion.ResourceInstanceProperty.ResourceDataContainer`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourceinstance.html#cfn-greengrass-resourcedefinitionversion-resourceinstance-resourcedatacontainer
         * @external
         */
        readonly resourceDataContainer: CfnResourceDefinitionVersion.ResourceDataContainerProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::ResourceDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::ResourceDefinitionVersion
 */
export declare namespace CfnResourceDefinitionVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata.html
     * @external
     */
    interface S3MachineLearningModelResourceDataProperty {
        /**
         * `CfnResourceDefinitionVersion.S3MachineLearningModelResourceDataProperty.DestinationPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata-destinationpath
         * @external
         */
        readonly destinationPath: string;
        /**
         * `CfnResourceDefinitionVersion.S3MachineLearningModelResourceDataProperty.OwnerSetting`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata-ownersetting
         * @external
         */
        readonly ownerSetting?: CfnResourceDefinitionVersion.ResourceDownloadOwnerSettingProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinitionVersion.S3MachineLearningModelResourceDataProperty.S3Uri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata-s3uri
         * @external
         */
        readonly s3Uri: string;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::ResourceDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::ResourceDefinitionVersion
 */
export declare namespace CfnResourceDefinitionVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata.html
     * @external
     */
    interface SageMakerMachineLearningModelResourceDataProperty {
        /**
         * `CfnResourceDefinitionVersion.SageMakerMachineLearningModelResourceDataProperty.DestinationPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata-destinationpath
         * @external
         */
        readonly destinationPath: string;
        /**
         * `CfnResourceDefinitionVersion.SageMakerMachineLearningModelResourceDataProperty.OwnerSetting`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata-ownersetting
         * @external
         */
        readonly ownerSetting?: CfnResourceDefinitionVersion.ResourceDownloadOwnerSettingProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinitionVersion.SageMakerMachineLearningModelResourceDataProperty.SageMakerJobArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata-sagemakerjobarn
         * @external
         */
        readonly sageMakerJobArn: string;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::ResourceDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::ResourceDefinitionVersion
 */
export declare namespace CfnResourceDefinitionVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-secretsmanagersecretresourcedata.html
     * @external
     */
    interface SecretsManagerSecretResourceDataProperty {
        /**
         * `CfnResourceDefinitionVersion.SecretsManagerSecretResourceDataProperty.ARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-secretsmanagersecretresourcedata.html#cfn-greengrass-resourcedefinitionversion-secretsmanagersecretresourcedata-arn
         * @external
         */
        readonly arn: string;
        /**
         * `CfnResourceDefinitionVersion.SecretsManagerSecretResourceDataProperty.AdditionalStagingLabelsToDownload`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-secretsmanagersecretresourcedata.html#cfn-greengrass-resourcedefinitionversion-secretsmanagersecretresourcedata-additionalstaginglabelstodownload
         * @external
         */
        readonly additionalStagingLabelsToDownload?: string[];
    }
}
/**
 * Properties for defining a `AWS::Greengrass::SubscriptionDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinition.html
 * @external
 */
export interface CfnSubscriptionDefinitionProps {
    /**
     * `AWS::Greengrass::SubscriptionDefinition.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinition.html#cfn-greengrass-subscriptiondefinition-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::Greengrass::SubscriptionDefinition.InitialVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinition.html#cfn-greengrass-subscriptiondefinition-initialversion
     * @external
     */
    readonly initialVersion?: CfnSubscriptionDefinition.SubscriptionDefinitionVersionProperty | cdk.IResolvable;
    /**
     * `AWS::Greengrass::SubscriptionDefinition.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinition.html#cfn-greengrass-subscriptiondefinition-tags
     * @external
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Greengrass::SubscriptionDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::SubscriptionDefinition
 */
export declare class CfnSubscriptionDefinition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::SubscriptionDefinition";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @external
     * @cloudformationAttribute LatestVersionArn
     */
    readonly attrLatestVersionArn: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::Greengrass::SubscriptionDefinition.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinition.html#cfn-greengrass-subscriptiondefinition-name
     * @external
     */
    name: string;
    /**
     * `AWS::Greengrass::SubscriptionDefinition.InitialVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinition.html#cfn-greengrass-subscriptiondefinition-initialversion
     * @external
     */
    initialVersion: CfnSubscriptionDefinition.SubscriptionDefinitionVersionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Greengrass::SubscriptionDefinition.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinition.html#cfn-greengrass-subscriptiondefinition-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Greengrass::SubscriptionDefinition`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSubscriptionDefinitionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Greengrass::SubscriptionDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::SubscriptionDefinition
 */
export declare namespace CfnSubscriptionDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-subscriptiondefinition-subscription.html
     * @external
     */
    interface SubscriptionProperty {
        /**
         * `CfnSubscriptionDefinition.SubscriptionProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-subscriptiondefinition-subscription.html#cfn-greengrass-subscriptiondefinition-subscription-id
         * @external
         */
        readonly id: string;
        /**
         * `CfnSubscriptionDefinition.SubscriptionProperty.Source`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-subscriptiondefinition-subscription.html#cfn-greengrass-subscriptiondefinition-subscription-source
         * @external
         */
        readonly source: string;
        /**
         * `CfnSubscriptionDefinition.SubscriptionProperty.Subject`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-subscriptiondefinition-subscription.html#cfn-greengrass-subscriptiondefinition-subscription-subject
         * @external
         */
        readonly subject: string;
        /**
         * `CfnSubscriptionDefinition.SubscriptionProperty.Target`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-subscriptiondefinition-subscription.html#cfn-greengrass-subscriptiondefinition-subscription-target
         * @external
         */
        readonly target: string;
    }
}
/**
 * A CloudFormation `AWS::Greengrass::SubscriptionDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinition.html
 * @external
 * @cloudformationResource AWS::Greengrass::SubscriptionDefinition
 */
export declare namespace CfnSubscriptionDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-subscriptiondefinition-subscriptiondefinitionversion.html
     * @external
     */
    interface SubscriptionDefinitionVersionProperty {
        /**
         * `CfnSubscriptionDefinition.SubscriptionDefinitionVersionProperty.Subscriptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-subscriptiondefinition-subscriptiondefinitionversion.html#cfn-greengrass-subscriptiondefinition-subscriptiondefinitionversion-subscriptions
         * @external
         */
        readonly subscriptions: Array<CfnSubscriptionDefinition.SubscriptionProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::Greengrass::SubscriptionDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinitionversion.html
 * @external
 */
export interface CfnSubscriptionDefinitionVersionProps {
    /**
     * `AWS::Greengrass::SubscriptionDefinitionVersion.SubscriptionDefinitionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinitionversion.html#cfn-greengrass-subscriptiondefinitionversion-subscriptiondefinitionid
     * @external
     */
    readonly subscriptionDefinitionId: string;
    /**
     * `AWS::Greengrass::SubscriptionDefinitionVersion.Subscriptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinitionversion.html#cfn-greengrass-subscriptiondefinitionversion-subscriptions
     * @external
     */
    readonly subscriptions: Array<CfnSubscriptionDefinitionVersion.SubscriptionProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Greengrass::SubscriptionDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::SubscriptionDefinitionVersion
 */
export declare class CfnSubscriptionDefinitionVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::SubscriptionDefinitionVersion";
    /**
     * `AWS::Greengrass::SubscriptionDefinitionVersion.SubscriptionDefinitionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinitionversion.html#cfn-greengrass-subscriptiondefinitionversion-subscriptiondefinitionid
     * @external
     */
    subscriptionDefinitionId: string;
    /**
     * `AWS::Greengrass::SubscriptionDefinitionVersion.Subscriptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinitionversion.html#cfn-greengrass-subscriptiondefinitionversion-subscriptions
     * @external
     */
    subscriptions: Array<CfnSubscriptionDefinitionVersion.SubscriptionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * Create a new `AWS::Greengrass::SubscriptionDefinitionVersion`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSubscriptionDefinitionVersionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Greengrass::SubscriptionDefinitionVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinitionversion.html
 * @external
 * @cloudformationResource AWS::Greengrass::SubscriptionDefinitionVersion
 */
export declare namespace CfnSubscriptionDefinitionVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-subscriptiondefinitionversion-subscription.html
     * @external
     */
    interface SubscriptionProperty {
        /**
         * `CfnSubscriptionDefinitionVersion.SubscriptionProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-subscriptiondefinitionversion-subscription.html#cfn-greengrass-subscriptiondefinitionversion-subscription-id
         * @external
         */
        readonly id: string;
        /**
         * `CfnSubscriptionDefinitionVersion.SubscriptionProperty.Source`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-subscriptiondefinitionversion-subscription.html#cfn-greengrass-subscriptiondefinitionversion-subscription-source
         * @external
         */
        readonly source: string;
        /**
         * `CfnSubscriptionDefinitionVersion.SubscriptionProperty.Subject`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-subscriptiondefinitionversion-subscription.html#cfn-greengrass-subscriptiondefinitionversion-subscription-subject
         * @external
         */
        readonly subject: string;
        /**
         * `CfnSubscriptionDefinitionVersion.SubscriptionProperty.Target`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-subscriptiondefinitionversion-subscription.html#cfn-greengrass-subscriptiondefinitionversion-subscription-target
         * @external
         */
        readonly target: string;
    }
}
