import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::GlobalAccelerator::Accelerator`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-accelerator.html
 * @external
 */
export interface CfnAcceleratorProps {
    /**
     * `AWS::GlobalAccelerator::Accelerator.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-accelerator.html#cfn-globalaccelerator-accelerator-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::GlobalAccelerator::Accelerator.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-accelerator.html#cfn-globalaccelerator-accelerator-enabled
     * @external
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::GlobalAccelerator::Accelerator.IpAddresses`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-accelerator.html#cfn-globalaccelerator-accelerator-ipaddresses
     * @external
     */
    readonly ipAddresses?: string[];
    /**
     * `AWS::GlobalAccelerator::Accelerator.IpAddressType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-accelerator.html#cfn-globalaccelerator-accelerator-ipaddresstype
     * @external
     */
    readonly ipAddressType?: string;
    /**
     * `AWS::GlobalAccelerator::Accelerator.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-accelerator.html#cfn-globalaccelerator-accelerator-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::GlobalAccelerator::Accelerator`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-accelerator.html
 * @external
 * @cloudformationResource AWS::GlobalAccelerator::Accelerator
 */
export declare class CfnAccelerator extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::GlobalAccelerator::Accelerator";
    /**
     * @external
     * @cloudformationAttribute AcceleratorArn
     */
    readonly attrAcceleratorArn: string;
    /**
     * @external
     * @cloudformationAttribute DnsName
     */
    readonly attrDnsName: string;
    /**
     * `AWS::GlobalAccelerator::Accelerator.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-accelerator.html#cfn-globalaccelerator-accelerator-name
     * @external
     */
    name: string;
    /**
     * `AWS::GlobalAccelerator::Accelerator.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-accelerator.html#cfn-globalaccelerator-accelerator-enabled
     * @external
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::GlobalAccelerator::Accelerator.IpAddresses`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-accelerator.html#cfn-globalaccelerator-accelerator-ipaddresses
     * @external
     */
    ipAddresses: string[] | undefined;
    /**
     * `AWS::GlobalAccelerator::Accelerator.IpAddressType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-accelerator.html#cfn-globalaccelerator-accelerator-ipaddresstype
     * @external
     */
    ipAddressType: string | undefined;
    /**
     * `AWS::GlobalAccelerator::Accelerator.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-accelerator.html#cfn-globalaccelerator-accelerator-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::GlobalAccelerator::Accelerator`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAcceleratorProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::GlobalAccelerator::EndpointGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-endpointgroup.html
 * @external
 */
export interface CfnEndpointGroupProps {
    /**
     * `AWS::GlobalAccelerator::EndpointGroup.EndpointGroupRegion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-endpointgroup.html#cfn-globalaccelerator-endpointgroup-endpointgroupregion
     * @external
     */
    readonly endpointGroupRegion: string;
    /**
     * `AWS::GlobalAccelerator::EndpointGroup.ListenerArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-endpointgroup.html#cfn-globalaccelerator-endpointgroup-listenerarn
     * @external
     */
    readonly listenerArn: string;
    /**
     * `AWS::GlobalAccelerator::EndpointGroup.EndpointConfigurations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-endpointgroup.html#cfn-globalaccelerator-endpointgroup-endpointconfigurations
     * @external
     */
    readonly endpointConfigurations?: Array<CfnEndpointGroup.EndpointConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::GlobalAccelerator::EndpointGroup.HealthCheckIntervalSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-endpointgroup.html#cfn-globalaccelerator-endpointgroup-healthcheckintervalseconds
     * @external
     */
    readonly healthCheckIntervalSeconds?: number;
    /**
     * `AWS::GlobalAccelerator::EndpointGroup.HealthCheckPath`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-endpointgroup.html#cfn-globalaccelerator-endpointgroup-healthcheckpath
     * @external
     */
    readonly healthCheckPath?: string;
    /**
     * `AWS::GlobalAccelerator::EndpointGroup.HealthCheckPort`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-endpointgroup.html#cfn-globalaccelerator-endpointgroup-healthcheckport
     * @external
     */
    readonly healthCheckPort?: number;
    /**
     * `AWS::GlobalAccelerator::EndpointGroup.HealthCheckProtocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-endpointgroup.html#cfn-globalaccelerator-endpointgroup-healthcheckprotocol
     * @external
     */
    readonly healthCheckProtocol?: string;
    /**
     * `AWS::GlobalAccelerator::EndpointGroup.ThresholdCount`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-endpointgroup.html#cfn-globalaccelerator-endpointgroup-thresholdcount
     * @external
     */
    readonly thresholdCount?: number;
    /**
     * `AWS::GlobalAccelerator::EndpointGroup.TrafficDialPercentage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-endpointgroup.html#cfn-globalaccelerator-endpointgroup-trafficdialpercentage
     * @external
     */
    readonly trafficDialPercentage?: number;
}
/**
 * A CloudFormation `AWS::GlobalAccelerator::EndpointGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-endpointgroup.html
 * @external
 * @cloudformationResource AWS::GlobalAccelerator::EndpointGroup
 */
export declare class CfnEndpointGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::GlobalAccelerator::EndpointGroup";
    /**
     * @external
     * @cloudformationAttribute EndpointGroupArn
     */
    readonly attrEndpointGroupArn: string;
    /**
     * `AWS::GlobalAccelerator::EndpointGroup.EndpointGroupRegion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-endpointgroup.html#cfn-globalaccelerator-endpointgroup-endpointgroupregion
     * @external
     */
    endpointGroupRegion: string;
    /**
     * `AWS::GlobalAccelerator::EndpointGroup.ListenerArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-endpointgroup.html#cfn-globalaccelerator-endpointgroup-listenerarn
     * @external
     */
    listenerArn: string;
    /**
     * `AWS::GlobalAccelerator::EndpointGroup.EndpointConfigurations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-endpointgroup.html#cfn-globalaccelerator-endpointgroup-endpointconfigurations
     * @external
     */
    endpointConfigurations: Array<CfnEndpointGroup.EndpointConfigurationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::GlobalAccelerator::EndpointGroup.HealthCheckIntervalSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-endpointgroup.html#cfn-globalaccelerator-endpointgroup-healthcheckintervalseconds
     * @external
     */
    healthCheckIntervalSeconds: number | undefined;
    /**
     * `AWS::GlobalAccelerator::EndpointGroup.HealthCheckPath`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-endpointgroup.html#cfn-globalaccelerator-endpointgroup-healthcheckpath
     * @external
     */
    healthCheckPath: string | undefined;
    /**
     * `AWS::GlobalAccelerator::EndpointGroup.HealthCheckPort`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-endpointgroup.html#cfn-globalaccelerator-endpointgroup-healthcheckport
     * @external
     */
    healthCheckPort: number | undefined;
    /**
     * `AWS::GlobalAccelerator::EndpointGroup.HealthCheckProtocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-endpointgroup.html#cfn-globalaccelerator-endpointgroup-healthcheckprotocol
     * @external
     */
    healthCheckProtocol: string | undefined;
    /**
     * `AWS::GlobalAccelerator::EndpointGroup.ThresholdCount`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-endpointgroup.html#cfn-globalaccelerator-endpointgroup-thresholdcount
     * @external
     */
    thresholdCount: number | undefined;
    /**
     * `AWS::GlobalAccelerator::EndpointGroup.TrafficDialPercentage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-endpointgroup.html#cfn-globalaccelerator-endpointgroup-trafficdialpercentage
     * @external
     */
    trafficDialPercentage: number | undefined;
    /**
     * Create a new `AWS::GlobalAccelerator::EndpointGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEndpointGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::GlobalAccelerator::EndpointGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-endpointgroup.html
 * @external
 * @cloudformationResource AWS::GlobalAccelerator::EndpointGroup
 */
export declare namespace CfnEndpointGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-globalaccelerator-endpointgroup-endpointconfiguration.html
     * @external
     */
    interface EndpointConfigurationProperty {
        /**
         * `CfnEndpointGroup.EndpointConfigurationProperty.ClientIPPreservationEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-globalaccelerator-endpointgroup-endpointconfiguration.html#cfn-globalaccelerator-endpointgroup-endpointconfiguration-clientippreservationenabled
         * @external
         */
        readonly clientIpPreservationEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnEndpointGroup.EndpointConfigurationProperty.EndpointId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-globalaccelerator-endpointgroup-endpointconfiguration.html#cfn-globalaccelerator-endpointgroup-endpointconfiguration-endpointid
         * @external
         */
        readonly endpointId: string;
        /**
         * `CfnEndpointGroup.EndpointConfigurationProperty.Weight`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-globalaccelerator-endpointgroup-endpointconfiguration.html#cfn-globalaccelerator-endpointgroup-endpointconfiguration-weight
         * @external
         */
        readonly weight?: number;
    }
}
/**
 * Properties for defining a `AWS::GlobalAccelerator::Listener`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-listener.html
 * @external
 */
export interface CfnListenerProps {
    /**
     * `AWS::GlobalAccelerator::Listener.AcceleratorArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-listener.html#cfn-globalaccelerator-listener-acceleratorarn
     * @external
     */
    readonly acceleratorArn: string;
    /**
     * `AWS::GlobalAccelerator::Listener.PortRanges`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-listener.html#cfn-globalaccelerator-listener-portranges
     * @external
     */
    readonly portRanges: Array<CfnListener.PortRangeProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::GlobalAccelerator::Listener.Protocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-listener.html#cfn-globalaccelerator-listener-protocol
     * @external
     */
    readonly protocol: string;
    /**
     * `AWS::GlobalAccelerator::Listener.ClientAffinity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-listener.html#cfn-globalaccelerator-listener-clientaffinity
     * @external
     */
    readonly clientAffinity?: string;
}
/**
 * A CloudFormation `AWS::GlobalAccelerator::Listener`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-listener.html
 * @external
 * @cloudformationResource AWS::GlobalAccelerator::Listener
 */
export declare class CfnListener extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::GlobalAccelerator::Listener";
    /**
     * @external
     * @cloudformationAttribute ListenerArn
     */
    readonly attrListenerArn: string;
    /**
     * `AWS::GlobalAccelerator::Listener.AcceleratorArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-listener.html#cfn-globalaccelerator-listener-acceleratorarn
     * @external
     */
    acceleratorArn: string;
    /**
     * `AWS::GlobalAccelerator::Listener.PortRanges`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-listener.html#cfn-globalaccelerator-listener-portranges
     * @external
     */
    portRanges: Array<CfnListener.PortRangeProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::GlobalAccelerator::Listener.Protocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-listener.html#cfn-globalaccelerator-listener-protocol
     * @external
     */
    protocol: string;
    /**
     * `AWS::GlobalAccelerator::Listener.ClientAffinity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-listener.html#cfn-globalaccelerator-listener-clientaffinity
     * @external
     */
    clientAffinity: string | undefined;
    /**
     * Create a new `AWS::GlobalAccelerator::Listener`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnListenerProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::GlobalAccelerator::Listener`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-globalaccelerator-listener.html
 * @external
 * @cloudformationResource AWS::GlobalAccelerator::Listener
 */
export declare namespace CfnListener {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-globalaccelerator-listener-portrange.html
     * @external
     */
    interface PortRangeProperty {
        /**
         * `CfnListener.PortRangeProperty.FromPort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-globalaccelerator-listener-portrange.html#cfn-globalaccelerator-listener-portrange-fromport
         * @external
         */
        readonly fromPort: number;
        /**
         * `CfnListener.PortRangeProperty.ToPort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-globalaccelerator-listener-portrange.html#cfn-globalaccelerator-listener-portrange-toport
         * @external
         */
        readonly toPort: number;
    }
}
