import * as cdk from "../../core";
import { Construct } from 'constructs';
/**
 * (experimental) The interface of the Accelerator.
 *
 * @experimental
 */
export interface IAccelerator extends cdk.IResource {
    /**
     * (experimental) The ARN of the accelerator.
     *
     * @experimental
     * @attribute true
     */
    readonly acceleratorArn: string;
    /**
     * (experimental) The Domain Name System (DNS) name that Global Accelerator creates that points to your accelerator's static IP addresses.
     *
     * @experimental
     * @attribute true
     */
    readonly dnsName: string;
}
/**
 * (experimental) Construct properties of the Accelerator.
 *
 * @experimental
 */
export interface AcceleratorProps {
    /**
     * (experimental) The name of the accelerator.
     *
     * @default - resource ID
     * @experimental
     */
    readonly acceleratorName?: string;
    /**
     * (experimental) Indicates whether the accelerator is enabled.
     *
     * @default true
     * @experimental
     */
    readonly enabled?: boolean;
}
/**
 * (experimental) Attributes required to import an existing accelerator to the stack.
 *
 * @experimental
 */
export interface AcceleratorAttributes {
    /**
     * (experimental) The ARN of the accelerator.
     *
     * @experimental
     */
    readonly acceleratorArn: string;
    /**
     * (experimental) The DNS name of the accelerator.
     *
     * @experimental
     */
    readonly dnsName: string;
}
/**
 * (experimental) The Accelerator construct.
 *
 * @experimental
 */
export declare class Accelerator extends cdk.Resource implements IAccelerator {
    /**
     * (experimental) import from attributes.
     *
     * @experimental
     */
    static fromAcceleratorAttributes(scope: Construct, id: string, attrs: AcceleratorAttributes): IAccelerator;
    /**
     * (experimental) The ARN of the accelerator.
     *
     * @experimental
     */
    readonly acceleratorArn: string;
    /**
     * (experimental) The Domain Name System (DNS) name that Global Accelerator creates that points to your accelerator's static IP addresses.
     *
     * @experimental
     */
    readonly dnsName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: AcceleratorProps);
}
