import { Connections, IConnectable, ISecurityGroup, IVpc } from "../../aws-ec2";
import { IKey } from "../../aws-kms";
import { Resource } from "../../core";
/**
 * (experimental) Interface to implement FSx File Systems.
 *
 * @experimental
 */
export interface IFileSystem extends IConnectable {
    /**
     * (experimental) The ID of the file system, assigned by Amazon FSx.
     *
     * @experimental
     * @attribute true
     */
    readonly fileSystemId: string;
}
/**
 * (experimental) Properties for the FSx file system.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 * @experimental
 */
export interface FileSystemProps {
    /**
     * (experimental) The VPC to launch the file system in.
     *
     * @experimental
     */
    readonly vpc: IVpc;
    /**
     * (experimental) The ID of the backup.
     *
     * Specifies the backup to use if you're creating a file system from an existing backup.
     *
     * @default - no backup will be used.
     * @experimental
     */
    readonly backupId?: string;
    /**
     * (experimental) The KMS key used for encryption to protect your data at rest.
     *
     * @default - the aws/fsx default KMS key for the AWS account being deployed into.
     * @experimental
     */
    readonly kmsKey?: IKey;
    /**
     * (experimental) Security Group to assign to this file system.
     *
     * @default - creates new security group which allows all outbound traffic.
     * @experimental
     */
    readonly securityGroup?: ISecurityGroup;
    /**
     * (experimental) The storage capacity of the file system being created.
     *
     * For Windows file systems, valid values are 32 GiB to 65,536 GiB.
     * For SCRATCH_1 deployment types, valid values are 1,200, 2,400, 3,600, then continuing in increments of 3,600 GiB.
     * For SCRATCH_2 and PERSISTENT_1 types, valid values are 1,200, 2,400, then continuing in increments of 2,400 GiB.
     *
     * @experimental
     */
    readonly storageCapacityGiB: number;
}
/**
 * (experimental) A new or imported FSx file system.
 *
 * @experimental
 */
export declare abstract class FileSystemBase extends Resource implements IFileSystem {
    /**
     * (experimental) The security groups/rules used to allow network connections to the file system.
     *
     * @experimental
     * @attribute true
     */
    abstract readonly connections: Connections;
    /**
     * (experimental) The DNS name assigned to this file system.
     *
     * @experimental
     * @attribute true
     */
    abstract readonly dnsName: string;
    /**
     * (experimental) The ID of the file system, assigned by Amazon FSx.
     *
     * @experimental
     * @attribute true
     */
    abstract readonly fileSystemId: string;
}
/**
 * (experimental) Properties that describe an existing FSx file system.
 *
 * @experimental
 */
export interface FileSystemAttributes {
    /**
     * (experimental) The DNS name assigned to this file system.
     *
     * @experimental
     */
    readonly dnsName: string;
    /**
     * (experimental) The ID of the file system, assigned by Amazon FSx.
     *
     * @experimental
     */
    readonly fileSystemId: string;
    /**
     * (experimental) The security group of the file system.
     *
     * @experimental
     */
    readonly securityGroup: ISecurityGroup;
}
