import { IResolvable, IResolveContext } from "../../core";
import { IRule } from './rule-ref';
/**
 * (experimental) The input to send to the event target.
 *
 * @experimental
 */
export declare abstract class RuleTargetInput {
    /**
     * (experimental) Pass text to the event target.
     *
     * May contain strings returned by EventField.from() to substitute in parts of the
     * matched event.
     *
     * @experimental
     */
    static fromText(text: string): RuleTargetInput;
    /**
     * (experimental) Pass text to the event target, splitting on newlines.
     *
     * This is only useful when passing to a target that does not
     * take a single argument.
     *
     * May contain strings returned by EventField.from() to substitute in parts
     * of the matched event.
     *
     * @experimental
     */
    static fromMultilineText(text: string): RuleTargetInput;
    /**
     * (experimental) Pass a JSON object to the event target.
     *
     * May contain strings returned by EventField.from() to substitute in parts of the
     * matched event.
     *
     * @experimental
     */
    static fromObject(obj: any): RuleTargetInput;
    /**
     * (experimental) Take the event target input from a path in the event JSON.
     *
     * @experimental
     */
    static fromEventPath(path: string): RuleTargetInput;
    /**
     * @experimental
     */
    protected constructor();
    /**
     * (experimental) Return the input properties for this input object.
     *
     * @experimental
     */
    abstract bind(rule: IRule): RuleTargetInputProperties;
}
/**
 * (experimental) The input properties for an event target.
 *
 * @experimental
 */
export interface RuleTargetInputProperties {
    /**
     * (experimental) Literal input to the target service (must be valid JSON).
     *
     * @default - input for the event target. If the input contains a paths map
     * values wil be extracted from event and inserted into the `inputTemplate`.
     * @experimental
     */
    readonly input?: string;
    /**
     * (experimental) JsonPath to take input from the input event.
     *
     * @default - None. The entire matched event is passed as input
     * @experimental
     */
    readonly inputPath?: string;
    /**
     * (experimental) Input template to insert paths map into.
     *
     * @default - None.
     * @experimental
     */
    readonly inputTemplate?: string;
    /**
     * (experimental) Paths map to extract values from event and insert into `inputTemplate`.
     *
     * @default - No values extracted from event.
     * @experimental
     */
    readonly inputPathsMap?: {
        [key: string]: string;
    };
}
/**
 * (experimental) Represents a field in the event pattern.
 *
 * @experimental
 */
export declare class EventField implements IResolvable {
    readonly path: string;
    /**
     * (experimental) Extract the event ID from the event.
     *
     * @experimental
     */
    static get eventId(): string;
    /**
     * (experimental) Extract the detail type from the event.
     *
     * @experimental
     */
    static get detailType(): string;
    /**
     * (experimental) Extract the source from the event.
     *
     * @experimental
     */
    static get source(): string;
    /**
     * (experimental) Extract the account from the event.
     *
     * @experimental
     */
    static get account(): string;
    /**
     * (experimental) Extract the time from the event.
     *
     * @experimental
     */
    static get time(): string;
    /**
     * (experimental) Extract the region from the event.
     *
     * @experimental
     */
    static get region(): string;
    /**
     * (experimental) Extract a custom JSON path from the event.
     *
     * @experimental
     */
    static fromPath(path: string): string;
    /**
     * (experimental) Human readable display hint about the event pattern.
     *
     * @experimental
     */
    readonly displayHint: string;
    /**
     * (experimental) The creation stack of this resolvable which will be appended to errors thrown during resolution.
     *
     * If this returns an empty array the stack will not be attached.
     *
     * @experimental
     */
    readonly creationStack: string[];
    /**
     *
     * @param path the path to a field in the event pattern
     */
    private constructor();
    /**
     * (experimental) Produce the Token's value at resolution time.
     *
     * @experimental
     */
    resolve(_ctx: IResolveContext): any;
    /**
     * (experimental) Return a string representation of this resolvable object.
     *
     * Returns a reversible string representation.
     *
     * @experimental
     */
    toString(): string;
    /**
     * (experimental) Convert the path to the field in the event pattern to JSON.
     *
     * @experimental
     */
    toJSON(): string;
}
