import * as iam from "../../aws-iam";
import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
/**
 * (experimental) Interface which all EventBus based classes MUST implement.
 *
 * @experimental
 */
export interface IEventBus extends IResource {
    /**
     * (experimental) The physical ID of this event bus resource.
     *
     * @experimental
     * @attribute true
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#cfn-events-eventbus-name
     */
    readonly eventBusName: string;
    /**
     * (experimental) The ARN of this event bus resource.
     *
     * @experimental
     * @attribute true
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#Arn-fn::getatt
     */
    readonly eventBusArn: string;
    /**
     * (experimental) The JSON policy of this event bus resource.
     *
     * @experimental
     * @attribute true
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#Policy-fn::getatt
     */
    readonly eventBusPolicy: string;
    /**
     * (experimental) The partner event source to associate with this event bus resource.
     *
     * @experimental
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#cfn-events-eventbus-eventsourcename
     */
    readonly eventSourceName?: string;
}
/**
 * (experimental) Properties to define an event bus.
 *
 * @experimental
 */
export interface EventBusProps {
    /**
     * (experimental) The name of the event bus you are creating Note: If 'eventSourceName' is passed in, you cannot set this.
     *
     * @default - automatically generated name
     * @experimental
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#cfn-events-eventbus-name
     */
    readonly eventBusName?: string;
    /**
     * (experimental) The partner event source to associate with this event bus resource Note: If 'eventBusName' is passed in, you cannot set this.
     *
     * @default - no partner event source
     * @experimental
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#cfn-events-eventbus-eventsourcename
     */
    readonly eventSourceName?: string;
}
/**
 * (experimental) Interface with properties necessary to import a reusable EventBus.
 *
 * @experimental
 */
export interface EventBusAttributes {
    /**
     * (experimental) The physical ID of this event bus resource.
     *
     * @experimental
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#cfn-events-eventbus-name
     */
    readonly eventBusName: string;
    /**
     * (experimental) The ARN of this event bus resource.
     *
     * @experimental
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#Arn-fn::getatt
     */
    readonly eventBusArn: string;
    /**
     * (experimental) The JSON policy of this event bus resource.
     *
     * @experimental
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#Policy-fn::getatt
     */
    readonly eventBusPolicy: string;
    /**
     * (experimental) The partner event source to associate with this event bus resource.
     *
     * @default - no partner event source
     * @experimental
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbus.html#cfn-events-eventbus-eventsourcename
     */
    readonly eventSourceName?: string;
}
/**
 * (experimental) Define an EventBridge EventBus.
 *
 * @experimental
 * @resource AWS::Events::EventBus
 */
export declare class EventBus extends Resource implements IEventBus {
    /**
     * (experimental) Import an existing event bus resource.
     *
     * @param scope Parent construct.
     * @param id Construct ID.
     * @param eventBusArn ARN of imported event bus.
     * @experimental
     */
    static fromEventBusArn(scope: Construct, id: string, eventBusArn: string): IEventBus;
    /**
     * (experimental) Import an existing event bus resource.
     *
     * @param scope Parent construct.
     * @param id Construct ID.
     * @param attrs Imported event bus properties.
     * @experimental
     */
    static fromEventBusAttributes(scope: Construct, id: string, attrs: EventBusAttributes): IEventBus;
    /**
     * (experimental) Permits an IAM Principal to send custom events to EventBridge so that they can be matched to rules.
     *
     * @param grantee The principal (no-op if undefined).
     * @experimental
     */
    static grantPutEvents(grantee: iam.IGrantable): iam.Grant;
    private static eventBusProps;
    /**
     * (experimental) The physical ID of this event bus resource.
     *
     * @experimental
     */
    readonly eventBusName: string;
    /**
     * (experimental) The ARN of the event bus, such as: arn:aws:events:us-east-2:123456789012:event-bus/aws.partner/PartnerName/acct1/repo1.
     *
     * @experimental
     */
    readonly eventBusArn: string;
    /**
     * (experimental) The policy for the event bus in JSON form.
     *
     * @experimental
     */
    readonly eventBusPolicy: string;
    /**
     * (experimental) The name of the partner event source.
     *
     * @experimental
     */
    readonly eventSourceName?: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: EventBusProps);
}
