import * as events from "../../aws-events";
import * as sns from "../../aws-sns";
/**
 * (experimental) Customize the SNS Topic Event Target.
 *
 * @experimental
 */
export interface SnsTopicProps {
    /**
     * (experimental) The message to send to the topic.
     *
     * @default the entire EventBridge event
     * @experimental
     */
    readonly message?: events.RuleTargetInput;
}
/**
 * (experimental) Use an SNS topic as a target for Amazon EventBridge rules.
 *
 * @experimental
 * @example
 *
 *    // publish to an SNS topic every time code is committed
 *    // to a CodeCommit repository
 *    repository.onCommit(new targets.SnsTopic(topic));
 */
export declare class SnsTopic implements events.IRuleTarget {
    readonly topic: sns.ITopic;
    private readonly props;
    /**
     * @experimental
     */
    constructor(topic: sns.ITopic, props?: SnsTopicProps);
    /**
     * (experimental) Returns a RuleTarget that can be used to trigger this SNS topic as a result from an EventBridge event.
     *
     * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/resource-based-policies-eventbridge.html#sns-permissions
     * @experimental
     */
    bind(_rule: events.IRule, _id?: string): events.RuleTargetConfig;
}
