import * as events from "../../aws-events";
import * as lambda from "../../aws-lambda";
/**
 * (experimental) Customize the Lambda Event Target.
 *
 * @experimental
 */
export interface LambdaFunctionProps {
    /**
     * (experimental) The event to send to the Lambda.
     *
     * This will be the payload sent to the Lambda Function.
     *
     * @default the entire EventBridge event
     * @experimental
     */
    readonly event?: events.RuleTargetInput;
}
/**
 * (experimental) Use an AWS Lambda function as an event rule target.
 *
 * @experimental
 */
export declare class LambdaFunction implements events.IRuleTarget {
    private readonly handler;
    private readonly props;
    /**
     * @experimental
     */
    constructor(handler: lambda.IFunction, props?: LambdaFunctionProps);
    /**
     * (experimental) Returns a RuleTarget that can be used to trigger this Lambda as a result from an EventBridge event.
     *
     * @experimental
     */
    bind(rule: events.IRule, _id?: string): events.RuleTargetConfig;
}
