import * as events from "../../aws-events";
import * as kinesis from "../../aws-kinesis";
/**
 * (experimental) Customize the Kinesis Stream Event Target.
 *
 * @experimental
 */
export interface KinesisStreamProps {
    /**
     * (experimental) Partition Key Path for records sent to this stream.
     *
     * @default - eventId as the partition key
     * @experimental
     */
    readonly partitionKeyPath?: string;
    /**
     * (experimental) The message to send to the stream.
     *
     * Must be a valid JSON text passed to the target stream.
     *
     * @default - the entire CloudWatch event
     * @experimental
     */
    readonly message?: events.RuleTargetInput;
}
/**
 * (experimental) Use a Kinesis Stream as a target for AWS CloudWatch event rules.
 *
 * @experimental
 * @example
 *
 *    // put to a Kinesis stream every time code is committed
 *    // to a CodeCommit repository
 *    repository.onCommit(new targets.KinesisStream(stream));
 */
export declare class KinesisStream implements events.IRuleTarget {
    private readonly stream;
    private readonly props;
    /**
     * @experimental
     */
    constructor(stream: kinesis.IStream, props?: KinesisStreamProps);
    /**
     * (experimental) Returns a RuleTarget that can be used to trigger this Kinesis Stream as a result from a CloudWatch event.
     *
     * @experimental
     */
    bind(_rule: events.IRule, _id?: string): events.RuleTargetConfig;
}
