import * as ec2 from "../../aws-ec2";
import * as ecs from "../../aws-ecs";
import * as events from "../../aws-events";
import * as iam from "../../aws-iam";
import { ContainerOverride } from './ecs-task-properties';
/**
 * (experimental) Properties to define an ECS Event Task.
 *
 * @experimental
 */
export interface EcsTaskProps {
    /**
     * (experimental) Cluster where service will be deployed.
     *
     * @experimental
     */
    readonly cluster: ecs.ICluster;
    /**
     * (experimental) Task Definition of the task that should be started.
     *
     * @experimental
     */
    readonly taskDefinition: ecs.TaskDefinition;
    /**
     * (experimental) How many tasks should be started when this event is triggered.
     *
     * @default 1
     * @experimental
     */
    readonly taskCount?: number;
    /**
     * (experimental) Container setting overrides.
     *
     * Key is the name of the container to override, value is the
     * values you want to override.
     *
     * @experimental
     */
    readonly containerOverrides?: ContainerOverride[];
    /**
     * (experimental) In what subnets to place the task's ENIs.
     *
     * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
     *
     * @default Private subnets
     * @experimental
     */
    readonly subnetSelection?: ec2.SubnetSelection;
    /**
     * (deprecated) Existing security group to use for the task's ENIs.
     *
     * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
     *
     * @default A new security group is created
     * @deprecated use securityGroups instead
     */
    readonly securityGroup?: ec2.ISecurityGroup;
    /**
     * (experimental) Existing security groups to use for the task's ENIs.
     *
     * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
     *
     * @default A new security group is created
     * @experimental
     */
    readonly securityGroups?: ec2.ISecurityGroup[];
    /**
     * (experimental) Existing IAM role to run the ECS task.
     *
     * @default A new IAM role is created
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) The platform version on which to run your task.
     *
     * Unless you have specific compatibility requirements, you don't need to specify this.
     *
     * @default - ECS will set the Fargate platform version to 'LATEST'
     * @see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html
     * @experimental
     */
    readonly platformVersion?: ecs.FargatePlatformVersion;
}
/**
 * (experimental) Start a task on an ECS cluster.
 *
 * @experimental
 */
export declare class EcsTask implements events.IRuleTarget {
    private readonly props;
    /**
     * (deprecated) The security group associated with the task.
     *
     * Only applicable with awsvpc network mode.
     *
     * @default - A new security group is created.
     * @deprecated use securityGroups instead.
     */
    readonly securityGroup?: ec2.ISecurityGroup;
    /**
     * (experimental) The security groups associated with the task.
     *
     * Only applicable with awsvpc network mode.
     *
     * @default - A new security group is created.
     * @experimental
     */
    readonly securityGroups?: ec2.ISecurityGroup[];
    private readonly cluster;
    private readonly taskDefinition;
    private readonly taskCount;
    private readonly role;
    private readonly platformVersion?;
    /**
     * @experimental
     */
    constructor(props: EcsTaskProps);
    /**
     * (experimental) Allows using tasks as target of EventBridge events.
     *
     * @experimental
     */
    bind(_rule: events.IRule, _id?: string): events.RuleTargetConfig;
    private createEventRolePolicyStatements;
}
