"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeBuildProject = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const util_1 = require("./util");
/**
 * (experimental) Start a CodeBuild build when an Amazon EventBridge rule is triggered.
 *
 * @experimental
 */
class CodeBuildProject {
    /**
     * @experimental
     */
    constructor(project, props = {}) {
        this.project = project;
        this.props = props;
    }
    /**
     * (experimental) Allows using build projects as event rule targets.
     *
     * @experimental
     */
    bind(_rule, _id) {
        return {
            id: '',
            arn: this.project.projectArn,
            role: util_1.singletonEventRole(this.project, [
                new iam.PolicyStatement({
                    actions: ['codebuild:StartBuild'],
                    resources: [this.project.projectArn],
                }),
            ]),
            input: this.props.event,
            targetResource: this.project,
        };
    }
}
exports.CodeBuildProject = CodeBuildProject;
//# sourceMappingURL=data:application/json;base64,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