"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BatchJob = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const util_1 = require("./util");
/**
 * (experimental) Use an AWS Batch Job / Queue as an event rule target.
 *
 * @experimental
 */
class BatchJob {
    /**
     * @experimental
     */
    constructor(jobQueue, jobDefinition, props = {}) {
        this.jobQueue = jobQueue;
        this.jobDefinition = jobDefinition;
        this.props = props;
    }
    /**
     * (experimental) Returns a RuleTarget that can be used to trigger queue this batch job as a result from an EventBridge event.
     *
     * @experimental
     */
    bind(rule, _id) {
        var _a;
        const batchParameters = {
            jobDefinition: this.jobDefinition.jobDefinitionArn,
            jobName: (_a = this.props.jobName) !== null && _a !== void 0 ? _a : rule.node.uniqueId,
            arrayProperties: this.props.size ? { size: this.props.size } : undefined,
            retryStrategy: this.props.attempts ? { attempts: this.props.attempts } : undefined,
        };
        return {
            id: '',
            arn: this.jobQueue.jobQueueArn,
            // When scoping resource-level access for job submission, you must provide both job queue and job definition resource types.
            // https://docs.aws.amazon.com/batch/latest/userguide/ExamplePolicies_BATCH.html#iam-example-restrict-job-def
            role: util_1.singletonEventRole(this.jobDefinition, [
                new iam.PolicyStatement({
                    actions: ['batch:SubmitJob'],
                    resources: [
                        this.jobDefinition.jobDefinitionArn,
                        this.jobQueue.jobQueueArn,
                    ],
                }),
            ]),
            input: this.props.event,
            targetResource: this.jobQueue,
            batchParameters,
        };
    }
}
exports.BatchJob = BatchJob;
//# sourceMappingURL=data:application/json;base64,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