import * as events from "../../aws-events";
import * as iam from "../../aws-iam";
/**
 * AWS SDK service metadata.
 */
export declare type AwsSdkMetadata = {
    [key: string]: any;
};
/**
 * (experimental) Rule target input for an AwsApi target.
 *
 * @experimental
 */
export interface AwsApiInput {
    /**
     * (experimental) The service to call.
     *
     * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html
     * @experimental
     */
    readonly service: string;
    /**
     * (experimental) The service action to call.
     *
     * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html
     * @experimental
     */
    readonly action: string;
    /**
     * (experimental) The parameters for the service action.
     *
     * @default - no parameters
     * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html
     * @experimental
     */
    readonly parameters?: any;
    /**
     * (experimental) The regex pattern to use to catch API errors.
     *
     * The `code` property of the
     * `Error` object will be tested against this pattern. If there is a match an
     * error will not be thrown.
     *
     * @default - do not catch errors
     * @experimental
     */
    readonly catchErrorPattern?: string;
    /**
     * (experimental) API version to use for the service.
     *
     * @default - use latest available API version
     * @see https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/locking-api-versions.html
     * @experimental
     */
    readonly apiVersion?: string;
}
/**
 * (experimental) Properties for an AwsApi target.
 *
 * @experimental
 */
export interface AwsApiProps extends AwsApiInput {
    /**
     * (experimental) The IAM policy statement to allow the API call.
     *
     * Use only if
     * resource restriction is needed.
     *
     * @default - extract the permission from the API call
     * @experimental
     */
    readonly policyStatement?: iam.PolicyStatement;
}
/**
 * (experimental) Use an AWS Lambda function that makes API calls as an event rule target.
 *
 * @experimental
 */
export declare class AwsApi implements events.IRuleTarget {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: AwsApiProps);
    /**
     * (experimental) Returns a RuleTarget that can be used to trigger this AwsApi as a result from an EventBridge event.
     *
     * @experimental
     */
    bind(rule: events.IRule, id?: string): events.RuleTargetConfig;
}
