/**
 * (experimental) What kind of addresses to allocate to the load balancer.
 *
 * @experimental
 */
export declare enum IpAddressType {
    /**
     * (experimental) Allocate IPv4 addresses.
     *
     * @experimental
     */
    IPV4 = "ipv4",
    /**
     * (experimental) Allocate both IPv4 and IPv6 addresses.
     *
     * @experimental
     */
    DUAL_STACK = "dualstack"
}
/**
 * (experimental) Backend protocol for network load balancers and health checks.
 *
 * @experimental
 */
export declare enum Protocol {
    /**
     * (experimental) HTTP (ALB health checks and NLB health checks).
     *
     * @experimental
     */
    HTTP = "HTTP",
    /**
     * (experimental) HTTPS (ALB health checks and NLB health checks).
     *
     * @experimental
     */
    HTTPS = "HTTPS",
    /**
     * (experimental) TCP (NLB, NLB health checks).
     *
     * @experimental
     */
    TCP = "TCP",
    /**
     * (experimental) TLS (NLB).
     *
     * @experimental
     */
    TLS = "TLS",
    /**
     * (experimental) UDP (NLB).
     *
     * @experimental
     */
    UDP = "UDP",
    /**
     * (experimental) Listen to both TCP and UDP on the same port (NLB).
     *
     * @experimental
     */
    TCP_UDP = "TCP_UDP"
}
/**
 * (experimental) Load balancing protocol for application load balancers.
 *
 * @experimental
 */
export declare enum ApplicationProtocol {
    /**
     * (experimental) HTTP.
     *
     * @experimental
     */
    HTTP = "HTTP",
    /**
     * (experimental) HTTPS.
     *
     * @experimental
     */
    HTTPS = "HTTPS"
}
/**
 * (experimental) Elastic Load Balancing provides the following security policies for Application Load Balancers.
 *
 * We recommend the Recommended policy for general use. You can
 * use the ForwardSecrecy policy if you require Forward Secrecy
 * (FS).
 *
 * You can use one of the TLS policies to meet compliance and security
 * standards that require disabling certain TLS protocol versions, or to
 * support legacy clients that require deprecated ciphers.
 *
 * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html
 * @experimental
 */
export declare enum SslPolicy {
    /**
     * (experimental) The recommended security policy.
     *
     * @experimental
     */
    RECOMMENDED = "ELBSecurityPolicy-2016-08",
    /**
     * (experimental) Strong forward secrecy ciphers and TLS1.2 only.
     *
     * @experimental
     */
    FORWARD_SECRECY_TLS12_RES = "ELBSecurityPolicy-FS-1-2-Res-2019-08",
    /**
     * (experimental) Forward secrecy ciphers and TLS1.2 only.
     *
     * @experimental
     */
    FORWARD_SECRECY_TLS12 = "ELBSecurityPolicy-FS-1-2-2019-08",
    /**
     * (experimental) Forward secrecy ciphers only with TLS1.1 and higher.
     *
     * @experimental
     */
    FORWARD_SECRECY_TLS11 = "ELBSecurityPolicy-FS-1-1-2019-08",
    /**
     * (experimental) Forward secrecy ciphers only.
     *
     * @experimental
     */
    FORWARD_SECRECY = "ELBSecurityPolicy-FS-2018-06",
    /**
     * (experimental) TLS1.2 only and no SHA ciphers.
     *
     * @experimental
     */
    TLS12 = "ELBSecurityPolicy-TLS-1-2-2017-01",
    /**
     * (experimental) TLS1.2 only with all ciphers.
     *
     * @experimental
     */
    TLS12_EXT = "ELBSecurityPolicy-TLS-1-2-Ext-2018-06",
    /**
     * (experimental) TLS1.1 and higher with all ciphers.
     *
     * @experimental
     */
    TLS11 = "ELBSecurityPolicy-TLS-1-1-2017-01",
    /**
     * (experimental) Support for DES-CBC3-SHA.
     *
     * Do not use this security policy unless you must support a legacy client
     * that requires the DES-CBC3-SHA cipher, which is a weak cipher.
     *
     * @experimental
     */
    LEGACY = "ELBSecurityPolicy-TLS-1-0-2015-04"
}
/**
 * (experimental) How to interpret the load balancing target identifiers.
 *
 * @experimental
 */
export declare enum TargetType {
    /**
     * (experimental) Targets identified by instance ID.
     *
     * @experimental
     */
    INSTANCE = "instance",
    /**
     * (experimental) Targets identified by IP address.
     *
     * @experimental
     */
    IP = "ip",
    /**
     * (experimental) Target is a single Lambda Function.
     *
     * @experimental
     */
    LAMBDA = "lambda"
}
