import * as cloudwatch from "../../../aws-cloudwatch";
import * as ec2 from "../../../aws-ec2";
import { IBucket } from "../../../aws-s3";
import { Construct } from 'constructs';
import { BaseLoadBalancer, BaseLoadBalancerProps, ILoadBalancerV2 } from '../shared/base-load-balancer';
import { BaseNetworkListenerProps, NetworkListener } from './network-listener';
/**
 * (experimental) Properties for a network load balancer.
 *
 * @experimental
 */
export interface NetworkLoadBalancerProps extends BaseLoadBalancerProps {
    /**
     * (experimental) Indicates whether cross-zone load balancing is enabled.
     *
     * @default false
     * @experimental
     */
    readonly crossZoneEnabled?: boolean;
}
/**
 * (experimental) Properties to reference an existing load balancer.
 *
 * @experimental
 */
export interface NetworkLoadBalancerAttributes {
    /**
     * (experimental) ARN of the load balancer.
     *
     * @experimental
     */
    readonly loadBalancerArn: string;
    /**
     * (experimental) The canonical hosted zone ID of this load balancer.
     *
     * @default - When not provided, LB cannot be used as Route53 Alias target.
     * @experimental
     */
    readonly loadBalancerCanonicalHostedZoneId?: string;
    /**
     * (experimental) The DNS name of this load balancer.
     *
     * @default - When not provided, LB cannot be used as Route53 Alias target.
     * @experimental
     */
    readonly loadBalancerDnsName?: string;
    /**
     * (experimental) The VPC to associate with the load balancer.
     *
     * @default - When not provided, listeners cannot be created on imported load
     * balancers.
     * @experimental
     */
    readonly vpc?: ec2.IVpc;
}
/**
 * (experimental) Define a new network load balancer.
 *
 * @experimental
 * @resource AWS::ElasticLoadBalancingV2::LoadBalancer
 */
export declare class NetworkLoadBalancer extends BaseLoadBalancer implements INetworkLoadBalancer {
    /**
     * @experimental
     */
    static fromNetworkLoadBalancerAttributes(scope: Construct, id: string, attrs: NetworkLoadBalancerAttributes): INetworkLoadBalancer;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: NetworkLoadBalancerProps);
    /**
     * (experimental) Add a listener to this load balancer.
     *
     * @returns The newly created listener
     * @experimental
     */
    addListener(id: string, props: BaseNetworkListenerProps): NetworkListener;
    /**
     * (experimental) Enable access logging for this load balancer.
     *
     * A region must be specified on the stack containing the load balancer; you cannot enable logging on
     * environment-agnostic stacks. See https://docs.aws.amazon.com/cdk/latest/guide/environments.html
     *
     * This is extending the BaseLoadBalancer.logAccessLogs method to match the bucket permissions described
     * at https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-access-logs.html#access-logging-bucket-requirements
     *
     * @experimental
     */
    logAccessLogs(bucket: IBucket, prefix?: string): void;
    /**
     * (experimental) Return the given named metric for this Network Load Balancer.
     *
     * @default Average over 5 minutes
     * @experimental
     */
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The total number of concurrent TCP flows (or connections) from clients to targets.
     *
     * This metric includes connections in the SYN_SENT and ESTABLISHED states.
     * TCP connections are not terminated at the load balancer, so a client
     * opening a TCP connection to a target counts as a single flow.
     *
     * @default Average over 5 minutes
     * @experimental
     */
    metricActiveFlowCount(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of load balancer capacity units (LCU) used by your load balancer.
     *
     * @default Sum over 5 minutes
     * @experimental
     */
    metricConsumedLCUs(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of targets that are considered healthy.
     *
     * @default Average over 5 minutes
     * @experimental
     */
    metricHealthyHostCount(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of targets that are considered unhealthy.
     *
     * @default Average over 5 minutes
     * @experimental
     */
    metricUnHealthyHostCount(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The total number of new TCP flows (or connections) established from clients to targets in the time period.
     *
     * @default Sum over 5 minutes
     * @experimental
     */
    metricNewFlowCount(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The total number of bytes processed by the load balancer, including TCP/IP headers.
     *
     * @default Sum over 5 minutes
     * @experimental
     */
    metricProcessedBytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The total number of reset (RST) packets sent from a client to a target.
     *
     * These resets are generated by the client and forwarded by the load balancer.
     *
     * @default Sum over 5 minutes
     * @experimental
     */
    metricTcpClientResetCount(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The total number of reset (RST) packets generated by the load balancer.
     *
     * @default Sum over 5 minutes
     * @experimental
     */
    metricTcpElbResetCount(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The total number of reset (RST) packets sent from a target to a client.
     *
     * These resets are generated by the target and forwarded by the load balancer.
     *
     * @default Sum over 5 minutes
     * @experimental
     */
    metricTcpTargetResetCount(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
}
/**
 * (experimental) A network load balancer.
 *
 * @experimental
 */
export interface INetworkLoadBalancer extends ILoadBalancerV2, ec2.IVpcEndpointServiceLoadBalancer {
    /**
     * (experimental) The VPC this load balancer has been created in (if available).
     *
     * @experimental
     */
    readonly vpc?: ec2.IVpc;
    /**
     * (experimental) Add a listener to this load balancer.
     *
     * @returns The newly created listener
     * @experimental
     */
    addListener(id: string, props: BaseNetworkListenerProps): NetworkListener;
}
