import { Construct, Duration } from "../../../core";
import { CfnListener } from '../elasticloadbalancingv2.generated';
import { IListenerAction } from '../shared/listener-action';
import { INetworkListener } from './network-listener';
import { INetworkTargetGroup } from './network-target-group';
/**
 * (experimental) What to do when a client makes a request to a listener.
 *
 * Some actions can be combined with other ones (specifically,
 * you can perform authentication before serving the request).
 *
 * Multiple actions form a linked chain; the chain must always terminate in a
 * *(weighted)forward*, *fixedResponse* or *redirect* action.
 *
 * If an action supports chaining, the next action can be indicated
 * by passing it in the `next` property.
 *
 * @experimental
 */
export declare class NetworkListenerAction implements IListenerAction {
    private readonly actionJson;
    protected readonly next?: NetworkListenerAction | undefined;
    /**
     * (experimental) Forward to one or more Target Groups.
     *
     * @experimental
     */
    static forward(targetGroups: INetworkTargetGroup[], options?: NetworkForwardOptions): NetworkListenerAction;
    /**
     * (experimental) Forward to one or more Target Groups which are weighted differently.
     *
     * @experimental
     */
    static weightedForward(targetGroups: NetworkWeightedTargetGroup[], options?: NetworkForwardOptions): NetworkListenerAction;
    /**
     * (experimental) Create an instance of NetworkListenerAction.
     *
     * The default class should be good enough for most cases and
     * should be created by using one of the static factory functions,
     * but allow overriding to make sure we allow flexibility for the future.
     *
     * @experimental
     */
    protected constructor(actionJson: CfnListener.ActionProperty, next?: NetworkListenerAction | undefined);
    /**
     * (experimental) Render the actions in this chain.
     *
     * @experimental
     */
    renderActions(): CfnListener.ActionProperty[];
    /**
     * (experimental) Called when the action is being used in a listener.
     *
     * @experimental
     */
    bind(scope: Construct, listener: INetworkListener): void;
    /**
     * (experimental) Renumber the "order" fields in the actions array.
     *
     * We don't number for 0 or 1 elements, but otherwise number them 1...#actions
     * so ELB knows about the right order.
     *
     * Do this in `NetworkListenerAction` instead of in `Listener` so that we give
     * users the opportunity to override by subclassing and overriding `renderActions`.
     *
     * @experimental
     */
    protected renumber(actions: CfnListener.ActionProperty[]): CfnListener.ActionProperty[];
}
/**
 * (experimental) Options for `NetworkListenerAction.forward()`.
 *
 * @experimental
 */
export interface NetworkForwardOptions {
    /**
     * (experimental) For how long clients should be directed to the same target group.
     *
     * Range between 1 second and 7 days.
     *
     * @default - No stickiness
     * @experimental
     */
    readonly stickinessDuration?: Duration;
}
/**
 * (experimental) A Target Group and weight combination.
 *
 * @experimental
 */
export interface NetworkWeightedTargetGroup {
    /**
     * (experimental) The target group.
     *
     * @experimental
     */
    readonly targetGroup: INetworkTargetGroup;
    /**
     * (experimental) The target group's weight.
     *
     * Range is [0..1000).
     *
     * @default 1
     * @experimental
     */
    readonly weight?: number;
}
