"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ListenerCondition = void 0;
/**
 * (experimental) ListenerCondition providers definition.
 *
 * @experimental
 */
class ListenerCondition {
    /**
     * (experimental) Create a host-header listener rule condition.
     *
     * @param values Hosts for host headers.
     * @experimental
     */
    static hostHeaders(values) {
        return new HostHeaderListenerCondition(values);
    }
    /**
     * (experimental) Create a http-header listener rule condition.
     *
     * @param name HTTP header name.
     * @param values HTTP header values.
     * @experimental
     */
    static httpHeader(name, values) {
        return new HttpHeaderListenerCondition(name, values);
    }
    /**
     * (experimental) Create a http-request-method listener rule condition.
     *
     * @param values HTTP request methods.
     * @experimental
     */
    static httpRequestMethods(values) {
        return new HttpRequestMethodListenerCondition(values);
    }
    /**
     * (experimental) Create a path-pattern listener rule condition.
     *
     * @param values Path patterns.
     * @experimental
     */
    static pathPatterns(values) {
        return new PathPatternListenerCondition(values);
    }
    /**
     * (experimental) Create a query-string listener rule condition.
     *
     * @param values Query string key/value pairs.
     * @experimental
     */
    static queryStrings(values) {
        return new QueryStringListenerCondition(values);
    }
    /**
     * (experimental) Create a source-ip listener rule condition.
     *
     * @param values Source ips.
     * @experimental
     */
    static sourceIps(values) {
        return new SourceIpListenerCondition(values);
    }
}
exports.ListenerCondition = ListenerCondition;
/**
 * Host header config of the listener rule condition
 */
class HostHeaderListenerCondition extends ListenerCondition {
    constructor(values) {
        super();
        this.values = values;
    }
    renderRawCondition() {
        return {
            field: 'host-header',
            hostHeaderConfig: {
                values: this.values,
            },
        };
    }
}
/**
 * HTTP header config of the listener rule condition
 */
class HttpHeaderListenerCondition extends ListenerCondition {
    constructor(name, values) {
        super();
        this.name = name;
        this.values = values;
    }
    renderRawCondition() {
        return {
            field: 'http-header',
            httpHeaderConfig: {
                httpHeaderName: this.name,
                values: this.values,
            },
        };
    }
}
/**
 * HTTP reqeust method config of the listener rule condition
 */
class HttpRequestMethodListenerCondition extends ListenerCondition {
    constructor(values) {
        super();
        this.values = values;
    }
    renderRawCondition() {
        return {
            field: 'http-request-method',
            httpRequestMethodConfig: {
                values: this.values,
            },
        };
    }
}
/**
 * Path pattern config of the listener rule condition
 */
class PathPatternListenerCondition extends ListenerCondition {
    constructor(values) {
        super();
        this.values = values;
        if (values && values.length > 5) {
            throw new Error("A rule can only have '5' condition values");
        }
    }
    renderRawCondition() {
        return {
            field: 'path-pattern',
            pathPatternConfig: {
                values: this.values,
            },
        };
    }
}
/**
 * Query string config of the listener rule condition
 */
class QueryStringListenerCondition extends ListenerCondition {
    constructor(values) {
        super();
        this.values = values;
    }
    renderRawCondition() {
        return {
            field: 'query-string',
            queryStringConfig: {
                values: this.values,
            },
        };
    }
}
/**
 * Source ip config of the listener rule condition
 */
class SourceIpListenerCondition extends ListenerCondition {
    constructor(values) {
        super();
        this.values = values;
    }
    renderRawCondition() {
        return {
            field: 'source-ip',
            sourceIpConfig: {
                values: this.values,
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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