/**
 * (experimental) ListenerCondition providers definition.
 *
 * @experimental
 */
export declare abstract class ListenerCondition {
    /**
     * (experimental) Create a host-header listener rule condition.
     *
     * @param values Hosts for host headers.
     * @experimental
     */
    static hostHeaders(values: string[]): ListenerCondition;
    /**
     * (experimental) Create a http-header listener rule condition.
     *
     * @param name HTTP header name.
     * @param values HTTP header values.
     * @experimental
     */
    static httpHeader(name: string, values: string[]): ListenerCondition;
    /**
     * (experimental) Create a http-request-method listener rule condition.
     *
     * @param values HTTP request methods.
     * @experimental
     */
    static httpRequestMethods(values: string[]): ListenerCondition;
    /**
     * (experimental) Create a path-pattern listener rule condition.
     *
     * @param values Path patterns.
     * @experimental
     */
    static pathPatterns(values: string[]): ListenerCondition;
    /**
     * (experimental) Create a query-string listener rule condition.
     *
     * @param values Query string key/value pairs.
     * @experimental
     */
    static queryStrings(values: QueryStringCondition[]): ListenerCondition;
    /**
     * (experimental) Create a source-ip listener rule condition.
     *
     * @param values Source ips.
     * @experimental
     */
    static sourceIps(values: string[]): ListenerCondition;
    /**
     * (experimental) Render the raw Cfn listener rule condition object.
     *
     * @experimental
     */
    abstract renderRawCondition(): any;
}
/**
 * (experimental) Properties for the key/value pair of the query string.
 *
 * @experimental
 */
export interface QueryStringCondition {
    /**
     * (experimental) The query string key for the condition.
     *
     * @default - Any key can be matched.
     * @experimental
     */
    readonly key?: string;
    /**
     * (experimental) The query string value for the condition.
     *
     * @experimental
     */
    readonly value: string;
}
