import * as cdk from "../../../core";
import { Construct } from 'constructs';
import { IListenerCertificate } from '../shared/listener-certificate';
import { IApplicationListener } from './application-listener';
/**
 * (experimental) Properties for adding a set of certificates to a listener.
 *
 * @experimental
 */
export interface ApplicationListenerCertificateProps {
    /**
     * (experimental) The listener to attach the rule to.
     *
     * @experimental
     */
    readonly listener: IApplicationListener;
    /**
     * (deprecated) ARNs of certificates to attach.
     *
     * Duplicates are not allowed.
     *
     * @default - One of 'certificates' and 'certificateArns' is required.
     * @deprecated Use `certificates` instead.
     */
    readonly certificateArns?: string[];
    /**
     * (experimental) Certificates to attach.
     *
     * Duplicates are not allowed.
     *
     * @default - One of 'certificates' and 'certificateArns' is required.
     * @experimental
     */
    readonly certificates?: IListenerCertificate[];
}
/**
 * (experimental) Add certificates to a listener.
 *
 * @experimental
 */
export declare class ApplicationListenerCertificate extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ApplicationListenerCertificateProps);
}
