"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthenticateCognitoAction = void 0;
const elbv2 = require("../../aws-elasticloadbalancingv2"); // Automatically re-written from '@aws-cdk/aws-elasticloadbalancingv2'
/**
 * (experimental) A Listener Action to authenticate with Cognito.
 *
 * @experimental
 */
class AuthenticateCognitoAction extends elbv2.ListenerAction {
    /**
     * (experimental) Authenticate using an identity provide (IdP) that is compliant with OpenID Connect (OIDC).
     *
     * @experimental
     */
    constructor(options) {
        var _a;
        super({
            type: 'authenticate-cognito',
            authenticateCognitoConfig: {
                userPoolArn: options.userPool.userPoolArn,
                userPoolClientId: options.userPoolClient.userPoolClientId,
                userPoolDomain: options.userPoolDomain.domainName,
                authenticationRequestExtraParams: options.authenticationRequestExtraParams,
                onUnauthenticatedRequest: options.onUnauthenticatedRequest,
                scope: options.scope,
                sessionCookieName: options.sessionCookieName,
                sessionTimeout: (_a = options.sessionTimeout) === null || _a === void 0 ? void 0 : _a.toSeconds(),
            },
        }, options.next);
    }
}
exports.AuthenticateCognitoAction = AuthenticateCognitoAction;
//# sourceMappingURL=data:application/json;base64,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