import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::ElasticBeanstalk::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html
 * @external
 */
export interface CfnApplicationProps {
    /**
     * `AWS::ElasticBeanstalk::Application.ApplicationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html#cfn-elasticbeanstalk-application-name
     * @external
     */
    readonly applicationName?: string;
    /**
     * `AWS::ElasticBeanstalk::Application.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html#cfn-elasticbeanstalk-application-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::ElasticBeanstalk::Application.ResourceLifecycleConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html#cfn-elasticbeanstalk-application-resourcelifecycleconfig
     * @external
     */
    readonly resourceLifecycleConfig?: CfnApplication.ApplicationResourceLifecycleConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::ElasticBeanstalk::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html
 * @external
 * @cloudformationResource AWS::ElasticBeanstalk::Application
 */
export declare class CfnApplication extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ElasticBeanstalk::Application";
    /**
     * `AWS::ElasticBeanstalk::Application.ApplicationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html#cfn-elasticbeanstalk-application-name
     * @external
     */
    applicationName: string | undefined;
    /**
     * `AWS::ElasticBeanstalk::Application.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html#cfn-elasticbeanstalk-application-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::ElasticBeanstalk::Application.ResourceLifecycleConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html#cfn-elasticbeanstalk-application-resourcelifecycleconfig
     * @external
     */
    resourceLifecycleConfig: CfnApplication.ApplicationResourceLifecycleConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::ElasticBeanstalk::Application`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnApplicationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ElasticBeanstalk::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html
 * @external
 * @cloudformationResource AWS::ElasticBeanstalk::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html
     * @external
     */
    interface ApplicationResourceLifecycleConfigProperty {
        /**
         * `CfnApplication.ApplicationResourceLifecycleConfigProperty.ServiceRole`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-servicerole
         * @external
         */
        readonly serviceRole?: string;
        /**
         * `CfnApplication.ApplicationResourceLifecycleConfigProperty.VersionLifecycleConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-versionlifecycleconfig
         * @external
         */
        readonly versionLifecycleConfig?: CfnApplication.ApplicationVersionLifecycleConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ElasticBeanstalk::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html
 * @external
 * @cloudformationResource AWS::ElasticBeanstalk::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html
     * @external
     */
    interface ApplicationVersionLifecycleConfigProperty {
        /**
         * `CfnApplication.ApplicationVersionLifecycleConfigProperty.MaxAgeRule`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxagerule
         * @external
         */
        readonly maxAgeRule?: CfnApplication.MaxAgeRuleProperty | cdk.IResolvable;
        /**
         * `CfnApplication.ApplicationVersionLifecycleConfigProperty.MaxCountRule`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxcountrule
         * @external
         */
        readonly maxCountRule?: CfnApplication.MaxCountRuleProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ElasticBeanstalk::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html
 * @external
 * @cloudformationResource AWS::ElasticBeanstalk::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html
     * @external
     */
    interface MaxAgeRuleProperty {
        /**
         * `CfnApplication.MaxAgeRuleProperty.DeleteSourceFromS3`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-deletesourcefroms3
         * @external
         */
        readonly deleteSourceFromS3?: boolean | cdk.IResolvable;
        /**
         * `CfnApplication.MaxAgeRuleProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-enabled
         * @external
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnApplication.MaxAgeRuleProperty.MaxAgeInDays`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-maxageindays
         * @external
         */
        readonly maxAgeInDays?: number;
    }
}
/**
 * A CloudFormation `AWS::ElasticBeanstalk::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html
 * @external
 * @cloudformationResource AWS::ElasticBeanstalk::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html
     * @external
     */
    interface MaxCountRuleProperty {
        /**
         * `CfnApplication.MaxCountRuleProperty.DeleteSourceFromS3`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-deletesourcefroms3
         * @external
         */
        readonly deleteSourceFromS3?: boolean | cdk.IResolvable;
        /**
         * `CfnApplication.MaxCountRuleProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-enabled
         * @external
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnApplication.MaxCountRuleProperty.MaxCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-maxcount
         * @external
         */
        readonly maxCount?: number;
    }
}
/**
 * Properties for defining a `AWS::ElasticBeanstalk::ApplicationVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html
 * @external
 */
export interface CfnApplicationVersionProps {
    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.ApplicationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-applicationname
     * @external
     */
    readonly applicationName: string;
    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-sourcebundle
     * @external
     */
    readonly sourceBundle: CfnApplicationVersion.SourceBundleProperty | cdk.IResolvable;
    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-description
     * @external
     */
    readonly description?: string;
}
/**
 * A CloudFormation `AWS::ElasticBeanstalk::ApplicationVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html
 * @external
 * @cloudformationResource AWS::ElasticBeanstalk::ApplicationVersion
 */
export declare class CfnApplicationVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ElasticBeanstalk::ApplicationVersion";
    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.ApplicationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-applicationname
     * @external
     */
    applicationName: string;
    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-sourcebundle
     * @external
     */
    sourceBundle: CfnApplicationVersion.SourceBundleProperty | cdk.IResolvable;
    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-description
     * @external
     */
    description: string | undefined;
    /**
     * Create a new `AWS::ElasticBeanstalk::ApplicationVersion`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApplicationVersionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ElasticBeanstalk::ApplicationVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html
 * @external
 * @cloudformationResource AWS::ElasticBeanstalk::ApplicationVersion
 */
export declare namespace CfnApplicationVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html
     * @external
     */
    interface SourceBundleProperty {
        /**
         * `CfnApplicationVersion.SourceBundleProperty.S3Bucket`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3bucket
         * @external
         */
        readonly s3Bucket: string;
        /**
         * `CfnApplicationVersion.SourceBundleProperty.S3Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3key
         * @external
         */
        readonly s3Key: string;
    }
}
/**
 * Properties for defining a `AWS::ElasticBeanstalk::ConfigurationTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html
 * @external
 */
export interface CfnConfigurationTemplateProps {
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.ApplicationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-applicationname
     * @external
     */
    readonly applicationName: string;
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.EnvironmentId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-environmentid
     * @external
     */
    readonly environmentId?: string;
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.OptionSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-optionsettings
     * @external
     */
    readonly optionSettings?: Array<CfnConfigurationTemplate.ConfigurationOptionSettingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.PlatformArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-platformarn
     * @external
     */
    readonly platformArn?: string;
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.SolutionStackName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-solutionstackname
     * @external
     */
    readonly solutionStackName?: string;
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.SourceConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration
     * @external
     */
    readonly sourceConfiguration?: CfnConfigurationTemplate.SourceConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::ElasticBeanstalk::ConfigurationTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html
 * @external
 * @cloudformationResource AWS::ElasticBeanstalk::ConfigurationTemplate
 */
export declare class CfnConfigurationTemplate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ElasticBeanstalk::ConfigurationTemplate";
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.ApplicationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-applicationname
     * @external
     */
    applicationName: string;
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.EnvironmentId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-environmentid
     * @external
     */
    environmentId: string | undefined;
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.OptionSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-optionsettings
     * @external
     */
    optionSettings: Array<CfnConfigurationTemplate.ConfigurationOptionSettingProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.PlatformArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-platformarn
     * @external
     */
    platformArn: string | undefined;
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.SolutionStackName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-solutionstackname
     * @external
     */
    solutionStackName: string | undefined;
    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.SourceConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration
     * @external
     */
    sourceConfiguration: CfnConfigurationTemplate.SourceConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::ElasticBeanstalk::ConfigurationTemplate`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConfigurationTemplateProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ElasticBeanstalk::ConfigurationTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html
 * @external
 * @cloudformationResource AWS::ElasticBeanstalk::ConfigurationTemplate
 */
export declare namespace CfnConfigurationTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html
     * @external
     */
    interface ConfigurationOptionSettingProperty {
        /**
         * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.Namespace`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-namespace
         * @external
         */
        readonly namespace: string;
        /**
         * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.OptionName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-optionname
         * @external
         */
        readonly optionName: string;
        /**
         * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.ResourceName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-resourcename
         * @external
         */
        readonly resourceName?: string;
        /**
         * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-value
         * @external
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticBeanstalk::ConfigurationTemplate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html
 * @external
 * @cloudformationResource AWS::ElasticBeanstalk::ConfigurationTemplate
 */
export declare namespace CfnConfigurationTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html
     * @external
     */
    interface SourceConfigurationProperty {
        /**
         * `CfnConfigurationTemplate.SourceConfigurationProperty.ApplicationName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-applicationname
         * @external
         */
        readonly applicationName: string;
        /**
         * `CfnConfigurationTemplate.SourceConfigurationProperty.TemplateName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-templatename
         * @external
         */
        readonly templateName: string;
    }
}
/**
 * Properties for defining a `AWS::ElasticBeanstalk::Environment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html
 * @external
 */
export interface CfnEnvironmentProps {
    /**
     * `AWS::ElasticBeanstalk::Environment.ApplicationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-applicationname
     * @external
     */
    readonly applicationName: string;
    /**
     * `AWS::ElasticBeanstalk::Environment.CNAMEPrefix`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-cnameprefix
     * @external
     */
    readonly cnamePrefix?: string;
    /**
     * `AWS::ElasticBeanstalk::Environment.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::ElasticBeanstalk::Environment.EnvironmentName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-name
     * @external
     */
    readonly environmentName?: string;
    /**
     * `AWS::ElasticBeanstalk::Environment.OptionSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-optionsettings
     * @external
     */
    readonly optionSettings?: Array<CfnEnvironment.OptionSettingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticBeanstalk::Environment.PlatformArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn
     * @external
     */
    readonly platformArn?: string;
    /**
     * `AWS::ElasticBeanstalk::Environment.SolutionStackName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-solutionstackname
     * @external
     */
    readonly solutionStackName?: string;
    /**
     * `AWS::ElasticBeanstalk::Environment.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-elasticbeanstalk-environment-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::ElasticBeanstalk::Environment.TemplateName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-templatename
     * @external
     */
    readonly templateName?: string;
    /**
     * `AWS::ElasticBeanstalk::Environment.Tier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-tier
     * @external
     */
    readonly tier?: CfnEnvironment.TierProperty | cdk.IResolvable;
    /**
     * `AWS::ElasticBeanstalk::Environment.VersionLabel`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-versionlabel
     * @external
     */
    readonly versionLabel?: string;
}
/**
 * A CloudFormation `AWS::ElasticBeanstalk::Environment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html
 * @external
 * @cloudformationResource AWS::ElasticBeanstalk::Environment
 */
export declare class CfnEnvironment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ElasticBeanstalk::Environment";
    /**
     * @external
     * @cloudformationAttribute EndpointURL
     */
    readonly attrEndpointUrl: string;
    /**
     * `AWS::ElasticBeanstalk::Environment.ApplicationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-applicationname
     * @external
     */
    applicationName: string;
    /**
     * `AWS::ElasticBeanstalk::Environment.CNAMEPrefix`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-cnameprefix
     * @external
     */
    cnamePrefix: string | undefined;
    /**
     * `AWS::ElasticBeanstalk::Environment.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::ElasticBeanstalk::Environment.EnvironmentName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-name
     * @external
     */
    environmentName: string | undefined;
    /**
     * `AWS::ElasticBeanstalk::Environment.OptionSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-optionsettings
     * @external
     */
    optionSettings: Array<CfnEnvironment.OptionSettingProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticBeanstalk::Environment.PlatformArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn
     * @external
     */
    platformArn: string | undefined;
    /**
     * `AWS::ElasticBeanstalk::Environment.SolutionStackName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-solutionstackname
     * @external
     */
    solutionStackName: string | undefined;
    /**
     * `AWS::ElasticBeanstalk::Environment.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-elasticbeanstalk-environment-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::ElasticBeanstalk::Environment.TemplateName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-templatename
     * @external
     */
    templateName: string | undefined;
    /**
     * `AWS::ElasticBeanstalk::Environment.Tier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-tier
     * @external
     */
    tier: CfnEnvironment.TierProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticBeanstalk::Environment.VersionLabel`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-versionlabel
     * @external
     */
    versionLabel: string | undefined;
    /**
     * Create a new `AWS::ElasticBeanstalk::Environment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEnvironmentProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ElasticBeanstalk::Environment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html
 * @external
 * @cloudformationResource AWS::ElasticBeanstalk::Environment
 */
export declare namespace CfnEnvironment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html
     * @external
     */
    interface OptionSettingProperty {
        /**
         * `CfnEnvironment.OptionSettingProperty.Namespace`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-namespace
         * @external
         */
        readonly namespace: string;
        /**
         * `CfnEnvironment.OptionSettingProperty.OptionName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-optionname
         * @external
         */
        readonly optionName: string;
        /**
         * `CfnEnvironment.OptionSettingProperty.ResourceName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-elasticbeanstalk-environment-optionsetting-resourcename
         * @external
         */
        readonly resourceName?: string;
        /**
         * `CfnEnvironment.OptionSettingProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-value
         * @external
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticBeanstalk::Environment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html
 * @external
 * @cloudformationResource AWS::ElasticBeanstalk::Environment
 */
export declare namespace CfnEnvironment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html
     * @external
     */
    interface TierProperty {
        /**
         * `CfnEnvironment.TierProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnEnvironment.TierProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-type
         * @external
         */
        readonly type?: string;
        /**
         * `CfnEnvironment.TierProperty.Version`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-version
         * @external
         */
        readonly version?: string;
    }
}
