import { AddToPrincipalPolicyResult, IPrincipal, IRole, PolicyStatement, PrincipalPolicyFragment } from "../../aws-iam";
import { Construct } from 'constructs';
import { Cluster } from './cluster';
import { Construct as CoreConstruct } from "../../core";
/**
 * (experimental) Options for `ServiceAccount`.
 *
 * @experimental
 */
export interface ServiceAccountOptions {
    /**
     * (experimental) The name of the service account.
     *
     * @default - If no name is given, it will use the id of the resource.
     * @experimental
     */
    readonly name?: string;
    /**
     * (experimental) The namespace of the service account.
     *
     * @default "default"
     * @experimental
     */
    readonly namespace?: string;
}
/**
 * (experimental) Properties for defining service accounts.
 *
 * @experimental
 */
export interface ServiceAccountProps extends ServiceAccountOptions {
    /**
     * (experimental) The cluster to apply the patch to.
     *
     * [disable-awslint:ref-via-interface]
     *
     * @experimental
     */
    readonly cluster: Cluster;
}
/**
 * (experimental) Service Account.
 *
 * @experimental
 */
export declare class ServiceAccount extends CoreConstruct implements IPrincipal {
    /**
     * (experimental) The role which is linked to the service account.
     *
     * @experimental
     */
    readonly role: IRole;
    /**
     * (experimental) When this Principal is used in an AssumeRole policy, the action to use.
     *
     * @experimental
     */
    readonly assumeRoleAction: string;
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    readonly grantPrincipal: IPrincipal;
    /**
     * (experimental) Return the policy fragment that identifies this principal in a Policy.
     *
     * @experimental
     */
    readonly policyFragment: PrincipalPolicyFragment;
    /**
     * (experimental) The name of the service account.
     *
     * @experimental
     */
    readonly serviceAccountName: string;
    /**
     * (experimental) The namespace where the service account is located in.
     *
     * @experimental
     */
    readonly serviceAccountNamespace: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ServiceAccountProps);
    /**
     * (experimental) Add to the policy of this principal.
     *
     * @experimental
     */
    addToPolicy(statement: PolicyStatement): boolean;
    /**
     * (experimental) Add to the policy of this principal.
     *
     * @experimental
     */
    addToPrincipalPolicy(statement: PolicyStatement): AddToPrincipalPolicyResult;
}
