"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesPatch = exports.PatchType = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const kubectl_provider_1 = require("./kubectl-provider");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * (experimental) Values for `kubectl patch` --type argument.
 *
 * @experimental
 */
var PatchType;
(function (PatchType) {
    PatchType["JSON"] = "json";
    PatchType["MERGE"] = "merge";
    PatchType["STRATEGIC"] = "strategic";
})(PatchType = exports.PatchType || (exports.PatchType = {}));
/**
 * (experimental) A CloudFormation resource which applies/restores a JSON patch into a Kubernetes resource.
 *
 * @see https://kubernetes.io/docs/tasks/run-application/update-api-object-kubectl-patch/
 * @experimental
 */
class KubernetesPatch extends core_2.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _a, _b;
        super(scope, id);
        const stack = core_1.Stack.of(this);
        const provider = kubectl_provider_1.KubectlProvider.getOrCreate(this, props.cluster);
        new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: 'Custom::AWSCDK-EKS-KubernetesPatch',
            properties: {
                ResourceName: props.resourceName,
                ResourceNamespace: (_a = props.resourceNamespace) !== null && _a !== void 0 ? _a : 'default',
                ApplyPatchJson: stack.toJsonString(props.applyPatch),
                RestorePatchJson: stack.toJsonString(props.restorePatch),
                ClusterName: props.cluster.clusterName,
                RoleArn: provider.roleArn,
                PatchType: (_b = props.patchType) !== null && _b !== void 0 ? _b : PatchType.STRATEGIC,
            },
        });
    }
}
exports.KubernetesPatch = KubernetesPatch;
//# sourceMappingURL=data:application/json;base64,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