import { Duration } from "../../core";
import { Construct } from 'constructs';
import { ICluster } from './cluster';
import { Construct as CoreConstruct } from "../../core";
/**
 * (experimental) Properties for KubernetesObjectValue.
 *
 * @experimental
 */
export interface KubernetesObjectValueProps {
    /**
     * (experimental) The EKS cluster to fetch attributes from.
     *
     * [disable-awslint:ref-via-interface]
     *
     * @experimental
     */
    readonly cluster: ICluster;
    /**
     * (experimental) The object type to query.
     *
     * (e.g 'service', 'pod'...)
     *
     * @experimental
     */
    readonly objectType: string;
    /**
     * (experimental) The name of the object to query.
     *
     * @experimental
     */
    readonly objectName: string;
    /**
     * (experimental) The namespace the object belongs to.
     *
     * @default 'default'
     * @experimental
     */
    readonly objectNamespace?: string;
    /**
     * (experimental) JSONPath to the specific value.
     *
     * @see https://kubernetes.io/docs/reference/kubectl/jsonpath/
     * @experimental
     */
    readonly jsonPath: string;
    /**
     * (experimental) Timeout for waiting on a value.
     *
     * @default Duration.minutes(5)
     * @experimental
     */
    readonly timeout?: Duration;
}
/**
 * (experimental) Represents a value of a specific object deployed in the cluster.
 *
 * Use this to fetch any information available by the `kubectl get` command.
 *
 * @experimental
 */
export declare class KubernetesObjectValue extends CoreConstruct {
    /**
     * (experimental) The CloudFormation reosurce type.
     *
     * @experimental
     */
    static readonly RESOURCE_TYPE = "Custom::AWSCDK-EKS-KubernetesObjectValue";
    private _resource;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubernetesObjectValueProps);
    /**
     * (experimental) The value as a string token.
     *
     * @experimental
     */
    get value(): string;
}
