"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourceHandler = void 0;
class ResourceHandler {
    constructor(eks, event) {
        this.eks = eks;
        this.requestType = event.RequestType;
        this.requestId = event.RequestId;
        this.logicalResourceId = event.LogicalResourceId;
        this.physicalResourceId = event.PhysicalResourceId;
        this.event = event;
        const roleToAssume = event.ResourceProperties.AssumeRoleArn;
        if (!roleToAssume) {
            throw new Error('AssumeRoleArn must be provided');
        }
        eks.configureAssumeRole({
            RoleArn: roleToAssume,
            RoleSessionName: `AWSCDK.EKSCluster.${this.requestType}.${this.requestId}`,
        });
    }
    onEvent() {
        switch (this.requestType) {
            case 'Create': return this.onCreate();
            case 'Update': return this.onUpdate();
            case 'Delete': return this.onDelete();
        }
        throw new Error(`Invalid request type ${this.requestType}`);
    }
    isComplete() {
        switch (this.requestType) {
            case 'Create': return this.isCreateComplete();
            case 'Update': return this.isUpdateComplete();
            case 'Delete': return this.isDeleteComplete();
        }
        throw new Error(`Invalid request type ${this.requestType}`);
    }
    log(x) {
        // eslint-disable-next-line no-console
        console.log(JSON.stringify(x, undefined, 2));
    }
}
exports.ResourceHandler = ResourceHandler;
//# sourceMappingURL=data:application/json;base64,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