import * as autoscaling from "../../aws-autoscaling";
import * as ec2 from "../../aws-ec2";
import * as iam from "../../aws-iam";
import { Construct, IResource, Resource } from "../../core";
import { AwsAuth } from './aws-auth';
import { HelmChart, HelmChartOptions } from './helm-chart';
import { KubernetesResource } from './k8s-resource';
/**
 * (experimental) An EKS cluster.
 *
 * @experimental
 */
export interface ICluster extends IResource, ec2.IConnectable {
    /**
     * (experimental) The VPC in which this Cluster was created.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (experimental) The physical name of the Cluster.
     *
     * @experimental
     * @attribute true
     */
    readonly clusterName: string;
    /**
     * (experimental) The unique ARN assigned to the service by AWS in the form of arn:aws:eks:.
     *
     * @experimental
     * @attribute true
     */
    readonly clusterArn: string;
    /**
     * (experimental) The API Server endpoint URL.
     *
     * @experimental
     * @attribute true
     */
    readonly clusterEndpoint: string;
    /**
     * (experimental) The certificate-authority-data for your cluster.
     *
     * @experimental
     * @attribute true
     */
    readonly clusterCertificateAuthorityData: string;
}
/**
 * @experimental
 */
export interface ClusterAttributes {
    /**
     * (experimental) The VPC in which this Cluster was created.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (experimental) The physical name of the Cluster.
     *
     * @experimental
     */
    readonly clusterName: string;
    /**
     * (experimental) The unique ARN assigned to the service by AWS in the form of arn:aws:eks:.
     *
     * @experimental
     */
    readonly clusterArn: string;
    /**
     * (experimental) The API Server endpoint URL.
     *
     * @experimental
     */
    readonly clusterEndpoint: string;
    /**
     * (experimental) The certificate-authority-data for your cluster.
     *
     * @experimental
     */
    readonly clusterCertificateAuthorityData: string;
    /**
     * (experimental) The security groups associated with this cluster.
     *
     * @experimental
     */
    readonly securityGroups: ec2.ISecurityGroup[];
}
/**
 * (experimental) Properties to instantiate the Cluster.
 *
 * @experimental
 */
export interface ClusterProps {
    /**
     * (experimental) The VPC in which to create the Cluster.
     *
     * @default - a VPC with default configuration will be created and can be accessed through `cluster.vpc`.
     * @experimental
     */
    readonly vpc?: ec2.IVpc;
    /**
     * (experimental) Where to place EKS Control Plane ENIs.
     *
     * If you want to create public load balancers, this must include public subnets.
     *
     * For example, to only select private subnets, supply the following:
     *
     * ```ts
     * vpcSubnets: [
     *    { subnetType: ec2.SubnetType.Private }
     * ]
     * ```
     *
     * @default - All public and private subnets
     * @experimental
     */
    readonly vpcSubnets?: ec2.SubnetSelection[];
    /**
     * (experimental) Role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf.
     *
     * @default - A role is automatically created for you
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) Name for the cluster.
     *
     * @default - Automatically generated name
     * @experimental
     */
    readonly clusterName?: string;
    /**
     * (experimental) Security Group to use for Control Plane ENIs.
     *
     * @default - A security group is automatically created
     * @experimental
     */
    readonly securityGroup?: ec2.ISecurityGroup;
    /**
     * (experimental) The Kubernetes version to run in the cluster.
     *
     * @default - If not supplied, will use Amazon default version
     * @experimental
     */
    readonly version?: string;
    /**
     * (experimental) An IAM role that will be added to the `system:masters` Kubernetes RBAC group.
     *
     * @default - By default, it will only possible to update this Kubernetes
     *   system by adding resources to this cluster via `addResource` or
     *   by defining `KubernetesResource` resources in your AWS CDK app.
     *   Use this if you wish to grant cluster administration privileges
     *   to another role.
     * @see https://kubernetes.io/docs/reference/access-authn-authz/rbac/#default-roles-and-role-bindings
     * @experimental
     */
    readonly mastersRole?: iam.IRole;
    /**
     * (experimental) Allows defining `kubectrl`-related resources on this cluster.
     *
     * If this is disabled, it will not be possible to use the following
     * capabilities:
     * - `addResource`
     * - `addRoleMapping`
     * - `addUserMapping`
     * - `addMastersRole` and `props.mastersRole`
     *
     * If this is disabled, the cluster can only be managed by issuing `kubectl`
     * commands from a session that uses the IAM role/user that created the
     * account.
     *
     * _NOTE_: changing this value will destoy the cluster. This is because a
     * managable cluster must be created using an AWS CloudFormation custom
     * resource which executes with an IAM role owned by the CDK app.
     *
     * @default true The cluster can be managed by the AWS CDK application.
     * @experimental
     */
    readonly kubectlEnabled?: boolean;
    /**
     * (experimental) Number of instances to allocate as an initial capacity for this cluster.
     *
     * Instance type can be configured through `defaultCapacityInstanceType`,
     * which defaults to `m5.large`.
     *
     * Use `cluster.addCapacity` to add additional customized capacity. Set this
     * to `0` is you wish to avoid the initial capacity allocation.
     *
     * @default 2
     * @experimental
     */
    readonly defaultCapacity?: number;
    /**
     * (experimental) The instance type to use for the default capacity.
     *
     * This will only be taken
     * into account if `defaultCapacity` is > 0.
     *
     * @default m5.large
     * @experimental
     */
    readonly defaultCapacityInstance?: ec2.InstanceType;
    /**
     * (experimental) Determines whether a CloudFormation output with the name of the cluster will be synthesized.
     *
     * @default false
     * @experimental
     */
    readonly outputClusterName?: boolean;
    /**
     * (experimental) Determines whether a CloudFormation output with the ARN of the "masters" IAM role will be synthesized (if `mastersRole` is specified).
     *
     * @default false
     * @experimental
     */
    readonly outputMastersRoleArn?: boolean;
    /**
     * (experimental) Determines whether a CloudFormation output with the `aws eks update-kubeconfig` command will be synthesized.
     *
     * This command will include
     * the cluster name and, if applicable, the ARN of the masters IAM role.
     *
     * @default true
     * @experimental
     */
    readonly outputConfigCommand?: boolean;
}
/**
 * (experimental) A Cluster represents a managed Kubernetes Service (EKS).
 *
 * This is a fully managed cluster of API Servers (control-plane)
 * The user is still required to create the worker nodes.
 *
 * @experimental
 * @resource AWS::EKS::Cluster
 */
export declare class Cluster extends Resource implements ICluster {
    /**
     * (experimental) Import an existing cluster.
     *
     * @param scope the construct scope, in most cases 'this'.
     * @param id the id or name to import as.
     * @param attrs the cluster properties to use for importing information.
     * @experimental
     */
    static fromClusterAttributes(scope: Construct, id: string, attrs: ClusterAttributes): ICluster;
    /**
     * (experimental) The VPC in which this Cluster was created.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (experimental) The Name of the created EKS Cluster.
     *
     * @experimental
     */
    readonly clusterName: string;
    /**
     * (experimental) The AWS generated ARN for the Cluster resource.
     *
     * @experimental
     * @example
     *
     * arn:aws:eks:us-west-2:666666666666:cluster/prod
     */
    readonly clusterArn: string;
    /**
     * (experimental) The endpoint URL for the Cluster.
     *
     * This is the URL inside the kubeconfig file to use with kubectl
     *
     * @experimental
     * @example
     *
     * https://5E1D0CEXAMPLEA591B746AFC5AB30262.yl4.us-west-2.eks.amazonaws.com
     */
    readonly clusterEndpoint: string;
    /**
     * (experimental) The certificate-authority-data for your cluster.
     *
     * @experimental
     */
    readonly clusterCertificateAuthorityData: string;
    /**
     * (experimental) Manages connection rules (Security Group Rules) for the cluster.
     *
     * @experimental
     * @type {ec2.Connections}
     * @memberof Cluster
     */
    readonly connections: ec2.Connections;
    /**
     * (experimental) IAM role assumed by the EKS Control Plane.
     *
     * @experimental
     */
    readonly role: iam.IRole;
    /**
     * (experimental) Indicates if `kubectl` related operations can be performed on this cluster.
     *
     * @experimental
     */
    readonly kubectlEnabled: boolean;
    /**
     * (experimental) The auto scaling group that hosts the default capacity for this cluster.
     *
     * This will be `undefined` if the default capacity is set to 0.
     *
     * @experimental
     */
    readonly defaultCapacity?: autoscaling.AutoScalingGroup;
    /**
     * Manages the aws-auth config map.
     */
    private _awsAuth?;
    private readonly version;
    /**
     * (experimental) Initiates an EKS Cluster with the supplied arguments.
     *
     * @param scope a Construct, most likely a cdk.Stack created.
     * @param props properties in the IClusterProps interface.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: ClusterProps);
    /**
     * (experimental) Add nodes to this EKS cluster.
     *
     * The nodes will automatically be configured with the right VPC and AMI
     * for the instance type and Kubernetes version.
     *
     * Spot instances will be labeled `lifecycle=Ec2Spot` and tainted with `PreferNoSchedule`.
     * If kubectl is enabled, the
     * [spot interrupt handler](https://github.com/awslabs/ec2-spot-labs/tree/master/ec2-spot-eks-solution/spot-termination-handler)
     * daemon will be installed on all spot instances to handle
     * [EC2 Spot Instance Termination Notices](https://aws.amazon.com/blogs/aws/new-ec2-spot-instance-termination-notices/).
     *
     * @experimental
     */
    addCapacity(id: string, options: CapacityOptions): autoscaling.AutoScalingGroup;
    /**
     * (experimental) Add compute capacity to this EKS cluster in the form of an AutoScalingGroup.
     *
     * The AutoScalingGroup must be running an EKS-optimized AMI containing the
     * /etc/eks/bootstrap.sh script. This method will configure Security Groups,
     * add the right policies to the instance role, apply the right tags, and add
     * the required user data to the instance's launch configuration.
     *
     * Spot instances will be labeled `lifecycle=Ec2Spot` and tainted with `PreferNoSchedule`.
     * If kubectl is enabled, the
     * [spot interrupt handler](https://github.com/awslabs/ec2-spot-labs/tree/master/ec2-spot-eks-solution/spot-termination-handler)
     * daemon will be installed on all spot instances to handle
     * [EC2 Spot Instance Termination Notices](https://aws.amazon.com/blogs/aws/new-ec2-spot-instance-termination-notices/).
     *
     * Prefer to use `addCapacity` if possible.
     *
     * @param autoScalingGroup [disable-awslint:ref-via-interface].
     * @param options options for adding auto scaling groups, like customizing the bootstrap script.
     * @see https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html
     * @experimental
     */
    addAutoScalingGroup(autoScalingGroup: autoscaling.AutoScalingGroup, options: AutoScalingGroupOptions): void;
    /**
     * (experimental) Lazily creates the AwsAuth resource, which manages AWS authentication mapping.
     *
     * @experimental
     */
    get awsAuth(): AwsAuth;
    /**
     * (experimental) Defines a Kubernetes resource in this cluster.
     *
     * The manifest will be applied/deleted using kubectl as needed.
     *
     * @param id logical id of this manifest.
     * @param manifest a list of Kubernetes resource specifications.
     * @returns a `KubernetesResource` object.
     * @experimental
     * @throws If `kubectlEnabled` is `false`
     */
    addResource(id: string, ...manifest: any[]): KubernetesResource;
    /**
     * (experimental) Defines a Helm chart in this cluster.
     *
     * @param id logical id of this chart.
     * @param options options of this chart.
     * @returns a `HelmChart` object
     * @experimental
     * @throws If `kubectlEnabled` is `false`
     */
    addChart(id: string, options: HelmChartOptions): HelmChart;
    private createKubernetesResourceHandler;
    /**
     * Opportunistically tag subnets with the required tags.
     *
     * If no subnets could be found (because this is an imported VPC), add a warning.
     *
     * @see https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html
     */
    private tagSubnets;
}
/**
 * (experimental) Options for adding worker nodes.
 *
 * @experimental
 */
export interface CapacityOptions extends autoscaling.CommonAutoScalingGroupProps {
    /**
     * (experimental) Instance type of the instances to start.
     *
     * @experimental
     */
    readonly instanceType: ec2.InstanceType;
    /**
     * (experimental) Will automatically update the aws-auth ConfigMap to map the IAM instance role to RBAC.
     *
     * This cannot be explicitly set to `true` if the cluster has kubectl disabled.
     *
     * @default - true if the cluster has kubectl enabled (which is the default).
     * @experimental
     */
    readonly mapRole?: boolean;
    /**
     * (experimental) Configures the EC2 user-data script for instances in this autoscaling group to bootstrap the node (invoke `/etc/eks/bootstrap.sh`) and associate it with the EKS cluster.
     *
     * If you wish to provide a custom user data script, set this to `false` and
     * manually invoke `autoscalingGroup.addUserData()`.
     *
     * @default true
     * @experimental
     */
    readonly bootstrapEnabled?: boolean;
    /**
     * (experimental) EKS node bootstrapping options.
     *
     * @default - none
     * @experimental
     */
    readonly bootstrapOptions?: BootstrapOptions;
}
/**
 * @experimental
 */
export interface BootstrapOptions {
    /**
     * (experimental) Sets `--max-pods` for the kubelet based on the capacity of the EC2 instance.
     *
     * @default true
     * @experimental
     */
    readonly useMaxPods?: boolean;
    /**
     * (experimental) Restores the docker default bridge network.
     *
     * @default false
     * @experimental
     */
    readonly enableDockerBridge?: boolean;
    /**
     * (experimental) Number of retry attempts for AWS API call (DescribeCluster).
     *
     * @default 3
     * @experimental
     */
    readonly awsApiRetryAttempts?: number;
    /**
     * (experimental) The contents of the `/etc/docker/daemon.json` file. Useful if you want a custom config differing from the default one in the EKS AMI.
     *
     * @default - none
     * @experimental
     */
    readonly dockerConfigJson?: string;
    /**
     * (experimental) Extra arguments to add to the kubelet.
     *
     * Useful for adding labels or taints.
     *
     * @default - none
     * @experimental
     * @example
     *
     * --node-labels foo=bar,goo=far
     */
    readonly kubeletExtraArgs?: string;
    /**
     * (experimental) Additional command line arguments to pass to the `/etc/eks/bootstrap.sh` command.
     *
     * @default - none
     * @see https://github.com/awslabs/amazon-eks-ami/blob/master/files/bootstrap.sh
     * @experimental
     */
    readonly additionalArgs?: string;
}
/**
 * (experimental) Options for adding an AutoScalingGroup as capacity.
 *
 * @experimental
 */
export interface AutoScalingGroupOptions {
    /**
     * (experimental) Will automatically update the aws-auth ConfigMap to map the IAM instance role to RBAC.
     *
     * This cannot be explicitly set to `true` if the cluster has kubectl disabled.
     *
     * @default - true if the cluster has kubectl enabled (which is the default).
     * @experimental
     */
    readonly mapRole?: boolean;
    /**
     * (experimental) Configures the EC2 user-data script for instances in this autoscaling group to bootstrap the node (invoke `/etc/eks/bootstrap.sh`) and associate it with the EKS cluster.
     *
     * If you wish to provide a custom user data script, set this to `false` and
     * manually invoke `autoscalingGroup.addUserData()`.
     *
     * @default true
     * @experimental
     */
    readonly bootstrapEnabled?: boolean;
    /**
     * (experimental) Allows options for node bootstrapping through EC2 user data.
     *
     * @experimental
     */
    readonly bootstrapOptions?: BootstrapOptions;
}
/**
 * (experimental) Properties for EksOptimizedImage.
 *
 * @experimental
 */
export interface EksOptimizedImageProps {
    /**
     * (experimental) What instance type to retrieve the image for (standard or GPU-optimized).
     *
     * @default NodeType.STANDARD
     * @experimental
     */
    readonly nodeType?: NodeType;
    /**
     * (experimental) The Kubernetes version to use.
     *
     * @default - The latest version
     * @experimental
     */
    readonly kubernetesVersion?: string;
}
/**
 * (experimental) Construct an Amazon Linux 2 image from the latest EKS Optimized AMI published in SSM.
 *
 * @experimental
 */
export declare class EksOptimizedImage implements ec2.IMachineImage {
    private readonly nodeType?;
    private readonly kubernetesVersion?;
    private readonly amiParameterName;
    /**
     * (experimental) Constructs a new instance of the EcsOptimizedAmi class.
     *
     * @experimental
     */
    constructor(props: EksOptimizedImageProps);
    /**
     * (experimental) Return the correct image.
     *
     * @experimental
     */
    getImage(scope: Construct): ec2.MachineImageConfig;
}
/**
 * (experimental) Whether the worker nodes should support GPU or just standard instances.
 *
 * @experimental
 */
export declare enum NodeType {
    /**
     * (experimental) Standard instances.
     *
     * @experimental
     */
    STANDARD = "Standard",
    /**
     * (experimental) GPU instances.
     *
     * @experimental
     */
    GPU = "GPU"
}
export declare function nodeTypeForInstanceType(instanceType: ec2.InstanceType): NodeType;
