"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogDrivers = void 0;
const aws_log_driver_1 = require("./aws-log-driver");
const firelens_log_driver_1 = require("./firelens-log-driver");
const fluentd_log_driver_1 = require("./fluentd-log-driver");
const gelf_log_driver_1 = require("./gelf-log-driver");
const journald_log_driver_1 = require("./journald-log-driver");
const json_file_log_driver_1 = require("./json-file-log-driver");
const splunk_log_driver_1 = require("./splunk-log-driver");
const syslog_log_driver_1 = require("./syslog-log-driver");
/**
 * (experimental) The base class for log drivers.
 *
 * @experimental
 */
class LogDrivers {
    /**
     * (experimental) Creates a log driver configuration that sends log information to CloudWatch Logs.
     *
     * @experimental
     */
    static awsLogs(props) {
        return new aws_log_driver_1.AwsLogDriver(props);
    }
    /**
     * (experimental) Creates a log driver configuration that sends log information to fluentd Logs.
     *
     * @experimental
     */
    static fluentd(props) {
        return new fluentd_log_driver_1.FluentdLogDriver(props);
    }
    /**
     * (experimental) Creates a log driver configuration that sends log information to gelf Logs.
     *
     * @experimental
     */
    static gelf(props) {
        return new gelf_log_driver_1.GelfLogDriver(props);
    }
    /**
     * (experimental) Creates a log driver configuration that sends log information to journald Logs.
     *
     * @experimental
     */
    static journald(props) {
        return new journald_log_driver_1.JournaldLogDriver(props);
    }
    /**
     * (experimental) Creates a log driver configuration that sends log information to json-file Logs.
     *
     * @experimental
     */
    static jsonFile(props) {
        return new json_file_log_driver_1.JsonFileLogDriver(props);
    }
    /**
     * (experimental) Creates a log driver configuration that sends log information to splunk Logs.
     *
     * @experimental
     */
    static splunk(props) {
        return new splunk_log_driver_1.SplunkLogDriver(props);
    }
    /**
     * (experimental) Creates a log driver configuration that sends log information to syslog Logs.
     *
     * @experimental
     */
    static syslog(props) {
        return new syslog_log_driver_1.SyslogLogDriver(props);
    }
    /**
     * (experimental) Creates a log driver configuration that sends log information to firelens log router.
     *
     * For detail configurations, please refer to Amazon ECS FireLens Examples:
     * https://github.com/aws-samples/amazon-ecs-firelens-examples
     *
     * @experimental
     */
    static firelens(props) {
        return new firelens_log_driver_1.FireLensLogDriver(props);
    }
}
exports.LogDrivers = LogDrivers;
//# sourceMappingURL=data:application/json;base64,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