import { ContainerDefinition } from '../container-definition';
import { AwsLogDriverProps } from './aws-log-driver';
import { Construct as CoreConstruct } from "../../../core";
/**
 * (experimental) The base class for log drivers.
 *
 * @experimental
 */
export declare abstract class LogDriver {
    /**
     * (experimental) Creates a log driver configuration that sends log information to CloudWatch Logs.
     *
     * @experimental
     */
    static awsLogs(props: AwsLogDriverProps): LogDriver;
    /**
     * (experimental) Called when the log driver is configured on a container.
     *
     * @experimental
     */
    abstract bind(scope: CoreConstruct, containerDefinition: ContainerDefinition): LogDriverConfig;
}
/**
 * (experimental) The configuration to use when creating a log driver.
 *
 * @experimental
 */
export interface LogDriverConfig {
    /**
     * (experimental) The log driver to use for the container.
     *
     * The valid values listed for this parameter are log drivers
     * that the Amazon ECS container agent can communicate with by default.
     *
     * For tasks using the Fargate launch type, the supported log drivers are awslogs, splunk, and awsfirelens.
     * For tasks using the EC2 launch type, the supported log drivers are awslogs, fluentd, gelf, json-file, journald,
     * logentries,syslog, splunk, and awsfirelens.
     *
     * For more information about using the awslogs log driver, see
     * [Using the awslogs Log Driver](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_awslogs.html)
     * in the Amazon Elastic Container Service Developer Guide.
     *
     * For more information about using the awsfirelens log driver, see
     * [Custom Log Routing](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html)
     * in the Amazon Elastic Container Service Developer Guide.
     *
     * @experimental
     */
    readonly logDriver: string;
    /**
     * (experimental) The configuration options to send to the log driver.
     *
     * @experimental
     */
    readonly options?: {
        [key: string]: string;
    };
}
