import { ContainerDefinition } from '../container-definition';
import { BaseLogDriverProps } from './base-log-driver';
import { LogDriver, LogDriverConfig } from './log-driver';
import { Construct as CoreConstruct } from "../../../core";
/**
 * (experimental) Specifies the json-file log driver configuration options.
 *
 * [Source](https://docs.docker.com/config/containers/logging/json-file/)
 *
 * @experimental
 */
export interface JsonFileLogDriverProps extends BaseLogDriverProps {
    /**
     * (experimental) The maximum size of the log before it is rolled.
     *
     * A positive integer plus a modifier
     * representing the unit of measure (k, m, or g).
     *
     * @default - -1 (unlimited)
     * @experimental
     */
    readonly maxSize?: string;
    /**
     * (experimental) The maximum number of log files that can be present.
     *
     * If rolling the logs creates
     * excess files, the oldest file is removed. Only effective when max-size is also set.
     * A positive integer.
     *
     * @default - 1
     * @experimental
     */
    readonly maxFile?: number;
    /**
     * (experimental) Toggles compression for rotated logs.
     *
     * @default - false
     * @experimental
     */
    readonly compress?: boolean;
}
/**
 * (experimental) A log driver that sends log information to json-file Logs.
 *
 * @experimental
 */
export declare class JsonFileLogDriver extends LogDriver {
    private readonly props;
    /**
     * (experimental) Constructs a new instance of the JsonFileLogDriver class.
     *
     * @param props the json-file log driver configuration options.
     * @experimental
     */
    constructor(props?: JsonFileLogDriverProps);
    /**
     * (experimental) Called when the log driver is configured on a container.
     *
     * @experimental
     */
    bind(_scope: CoreConstruct, _containerDefinition: ContainerDefinition): LogDriverConfig;
}
