import { ContainerDefinition } from '../container-definition';
import { BaseLogDriverProps } from './base-log-driver';
import { LogDriver, LogDriverConfig } from './log-driver';
import { Construct as CoreConstruct } from "../../../core";
/**
 * (experimental) Specifies the journald log driver configuration options.
 *
 * [Source](https://docs.docker.com/config/containers/logging/journald/)
 *
 * @experimental
 */
export interface JournaldLogDriverProps extends BaseLogDriverProps {
}
/**
 * (experimental) A log driver that sends log information to journald Logs.
 *
 * @experimental
 */
export declare class JournaldLogDriver extends LogDriver {
    private readonly props;
    /**
     * (experimental) Constructs a new instance of the JournaldLogDriver class.
     *
     * @param props the journald log driver configuration options.
     * @experimental
     */
    constructor(props?: JournaldLogDriverProps);
    /**
     * (experimental) Called when the log driver is configured on a container.
     *
     * @experimental
     */
    bind(_scope: CoreConstruct, _containerDefinition: ContainerDefinition): LogDriverConfig;
}
