import { Duration } from "../../../core";
import { ContainerDefinition } from '../container-definition';
import { BaseLogDriverProps } from './base-log-driver';
import { LogDriver, LogDriverConfig } from './log-driver';
import { Construct as CoreConstruct } from "../../../core";
/**
 * (experimental) The type of compression the GELF driver uses to compress each log message.
 *
 * @experimental
 */
export declare enum GelfCompressionType {
    /**
     * @experimental
     */
    GZIP = "gzip",
    /**
     * @experimental
     */
    ZLIB = "zlib",
    /**
     * @experimental
     */
    NONE = "none"
}
/**
 * (experimental) Specifies the journald log driver configuration options.
 *
 * [Source](https://docs.docker.com/config/containers/logging/gelf/)
 *
 * @experimental
 */
export interface GelfLogDriverProps extends BaseLogDriverProps {
    /**
     * (experimental) The address of the GELF server.
     *
     * tcp and udp are the only supported URI
     * specifier and you must specify the port.
     *
     * @experimental
     */
    readonly address: string;
    /**
     * (experimental) UDP Only The type of compression the GELF driver uses to compress each log message.
     *
     * Allowed values are gzip, zlib and none.
     *
     * @default - gzip
     * @experimental
     */
    readonly compressionType?: GelfCompressionType;
    /**
     * (experimental) UDP Only The level of compression when gzip or zlib is the gelf-compression-type.
     *
     * An integer in the range of -1 to 9 (BestCompression). Higher levels provide more
     * compression at lower speed. Either -1 or 0 disables compression.
     *
     * @default - 1
     * @experimental
     */
    readonly compressionLevel?: number;
    /**
     * (experimental) TCP Only The maximum number of reconnection attempts when the connection drop.
     *
     * A positive integer.
     *
     * @default - 3
     * @experimental
     */
    readonly tcpMaxReconnect?: number;
    /**
     * (experimental) TCP Only The number of seconds to wait between reconnection attempts.
     *
     * A positive integer.
     *
     * @default - 1
     * @experimental
     */
    readonly tcpReconnectDelay?: Duration;
}
/**
 * (experimental) A log driver that sends log information to journald Logs.
 *
 * @experimental
 */
export declare class GelfLogDriver extends LogDriver {
    private readonly props;
    /**
     * (experimental) Constructs a new instance of the GelfLogDriver class.
     *
     * @param props the gelf log driver configuration options.
     * @experimental
     */
    constructor(props: GelfLogDriverProps);
    /**
     * (experimental) Called when the log driver is configured on a container.
     *
     * @experimental
     */
    bind(_scope: CoreConstruct, _containerDefinition: ContainerDefinition): LogDriverConfig;
}
