"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TmpfsMountOption = exports.DevicePermission = exports.Capability = exports.LinuxParameters = void 0;
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * (experimental) Linux-specific options that are applied to the container.
 *
 * @experimental
 */
class LinuxParameters extends cdk.Construct {
    /**
     * (experimental) Constructs a new instance of the LinuxParameters class.
     *
     * @experimental
     */
    constructor(scope, id, props = {}) {
        super(scope, id);
        /**
         * Capabilities to be added
         */
        this.capAdd = new Array();
        /**
         * Capabilities to be dropped
         */
        this.capDrop = new Array();
        /**
         * Device mounts
         */
        this.devices = new Array();
        /**
         * TmpFs mounts
         */
        this.tmpfs = new Array();
        this.sharedMemorySize = props.sharedMemorySize;
        this.initProcessEnabled = props.initProcessEnabled;
    }
    /**
     * (experimental) Adds one or more Linux capabilities to the Docker configuration of a container.
     *
     * Only works with EC2 launch type.
     *
     * @experimental
     */
    addCapabilities(...cap) {
        this.capAdd.push(...cap);
    }
    /**
     * (experimental) Removes one or more Linux capabilities to the Docker configuration of a container.
     *
     * Only works with EC2 launch type.
     *
     * @experimental
     */
    dropCapabilities(...cap) {
        this.capDrop.push(...cap);
    }
    /**
     * (experimental) Adds one or more host devices to a container.
     *
     * @experimental
     */
    addDevices(...device) {
        this.devices.push(...device);
    }
    /**
     * (experimental) Specifies the container path, mount options, and size (in MiB) of the tmpfs mount for a container.
     *
     * Only works with EC2 launch type.
     *
     * @experimental
     */
    addTmpfs(...tmpfs) {
        this.tmpfs.push(...tmpfs);
    }
    /**
     * (experimental) Renders the Linux parameters to a CloudFormation object.
     *
     * @experimental
     */
    renderLinuxParameters() {
        return {
            initProcessEnabled: this.initProcessEnabled,
            sharedMemorySize: this.sharedMemorySize,
            capabilities: {
                add: cdk.Lazy.listValue({ produce: () => this.capAdd }, { omitEmpty: true }),
                drop: cdk.Lazy.listValue({ produce: () => this.capDrop }, { omitEmpty: true }),
            },
            devices: cdk.Lazy.anyValue({ produce: () => this.devices.map(renderDevice) }, { omitEmptyArray: true }),
            tmpfs: cdk.Lazy.anyValue({ produce: () => this.tmpfs.map(renderTmpfs) }, { omitEmptyArray: true }),
        };
    }
}
exports.LinuxParameters = LinuxParameters;
function renderDevice(device) {
    return {
        containerPath: device.containerPath,
        hostPath: device.hostPath,
        permissions: device.permissions,
    };
}
function renderTmpfs(tmpfs) {
    return {
        containerPath: tmpfs.containerPath,
        size: tmpfs.size,
        mountOptions: tmpfs.mountOptions,
    };
}
/**
 * (experimental) A Linux capability.
 *
 * @experimental
 */
var Capability;
(function (Capability) {
    Capability["ALL"] = "ALL";
    Capability["AUDIT_CONTROL"] = "AUDIT_CONTROL";
    Capability["AUDIT_WRITE"] = "AUDIT_WRITE";
    Capability["BLOCK_SUSPEND"] = "BLOCK_SUSPEND";
    Capability["CHOWN"] = "CHOWN";
    Capability["DAC_OVERRIDE"] = "DAC_OVERRIDE";
    Capability["DAC_READ_SEARCH"] = "DAC_READ_SEARCH";
    Capability["FOWNER"] = "FOWNER";
    Capability["FSETID"] = "FSETID";
    Capability["IPC_LOCK"] = "IPC_LOCK";
    Capability["IPC_OWNER"] = "IPC_OWNER";
    Capability["KILL"] = "KILL";
    Capability["LEASE"] = "LEASE";
    Capability["LINUX_IMMUTABLE"] = "LINUX_IMMUTABLE";
    Capability["MAC_ADMIN"] = "MAC_ADMIN";
    Capability["MAC_OVERRIDE"] = "MAC_OVERRIDE";
    Capability["MKNOD"] = "MKNOD";
    Capability["NET_ADMIN"] = "NET_ADMIN";
    Capability["NET_BIND_SERVICE"] = "NET_BIND_SERVICE";
    Capability["NET_BROADCAST"] = "NET_BROADCAST";
    Capability["NET_RAW"] = "NET_RAW";
    Capability["SETFCAP"] = "SETFCAP";
    Capability["SETGID"] = "SETGID";
    Capability["SETPCAP"] = "SETPCAP";
    Capability["SETUID"] = "SETUID";
    Capability["SYS_ADMIN"] = "SYS_ADMIN";
    Capability["SYS_BOOT"] = "SYS_BOOT";
    Capability["SYS_CHROOT"] = "SYS_CHROOT";
    Capability["SYS_MODULE"] = "SYS_MODULE";
    Capability["SYS_NICE"] = "SYS_NICE";
    Capability["SYS_PACCT"] = "SYS_PACCT";
    Capability["SYS_PTRACE"] = "SYS_PTRACE";
    Capability["SYS_RAWIO"] = "SYS_RAWIO";
    Capability["SYS_RESOURCE"] = "SYS_RESOURCE";
    Capability["SYS_TIME"] = "SYS_TIME";
    Capability["SYS_TTY_CONFIG"] = "SYS_TTY_CONFIG";
    Capability["SYSLOG"] = "SYSLOG";
    Capability["WAKE_ALARM"] = "WAKE_ALARM";
})(Capability = exports.Capability || (exports.Capability = {}));
/**
 * (experimental) Permissions for device access.
 *
 * @experimental
 */
var DevicePermission;
(function (DevicePermission) {
    DevicePermission["READ"] = "read";
    DevicePermission["WRITE"] = "write";
    DevicePermission["MKNOD"] = "mknod";
})(DevicePermission = exports.DevicePermission || (exports.DevicePermission = {}));
/**
 * (experimental) The supported options for a tmpfs mount for a container.
 *
 * @experimental
 */
var TmpfsMountOption;
(function (TmpfsMountOption) {
    TmpfsMountOption["DEFAULTS"] = "defaults";
    TmpfsMountOption["RO"] = "ro";
    TmpfsMountOption["RW"] = "rw";
    TmpfsMountOption["SUID"] = "suid";
    TmpfsMountOption["NOSUID"] = "nosuid";
    TmpfsMountOption["DEV"] = "dev";
    TmpfsMountOption["NODEV"] = "nodev";
    TmpfsMountOption["EXEC"] = "exec";
    TmpfsMountOption["NOEXEC"] = "noexec";
    TmpfsMountOption["SYNC"] = "sync";
    TmpfsMountOption["ASYNC"] = "async";
    TmpfsMountOption["DIRSYNC"] = "dirsync";
    TmpfsMountOption["REMOUNT"] = "remount";
    TmpfsMountOption["MAND"] = "mand";
    TmpfsMountOption["NOMAND"] = "nomand";
    TmpfsMountOption["ATIME"] = "atime";
    TmpfsMountOption["NOATIME"] = "noatime";
    TmpfsMountOption["DIRATIME"] = "diratime";
    TmpfsMountOption["NODIRATIME"] = "nodiratime";
    TmpfsMountOption["BIND"] = "bind";
    TmpfsMountOption["RBIND"] = "rbind";
    TmpfsMountOption["UNBINDABLE"] = "unbindable";
    TmpfsMountOption["RUNBINDABLE"] = "runbindable";
    TmpfsMountOption["PRIVATE"] = "private";
    TmpfsMountOption["RPRIVATE"] = "rprivate";
    TmpfsMountOption["SHARED"] = "shared";
    TmpfsMountOption["RSHARED"] = "rshared";
    TmpfsMountOption["SLAVE"] = "slave";
    TmpfsMountOption["RSLAVE"] = "rslave";
    TmpfsMountOption["RELATIME"] = "relatime";
    TmpfsMountOption["NORELATIME"] = "norelatime";
    TmpfsMountOption["STRICTATIME"] = "strictatime";
    TmpfsMountOption["NOSTRICTATIME"] = "nostrictatime";
    TmpfsMountOption["MODE"] = "mode";
    TmpfsMountOption["UID"] = "uid";
    TmpfsMountOption["GID"] = "gid";
    TmpfsMountOption["NR_INODES"] = "nr_inodes";
    TmpfsMountOption["NR_BLOCKS"] = "nr_blocks";
    TmpfsMountOption["MPOL"] = "mpol";
})(TmpfsMountOption = exports.TmpfsMountOption || (exports.TmpfsMountOption = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGludXgtcGFyYW1ldGVycy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImxpbnV4LXBhcmFtZXRlcnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsa0NBQWtDLENBQUMsZ0RBQWdEOzs7Ozs7QUF1Qm5GLE1BQWEsZUFBZ0IsU0FBUSxHQUFHLENBQUMsU0FBUzs7Ozs7O0lBNEI5QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLFFBQThCLEVBQUU7UUFDdEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQXBCckI7O1dBRUc7UUFDYyxXQUFNLEdBQUcsSUFBSSxLQUFLLEVBQWMsQ0FBQztRQUNsRDs7V0FFRztRQUNjLFlBQU8sR0FBRyxJQUFJLEtBQUssRUFBYyxDQUFDO1FBQ25EOztXQUVHO1FBQ2MsWUFBTyxHQUFHLElBQUksS0FBSyxFQUFVLENBQUM7UUFDL0M7O1dBRUc7UUFDYyxVQUFLLEdBQUcsSUFBSSxLQUFLLEVBQVMsQ0FBQztRQU14QyxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsS0FBSyxDQUFDLGdCQUFnQixDQUFDO1FBQy9DLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUMsa0JBQWtCLENBQUM7SUFDdkQsQ0FBQzs7Ozs7Ozs7SUFNTSxlQUFlLENBQUMsR0FBRyxHQUFpQjtRQUN2QyxJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxHQUFHLEdBQUcsQ0FBQyxDQUFDO0lBQzdCLENBQUM7Ozs7Ozs7O0lBTU0sZ0JBQWdCLENBQUMsR0FBRyxHQUFpQjtRQUN4QyxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxHQUFHLEdBQUcsQ0FBQyxDQUFDO0lBQzlCLENBQUM7Ozs7OztJQUlNLFVBQVUsQ0FBQyxHQUFHLE1BQWdCO1FBQ2pDLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLEdBQUcsTUFBTSxDQUFDLENBQUM7SUFDakMsQ0FBQzs7Ozs7Ozs7SUFNTSxRQUFRLENBQUMsR0FBRyxLQUFjO1FBQzdCLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLEdBQUcsS0FBSyxDQUFDLENBQUM7SUFDOUIsQ0FBQzs7Ozs7O0lBSU0scUJBQXFCO1FBQ3hCLE9BQU87WUFDSCxrQkFBa0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCO1lBQzNDLGdCQUFnQixFQUFFLElBQUksQ0FBQyxnQkFBZ0I7WUFDdkMsWUFBWSxFQUFFO2dCQUNWLEdBQUcsRUFBRSxHQUFHLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxFQUFFLE9BQU8sRUFBRSxHQUFHLEVBQUUsQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLEVBQUUsRUFBRSxTQUFTLEVBQUUsSUFBSSxFQUFFLENBQUM7Z0JBQzVFLElBQUksRUFBRSxHQUFHLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxFQUFFLE9BQU8sRUFBRSxHQUFHLEVBQUUsQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLEVBQUUsRUFBRSxTQUFTLEVBQUUsSUFBSSxFQUFFLENBQUM7YUFDakY7WUFDRCxPQUFPLEVBQUUsR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsRUFBRSxPQUFPLEVBQUUsR0FBRyxFQUFFLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsWUFBWSxDQUFDLEVBQUUsRUFBRSxFQUFFLGNBQWMsRUFBRSxJQUFJLEVBQUUsQ0FBQztZQUN2RyxLQUFLLEVBQUUsR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsRUFBRSxPQUFPLEVBQUUsR0FBRyxFQUFFLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsV0FBVyxDQUFDLEVBQUUsRUFBRSxFQUFFLGNBQWMsRUFBRSxJQUFJLEVBQUUsQ0FBQztTQUNyRyxDQUFDO0lBQ04sQ0FBQztDQUNKO0FBOUVELDBDQThFQztBQXVCRCxTQUFTLFlBQVksQ0FBQyxNQUFjO0lBQ2hDLE9BQU87UUFDSCxhQUFhLEVBQUUsTUFBTSxDQUFDLGFBQWE7UUFDbkMsUUFBUSxFQUFFLE1BQU0sQ0FBQyxRQUFRO1FBQ3pCLFdBQVcsRUFBRSxNQUFNLENBQUMsV0FBVztLQUNsQyxDQUFDO0FBQ04sQ0FBQztBQW1CRCxTQUFTLFdBQVcsQ0FBQyxLQUFZO0lBQzdCLE9BQU87UUFDSCxhQUFhLEVBQUUsS0FBSyxDQUFDLGFBQWE7UUFDbEMsSUFBSSxFQUFFLEtBQUssQ0FBQyxJQUFJO1FBQ2hCLFlBQVksRUFBRSxLQUFLLENBQUMsWUFBWTtLQUNuQyxDQUFDO0FBQ04sQ0FBQzs7Ozs7O0FBSUQsSUFBWSxVQXVDWDtBQXZDRCxXQUFZLFVBQVU7SUFDbEIseUJBQVcsQ0FBQTtJQUNYLDZDQUErQixDQUFBO0lBQy9CLHlDQUEyQixDQUFBO0lBQzNCLDZDQUErQixDQUFBO0lBQy9CLDZCQUFlLENBQUE7SUFDZiwyQ0FBNkIsQ0FBQTtJQUM3QixpREFBbUMsQ0FBQTtJQUNuQywrQkFBaUIsQ0FBQTtJQUNqQiwrQkFBaUIsQ0FBQTtJQUNqQixtQ0FBcUIsQ0FBQTtJQUNyQixxQ0FBdUIsQ0FBQTtJQUN2QiwyQkFBYSxDQUFBO0lBQ2IsNkJBQWUsQ0FBQTtJQUNmLGlEQUFtQyxDQUFBO0lBQ25DLHFDQUF1QixDQUFBO0lBQ3ZCLDJDQUE2QixDQUFBO0lBQzdCLDZCQUFlLENBQUE7SUFDZixxQ0FBdUIsQ0FBQTtJQUN2QixtREFBcUMsQ0FBQTtJQUNyQyw2Q0FBK0IsQ0FBQTtJQUMvQixpQ0FBbUIsQ0FBQTtJQUNuQixpQ0FBbUIsQ0FBQTtJQUNuQiwrQkFBaUIsQ0FBQTtJQUNqQixpQ0FBbUIsQ0FBQTtJQUNuQiwrQkFBaUIsQ0FBQTtJQUNqQixxQ0FBdUIsQ0FBQTtJQUN2QixtQ0FBcUIsQ0FBQTtJQUNyQix1Q0FBeUIsQ0FBQTtJQUN6Qix1Q0FBeUIsQ0FBQTtJQUN6QixtQ0FBcUIsQ0FBQTtJQUNyQixxQ0FBdUIsQ0FBQTtJQUN2Qix1Q0FBeUIsQ0FBQTtJQUN6QixxQ0FBdUIsQ0FBQTtJQUN2QiwyQ0FBNkIsQ0FBQTtJQUM3QixtQ0FBcUIsQ0FBQTtJQUNyQiwrQ0FBaUMsQ0FBQTtJQUNqQywrQkFBaUIsQ0FBQTtJQUNqQix1Q0FBeUIsQ0FBQTtBQUM3QixDQUFDLEVBdkNXLFVBQVUsR0FBVixrQkFBVSxLQUFWLGtCQUFVLFFBdUNyQjs7Ozs7O0FBSUQsSUFBWSxnQkFhWDtBQWJELFdBQVksZ0JBQWdCO0lBSXhCLGlDQUFhLENBQUE7SUFJYixtQ0FBZSxDQUFBO0lBSWYsbUNBQWUsQ0FBQTtBQUNuQixDQUFDLEVBYlcsZ0JBQWdCLEdBQWhCLHdCQUFnQixLQUFoQix3QkFBZ0IsUUFhM0I7Ozs7OztBQUlELElBQVksZ0JBd0NYO0FBeENELFdBQVksZ0JBQWdCO0lBQ3hCLHlDQUFxQixDQUFBO0lBQ3JCLDZCQUFTLENBQUE7SUFDVCw2QkFBUyxDQUFBO0lBQ1QsaUNBQWEsQ0FBQTtJQUNiLHFDQUFpQixDQUFBO0lBQ2pCLCtCQUFXLENBQUE7SUFDWCxtQ0FBZSxDQUFBO0lBQ2YsaUNBQWEsQ0FBQTtJQUNiLHFDQUFpQixDQUFBO0lBQ2pCLGlDQUFhLENBQUE7SUFDYixtQ0FBZSxDQUFBO0lBQ2YsdUNBQW1CLENBQUE7SUFDbkIsdUNBQW1CLENBQUE7SUFDbkIsaUNBQWEsQ0FBQTtJQUNiLHFDQUFpQixDQUFBO0lBQ2pCLG1DQUFlLENBQUE7SUFDZix1Q0FBbUIsQ0FBQTtJQUNuQix5Q0FBcUIsQ0FBQTtJQUNyQiw2Q0FBeUIsQ0FBQTtJQUN6QixpQ0FBYSxDQUFBO0lBQ2IsbUNBQWUsQ0FBQTtJQUNmLDZDQUF5QixDQUFBO0lBQ3pCLCtDQUEyQixDQUFBO0lBQzNCLHVDQUFtQixDQUFBO0lBQ25CLHlDQUFxQixDQUFBO0lBQ3JCLHFDQUFpQixDQUFBO0lBQ2pCLHVDQUFtQixDQUFBO0lBQ25CLG1DQUFlLENBQUE7SUFDZixxQ0FBaUIsQ0FBQTtJQUNqQix5Q0FBcUIsQ0FBQTtJQUNyQiw2Q0FBeUIsQ0FBQTtJQUN6QiwrQ0FBMkIsQ0FBQTtJQUMzQixtREFBK0IsQ0FBQTtJQUMvQixpQ0FBYSxDQUFBO0lBQ2IsK0JBQVcsQ0FBQTtJQUNYLCtCQUFXLENBQUE7SUFDWCwyQ0FBdUIsQ0FBQTtJQUN2QiwyQ0FBdUIsQ0FBQTtJQUN2QixpQ0FBYSxDQUFBO0FBQ2pCLENBQUMsRUF4Q1csZ0JBQWdCLEdBQWhCLHdCQUFnQixLQUFoQix3QkFBZ0IsUUF3QzNCIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gXCIuLi8uLi9jb3JlXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9jb3JlJ1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBDZm5UYXNrRGVmaW5pdGlvbiB9IGZyb20gJy4vZWNzLmdlbmVyYXRlZCc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgTGludXhQYXJhbWV0ZXJzUHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgaW5pdFByb2Nlc3NFbmFibGVkPzogYm9vbGVhbjtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgc2hhcmVkTWVtb3J5U2l6ZT86IG51bWJlcjtcbn1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgTGludXhQYXJhbWV0ZXJzIGV4dGVuZHMgY2RrLkNvbnN0cnVjdCB7XG4gICAgLyoqXG4gICAgICogV2hldGhlciB0aGUgaW5pdCBwcm9jZXNzIGlzIGVuYWJsZWRcbiAgICAgKi9cbiAgICBwcml2YXRlIHJlYWRvbmx5IGluaXRQcm9jZXNzRW5hYmxlZD86IGJvb2xlYW47XG4gICAgLyoqXG4gICAgICogVGhlIHNoYXJlZCBtZW1vcnkgc2l6ZS4gTm90IHZhbGlkIGZvciBGYXJnYXRlIGxhdW5jaCB0eXBlXG4gICAgICovXG4gICAgcHJpdmF0ZSByZWFkb25seSBzaGFyZWRNZW1vcnlTaXplPzogbnVtYmVyO1xuICAgIC8qKlxuICAgICAqIENhcGFiaWxpdGllcyB0byBiZSBhZGRlZFxuICAgICAqL1xuICAgIHByaXZhdGUgcmVhZG9ubHkgY2FwQWRkID0gbmV3IEFycmF5PENhcGFiaWxpdHk+KCk7XG4gICAgLyoqXG4gICAgICogQ2FwYWJpbGl0aWVzIHRvIGJlIGRyb3BwZWRcbiAgICAgKi9cbiAgICBwcml2YXRlIHJlYWRvbmx5IGNhcERyb3AgPSBuZXcgQXJyYXk8Q2FwYWJpbGl0eT4oKTtcbiAgICAvKipcbiAgICAgKiBEZXZpY2UgbW91bnRzXG4gICAgICovXG4gICAgcHJpdmF0ZSByZWFkb25seSBkZXZpY2VzID0gbmV3IEFycmF5PERldmljZT4oKTtcbiAgICAvKipcbiAgICAgKiBUbXBGcyBtb3VudHNcbiAgICAgKi9cbiAgICBwcml2YXRlIHJlYWRvbmx5IHRtcGZzID0gbmV3IEFycmF5PFRtcGZzPigpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IExpbnV4UGFyYW1ldGVyc1Byb3BzID0ge30pIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICAgICAgdGhpcy5zaGFyZWRNZW1vcnlTaXplID0gcHJvcHMuc2hhcmVkTWVtb3J5U2l6ZTtcbiAgICAgICAgdGhpcy5pbml0UHJvY2Vzc0VuYWJsZWQgPSBwcm9wcy5pbml0UHJvY2Vzc0VuYWJsZWQ7XG4gICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgYWRkQ2FwYWJpbGl0aWVzKC4uLmNhcDogQ2FwYWJpbGl0eVtdKSB7XG4gICAgICAgIHRoaXMuY2FwQWRkLnB1c2goLi4uY2FwKTtcbiAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBkcm9wQ2FwYWJpbGl0aWVzKC4uLmNhcDogQ2FwYWJpbGl0eVtdKSB7XG4gICAgICAgIHRoaXMuY2FwRHJvcC5wdXNoKC4uLmNhcCk7XG4gICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBwdWJsaWMgYWRkRGV2aWNlcyguLi5kZXZpY2U6IERldmljZVtdKSB7XG4gICAgICAgIHRoaXMuZGV2aWNlcy5wdXNoKC4uLmRldmljZSk7XG4gICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIGFkZFRtcGZzKC4uLnRtcGZzOiBUbXBmc1tdKSB7XG4gICAgICAgIHRoaXMudG1wZnMucHVzaCguLi50bXBmcyk7XG4gICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyByZW5kZXJMaW51eFBhcmFtZXRlcnMoKTogQ2ZuVGFza0RlZmluaXRpb24uTGludXhQYXJhbWV0ZXJzUHJvcGVydHkge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgaW5pdFByb2Nlc3NFbmFibGVkOiB0aGlzLmluaXRQcm9jZXNzRW5hYmxlZCxcbiAgICAgICAgICAgIHNoYXJlZE1lbW9yeVNpemU6IHRoaXMuc2hhcmVkTWVtb3J5U2l6ZSxcbiAgICAgICAgICAgIGNhcGFiaWxpdGllczoge1xuICAgICAgICAgICAgICAgIGFkZDogY2RrLkxhenkubGlzdFZhbHVlKHsgcHJvZHVjZTogKCkgPT4gdGhpcy5jYXBBZGQgfSwgeyBvbWl0RW1wdHk6IHRydWUgfSksXG4gICAgICAgICAgICAgICAgZHJvcDogY2RrLkxhenkubGlzdFZhbHVlKHsgcHJvZHVjZTogKCkgPT4gdGhpcy5jYXBEcm9wIH0sIHsgb21pdEVtcHR5OiB0cnVlIH0pLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIGRldmljZXM6IGNkay5MYXp5LmFueVZhbHVlKHsgcHJvZHVjZTogKCkgPT4gdGhpcy5kZXZpY2VzLm1hcChyZW5kZXJEZXZpY2UpIH0sIHsgb21pdEVtcHR5QXJyYXk6IHRydWUgfSksXG4gICAgICAgICAgICB0bXBmczogY2RrLkxhenkuYW55VmFsdWUoeyBwcm9kdWNlOiAoKSA9PiB0aGlzLnRtcGZzLm1hcChyZW5kZXJUbXBmcykgfSwgeyBvbWl0RW1wdHlBcnJheTogdHJ1ZSB9KSxcbiAgICAgICAgfTtcbiAgICB9XG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBEZXZpY2Uge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IGNvbnRhaW5lclBhdGg/OiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBob3N0UGF0aDogc3RyaW5nO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBwZXJtaXNzaW9ucz86IERldmljZVBlcm1pc3Npb25bXTtcbn1cbmZ1bmN0aW9uIHJlbmRlckRldmljZShkZXZpY2U6IERldmljZSk6IENmblRhc2tEZWZpbml0aW9uLkRldmljZVByb3BlcnR5IHtcbiAgICByZXR1cm4ge1xuICAgICAgICBjb250YWluZXJQYXRoOiBkZXZpY2UuY29udGFpbmVyUGF0aCxcbiAgICAgICAgaG9zdFBhdGg6IGRldmljZS5ob3N0UGF0aCxcbiAgICAgICAgcGVybWlzc2lvbnM6IGRldmljZS5wZXJtaXNzaW9ucyxcbiAgICB9O1xufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgVG1wZnMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBjb250YWluZXJQYXRoOiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgc2l6ZTogbnVtYmVyO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IG1vdW50T3B0aW9ucz86IFRtcGZzTW91bnRPcHRpb25bXTtcbn1cbmZ1bmN0aW9uIHJlbmRlclRtcGZzKHRtcGZzOiBUbXBmcyk6IENmblRhc2tEZWZpbml0aW9uLlRtcGZzUHJvcGVydHkge1xuICAgIHJldHVybiB7XG4gICAgICAgIGNvbnRhaW5lclBhdGg6IHRtcGZzLmNvbnRhaW5lclBhdGgsXG4gICAgICAgIHNpemU6IHRtcGZzLnNpemUsXG4gICAgICAgIG1vdW50T3B0aW9uczogdG1wZnMubW91bnRPcHRpb25zLFxuICAgIH07XG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGVudW0gQ2FwYWJpbGl0eSB7XG4gICAgQUxMID0gJ0FMTCcsXG4gICAgQVVESVRfQ09OVFJPTCA9ICdBVURJVF9DT05UUk9MJyxcbiAgICBBVURJVF9XUklURSA9ICdBVURJVF9XUklURScsXG4gICAgQkxPQ0tfU1VTUEVORCA9ICdCTE9DS19TVVNQRU5EJyxcbiAgICBDSE9XTiA9ICdDSE9XTicsXG4gICAgREFDX09WRVJSSURFID0gJ0RBQ19PVkVSUklERScsXG4gICAgREFDX1JFQURfU0VBUkNIID0gJ0RBQ19SRUFEX1NFQVJDSCcsXG4gICAgRk9XTkVSID0gJ0ZPV05FUicsXG4gICAgRlNFVElEID0gJ0ZTRVRJRCcsXG4gICAgSVBDX0xPQ0sgPSAnSVBDX0xPQ0snLFxuICAgIElQQ19PV05FUiA9ICdJUENfT1dORVInLFxuICAgIEtJTEwgPSAnS0lMTCcsXG4gICAgTEVBU0UgPSAnTEVBU0UnLFxuICAgIExJTlVYX0lNTVVUQUJMRSA9ICdMSU5VWF9JTU1VVEFCTEUnLFxuICAgIE1BQ19BRE1JTiA9ICdNQUNfQURNSU4nLFxuICAgIE1BQ19PVkVSUklERSA9ICdNQUNfT1ZFUlJJREUnLFxuICAgIE1LTk9EID0gJ01LTk9EJyxcbiAgICBORVRfQURNSU4gPSAnTkVUX0FETUlOJyxcbiAgICBORVRfQklORF9TRVJWSUNFID0gJ05FVF9CSU5EX1NFUlZJQ0UnLFxuICAgIE5FVF9CUk9BRENBU1QgPSAnTkVUX0JST0FEQ0FTVCcsXG4gICAgTkVUX1JBVyA9ICdORVRfUkFXJyxcbiAgICBTRVRGQ0FQID0gJ1NFVEZDQVAnLFxuICAgIFNFVEdJRCA9ICdTRVRHSUQnLFxuICAgIFNFVFBDQVAgPSAnU0VUUENBUCcsXG4gICAgU0VUVUlEID0gJ1NFVFVJRCcsXG4gICAgU1lTX0FETUlOID0gJ1NZU19BRE1JTicsXG4gICAgU1lTX0JPT1QgPSAnU1lTX0JPT1QnLFxuICAgIFNZU19DSFJPT1QgPSAnU1lTX0NIUk9PVCcsXG4gICAgU1lTX01PRFVMRSA9ICdTWVNfTU9EVUxFJyxcbiAgICBTWVNfTklDRSA9ICdTWVNfTklDRScsXG4gICAgU1lTX1BBQ0NUID0gJ1NZU19QQUNDVCcsXG4gICAgU1lTX1BUUkFDRSA9ICdTWVNfUFRSQUNFJyxcbiAgICBTWVNfUkFXSU8gPSAnU1lTX1JBV0lPJyxcbiAgICBTWVNfUkVTT1VSQ0UgPSAnU1lTX1JFU09VUkNFJyxcbiAgICBTWVNfVElNRSA9ICdTWVNfVElNRScsXG4gICAgU1lTX1RUWV9DT05GSUcgPSAnU1lTX1RUWV9DT05GSUcnLFxuICAgIFNZU0xPRyA9ICdTWVNMT0cnLFxuICAgIFdBS0VfQUxBUk0gPSAnV0FLRV9BTEFSTSdcbn1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBlbnVtIERldmljZVBlcm1pc3Npb24ge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgUkVBRCA9ICdyZWFkJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBXUklURSA9ICd3cml0ZScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgTUtOT0QgPSAnbWtub2QnXG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgZW51bSBUbXBmc01vdW50T3B0aW9uIHtcbiAgICBERUZBVUxUUyA9ICdkZWZhdWx0cycsXG4gICAgUk8gPSAncm8nLFxuICAgIFJXID0gJ3J3JyxcbiAgICBTVUlEID0gJ3N1aWQnLFxuICAgIE5PU1VJRCA9ICdub3N1aWQnLFxuICAgIERFViA9ICdkZXYnLFxuICAgIE5PREVWID0gJ25vZGV2JyxcbiAgICBFWEVDID0gJ2V4ZWMnLFxuICAgIE5PRVhFQyA9ICdub2V4ZWMnLFxuICAgIFNZTkMgPSAnc3luYycsXG4gICAgQVNZTkMgPSAnYXN5bmMnLFxuICAgIERJUlNZTkMgPSAnZGlyc3luYycsXG4gICAgUkVNT1VOVCA9ICdyZW1vdW50JyxcbiAgICBNQU5EID0gJ21hbmQnLFxuICAgIE5PTUFORCA9ICdub21hbmQnLFxuICAgIEFUSU1FID0gJ2F0aW1lJyxcbiAgICBOT0FUSU1FID0gJ25vYXRpbWUnLFxuICAgIERJUkFUSU1FID0gJ2RpcmF0aW1lJyxcbiAgICBOT0RJUkFUSU1FID0gJ25vZGlyYXRpbWUnLFxuICAgIEJJTkQgPSAnYmluZCcsXG4gICAgUkJJTkQgPSAncmJpbmQnLFxuICAgIFVOQklOREFCTEUgPSAndW5iaW5kYWJsZScsXG4gICAgUlVOQklOREFCTEUgPSAncnVuYmluZGFibGUnLFxuICAgIFBSSVZBVEUgPSAncHJpdmF0ZScsXG4gICAgUlBSSVZBVEUgPSAncnByaXZhdGUnLFxuICAgIFNIQVJFRCA9ICdzaGFyZWQnLFxuICAgIFJTSEFSRUQgPSAncnNoYXJlZCcsXG4gICAgU0xBVkUgPSAnc2xhdmUnLFxuICAgIFJTTEFWRSA9ICdyc2xhdmUnLFxuICAgIFJFTEFUSU1FID0gJ3JlbGF0aW1lJyxcbiAgICBOT1JFTEFUSU1FID0gJ25vcmVsYXRpbWUnLFxuICAgIFNUUklDVEFUSU1FID0gJ3N0cmljdGF0aW1lJyxcbiAgICBOT1NUUklDVEFUSU1FID0gJ25vc3RyaWN0YXRpbWUnLFxuICAgIE1PREUgPSAnbW9kZScsXG4gICAgVUlEID0gJ3VpZCcsXG4gICAgR0lEID0gJ2dpZCcsXG4gICAgTlJfSU5PREVTID0gJ25yX2lub2RlcycsXG4gICAgTlJfQkxPQ0tTID0gJ25yX2Jsb2NrcycsXG4gICAgTVBPTCA9ICdtcG9sJ1xufVxuIl19