"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RepositoryImage = void 0;
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const container_image_1 = require("../container-image");
/**
 * Regex pattern to check if it is an ECR image URL.
 *
 * @experimental
 */
const ECR_IMAGE_REGEX = /(^[a-zA-Z0-9][a-zA-Z0-9-_]*).dkr.ecr.([a-zA-Z0-9][a-zA-Z0-9-_]*).amazonaws.com(.cn)?\/.*/;
/**
 * (experimental) An image hosted in a public or private repository.
 *
 * For images hosted in Amazon ECR, see
 * [EcrImage](https://docs.aws.amazon.com/AmazonECR/latest/userguide/images.html).
 *
 * @experimental
 */
class RepositoryImage extends container_image_1.ContainerImage {
    /**
     * (experimental) Constructs a new instance of the RepositoryImage class.
     *
     * @experimental
     */
    constructor(imageName, props = {}) {
        super();
        this.imageName = imageName;
        this.props = props;
    }
    /**
     * (experimental) Called when the image is used by a ContainerDefinition.
     *
     * @experimental
     */
    bind(scope, containerDefinition) {
        // name could be a Token - in that case, skip validation altogether
        if (!core_1.Token.isUnresolved(this.imageName) && ECR_IMAGE_REGEX.test(this.imageName)) {
            core_1.Annotations.of(scope).addWarning("Proper policies need to be attached before pulling from ECR repository, or use 'fromEcrRepository'.");
        }
        if (this.props.credentials) {
            this.props.credentials.grantRead(containerDefinition.taskDefinition.obtainExecutionRole());
        }
        return {
            imageName: this.imageName,
            repositoryCredentials: this.props.credentials && {
                credentialsParameter: this.props.credentials.secretArn,
            },
        };
    }
}
exports.RepositoryImage = RepositoryImage;
//# sourceMappingURL=data:application/json;base64,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