import * as secretsmanager from "../../../aws-secretsmanager";
import { ContainerDefinition } from '../container-definition';
import { ContainerImage, ContainerImageConfig } from '../container-image';
import { Construct as CoreConstruct } from "../../../core";
/**
 * (experimental) The properties for an image hosted in a public or private repository.
 *
 * @experimental
 */
export interface RepositoryImageProps {
    /**
     * (experimental) The secret to expose to the container that contains the credentials for the image repository.
     *
     * The supported value is the full ARN of an AWS Secrets Manager secret.
     *
     * @experimental
     */
    readonly credentials?: secretsmanager.ISecret;
}
/**
 * (experimental) An image hosted in a public or private repository.
 *
 * For images hosted in Amazon ECR, see
 * [EcrImage](https://docs.aws.amazon.com/AmazonECR/latest/userguide/images.html).
 *
 * @experimental
 */
export declare class RepositoryImage extends ContainerImage {
    private readonly imageName;
    private readonly props;
    /**
     * (experimental) Constructs a new instance of the RepositoryImage class.
     *
     * @experimental
     */
    constructor(imageName: string, props?: RepositoryImageProps);
    /**
     * (experimental) Called when the image is used by a ContainerDefinition.
     *
     * @experimental
     */
    bind(scope: CoreConstruct, containerDefinition: ContainerDefinition): ContainerImageConfig;
}
