import * as ecr from "../../../aws-ecr";
import { ContainerDefinition } from '../container-definition';
import { ContainerImage, ContainerImageConfig } from '../container-image';
import { Construct as CoreConstruct } from "../../../core";
/**
 * (experimental) An image from an Amazon ECR repository.
 *
 * @experimental
 */
export declare class EcrImage extends ContainerImage {
    private readonly repository;
    private readonly tag;
    /**
     * (experimental) The image name. Images in Amazon ECR repositories can be specified by either using the full registry/repository:tag or registry/repository@digest.
     *
     * For example, 012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>:latest or
     * 012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>@sha256:94afd1f2e64d908bc90dbca0035a5b567EXAMPLE.
     *
     * @experimental
     */
    readonly imageName: string;
    /**
     * (experimental) Constructs a new instance of the EcrImage class.
     *
     * @experimental
     */
    constructor(repository: ecr.IRepository, tag: string);
    /**
     * (experimental) Called when the image is used by a ContainerDefinition.
     *
     * @experimental
     */
    bind(_scope: CoreConstruct, containerDefinition: ContainerDefinition): ContainerImageConfig;
}
