import { DockerImageAssetOptions } from "../../../aws-ecr-assets";
import { ContainerDefinition } from '../container-definition';
import { ContainerImage, ContainerImageConfig } from '../container-image';
import { Construct as CoreConstruct } from "../../../core";
/**
 * (experimental) The properties for building an AssetImage.
 *
 * @experimental
 */
export interface AssetImageProps extends DockerImageAssetOptions {
}
/**
 * (experimental) An image that will be built from a local directory with a Dockerfile.
 *
 * @experimental
 */
export declare class AssetImage extends ContainerImage {
    private readonly directory;
    private readonly props;
    /**
     * (experimental) Constructs a new instance of the AssetImage class.
     *
     * @param directory The directory containing the Dockerfile.
     * @experimental
     */
    constructor(directory: string, props?: AssetImageProps);
    /**
     * (experimental) Called when the image is used by a ContainerDefinition.
     *
     * @experimental
     */
    bind(scope: CoreConstruct, containerDefinition: ContainerDefinition): ContainerImageConfig;
}
